/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.java.b;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.core.a;
import com.contrastsecurity.agent.core.z;
import com.contrastsecurity.agent.h;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.instr.a.c;
import com.contrastsecurity.agent.j.g;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.j;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.d;
import com.contrastsecurity.agent.services.m;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.L;
import com.contrastsecurity.agent.startup.M;
import com.contrastsecurity.agent.startup.P;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.u.B;
import com.contrastsecurity.agent.u.C;
import com.contrastsecurity.agent.util.J;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.agent.util.S;
import com.contrastsecurity.agent.util.k;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@DontObfuscate
public class ContrastEngine
implements j {
    private final j pluginManager;
    private final ScopeProvider scopeProvider;
    private h transformer;
    private final com.contrastsecurity.agent.services.ngreporting.h legacyReportingService;
    private com.contrastsecurity.agent.services.a compositeServices;
    private final List<com.contrastsecurity.agent.services.a> injectedBackgroundServices;
    private final Instrumentation inst;
    private final e config;
    private final d executorServiceModule;
    private final com.contrastsecurity.agent.commons.b clock;
    private final WorkingDirectories directories;
    private final z failureStrategy;
    private final B server;
    private final Queue<b> classLoadEvents;
    private final com.contrastsecurity.agent.logging.c loggerManager;
    private final o errorEmitter;
    private final com.contrastsecurity.agent.telemetry.h startupTimingReporter;
    private final g hierarchyCache;
    private final List<P> startupTasks;
    private final TelemetryMetrics metrics;
    private final com.contrastsecurity.agent.h.a errorHandler;
    private static final Logger logger = LoggerFactory.getLogger(ContrastEngine.class);

    @Override
    public List<ContrastPlugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public void forEachEnabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachEnabled(application, httpRequest, consumer);
    }

    @Override
    public void forEachDisabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachDisabled(application, httpRequest, consumer);
    }

    public o getErrorEmitter() {
        return this.errorEmitter;
    }

    public ContrastEngine(Instrumentation instrumentation, B b2, e e2, List<P> list, com.contrastsecurity.agent.commons.b b3, List<com.contrastsecurity.agent.services.a> list2, j j2, com.contrastsecurity.agent.services.ngreporting.h h2, ScopeProvider scopeProvider, WorkingDirectories workingDirectories, TelemetryMetrics telemetryMetrics, o o2, Queue<b> queue, com.contrastsecurity.agent.logging.c c2, d d2, com.contrastsecurity.agent.telemetry.h h3, g g2, com.contrastsecurity.agent.h.a a2) {
        this.inst = Objects.requireNonNull(instrumentation);
        this.server = Objects.requireNonNull(b2);
        this.config = Objects.requireNonNull(e2);
        this.startupTasks = Lists.copy((Collection)Objects.requireNonNull(list));
        this.injectedBackgroundServices = list2;
        this.clock = Objects.requireNonNull(b3);
        this.pluginManager = Objects.requireNonNull(j2);
        this.executorServiceModule = Objects.requireNonNull(d2);
        this.legacyReportingService = Objects.requireNonNull(h2);
        this.scopeProvider = Objects.requireNonNull(scopeProvider);
        this.directories = Objects.requireNonNull(workingDirectories);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        this.classLoadEvents = Objects.requireNonNull(queue);
        this.loggerManager = Objects.requireNonNull(c2);
        this.errorEmitter = Objects.requireNonNull(o2);
        this.failureStrategy = z.a(e2.a(ConfigProperty.STARTUP_FAILURE_STRATEGY));
        this.startupTimingReporter = Objects.requireNonNull(h3);
        this.hierarchyCache = Objects.requireNonNull(g2);
        this.errorHandler = Objects.requireNonNull(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartupTiming startupTiming) throws FatalStartupException {
        Objects.requireNonNull(startupTiming);
        J j2 = K.b();
        Contrast.starting(this.directories);
        L l2 = this.startupContext();
        l2.a(this.errorHandler);
        j2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-working-dir", j2);
        j2.c();
        try {
            for (P p2 : this.startupTasks) {
                this.doStartupTask(p2, l2);
            }
        }
        catch (FatalStartupException fatalStartupException) {
            this.errorAndPointToLog();
            logger.error("Problem starting up Contrast", fatalStartupException);
            logger.error(this.failureStrategy.b());
            this.failureStrategy.a(fatalStartupException);
            this.ifWebSphereAddFallbackTransformer(l2);
            return;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            this.logUnexpectedError(throwable2, this.failureStrategy.b());
            this.failureStrategy.a(throwable2);
            return;
        }
        finally {
            j2.a();
            for (P p3 : this.startupTasks) {
                p3.onStartupEnd(l2);
            }
        }
        this.transformer = l2.a();
        try {
            this.initBackgroundServicesAndRegisterPlugins(j2, startupTiming);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable3 = throwable;
            PreConfigUtil.err("Error reading Contrast configuration or policy. Are you sure your XML is right? " + this.failureStrategy.b());
            this.failureStrategy.a(throwable3);
            throwable3.printStackTrace(System.err);
        }
    }

    private void ifWebSphereAddFallbackTransformer(L l2) {
        h h2 = l2.a();
        if (h2 == null && M.a(this.server)) {
            logger.debug("Running in WebSphere, PhoneHome to TeamServer failed, attempting to add fallback transformer");
            try {
                this.addWebSphereFallBackTransformer();
                logger.debug("Added WebSphereFallbackTransformer");
                new com.contrastsecurity.agent.startup.S(this.errorEmitter, this.inst).onStartupBegin(l2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                logger.warn("Unable to prepare to correct disabled TLS algorithms in WebSphere", exception2);
            }
        }
    }

    private void addWebSphereFallBackTransformer() {
        new com.contrastsecurity.agent.plugins.frameworks.H.a.a(this.config, this.server, this.hierarchyCache, this.scopeProvider, this.classLoadEvents, this.errorEmitter, this.inst).a();
    }

    private L startupContext() {
        L l2 = new L();
        l2.a(this);
        return l2;
    }

    private void logUnexpectedError(Throwable throwable, String string) {
        this.errorAndPointToLog();
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        PreConfigUtil.err("Unexpected error starting up. " + string + " Exception message [1]: " + string2);
        throwable.printStackTrace(System.err);
        PreConfigUtil.out("Unexpected error starting up. " + string + " Exception message [2]:  " + string2);
    }

    private void doStartupTask(P p2, L l2) throws FatalStartupException {
        J j2 = K.b();
        p2.onStartupBegin(l2);
        j2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, p2.getTaskName(), j2);
    }

    private void initBackgroundServicesAndRegisterPlugins(J j2, StartupTiming startupTiming) {
        logger.info("Installing Contrast plugins...");
        ArrayList<com.contrastsecurity.agent.services.a> arrayList = new ArrayList<com.contrastsecurity.agent.services.a>(this.injectedBackgroundServices);
        if (JVMUtils.isIBMJVM()) {
            logger.info("On IBM JVM, adding zombie watcher thread.");
            arrayList.add(new m(this.config, Suppliers.constant(this), this.errorEmitter, this.executorServiceModule));
        }
        this.compositeServices = new a(this.config, arrayList, this.clock);
        this.compositeServices.a(this.inst, this.pluginManager.getPlugins());
        this.pluginManager.handoffToJVM();
        this.sendServerInfoUpdate();
        this.logStartupMessages(j2, startupTiming);
        Contrast.active(this.directories);
    }

    private void logStartupMessages(J j2, StartupTiming startupTiming) {
        startupTiming.premainEndTimeNs(this.clock.nanoTime());
        long l2 = startupTiming.premainElapsedTimeMs();
        j2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-services-plugins", j2);
        PerfUtil.printStartupTimingMessage(String.format("All Startup Tasks: %s", k.a(l2)));
        logger.info("Beginning application...");
        PreConfigUtil.out("Starting JVM [" + l2 + "ms]");
        ScheduledExecutorService scheduledExecutorService = this.executorServiceModule.b();
        this.startupTimingReporter.b("startupTimeAgent", l2);
        this.metrics.scheduleStartupReporting(scheduledExecutorService, this.config.e(ConfigProperty.AGENT_TELEMETRY_INITIAL_DELAY), this.startupTimingReporter);
    }

    private void sendServerInfoUpdate() {
        C c2 = new C(null, true);
        this.legacyReportingService.a(c2);
    }

    private void errorAndPointToLog() {
        String string = this.config.a(ConfigProperty.LOGGER_LOCATION);
        PreConfigUtil.err("Contrast not enabled. Check log for details - " + string);
    }

    public synchronized void stop() {
        logger.info("Stopping Contrast...");
        Contrast.stopping(this.directories);
        if (this.compositeServices != null) {
            this.compositeServices.a();
        }
        this.pluginManager.deactivatePlugins();
        this.executorServiceModule.close();
        Contrast.inactive(this.directories);
        logger.info("Stopped");
        this.loggerManager.a(this.config.e(ConfigProperty.LOGGER_SHUTDOWN_TIMEOUT), TimeUnit.SECONDS);
    }

    public void deinstrument() {
        this.transformer.b();
        List<Class<?>> list = Arrays.stream(this.inst.getAllLoadedClasses()).filter(this.inst::isModifiableClass).collect(Collectors.toList());
        logger.info("De-instrumenting {} classes", (Object)list.size());
        S.a(this.inst, this.errorEmitter, list);
    }

    @Override
    public void registerPlugin(ContrastPlugin contrastPlugin) {
        this.pluginManager.registerPlugin(contrastPlugin);
    }

    @Override
    public void activatePlugins() {
        this.pluginManager.activatePlugins();
    }

    @Override
    public void deactivatePlugins() {
        this.pluginManager.deactivatePlugins();
    }

    @Override
    public void handoffToJVM() {
        this.pluginManager.handoffToJVM();
    }

    @Override
    public List<c> getDenylistAwarePlugins() {
        return this.pluginManager.getDenylistAwarePlugins();
    }
}

