/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.RequestContextImpl;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.l;
import com.contrastsecurity.agent.http.m;
import com.contrastsecurity.agent.http.q;
import com.contrastsecurity.agent.k.g;
import com.contrastsecurity.agent.k.i;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.messages.mq.MqHttpRequestDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.util.E;
import com.contrastsecurity.agent.util.r;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@DontObfuscate
public final class HttpRequest
extends c
implements com.contrastsecurity.agent.plugins.security.f.f {
    public static final String DEFAULT_REMOTE_IP = "0.0.0.0";
    private static final char BOM = '\ufeff';
    private static final int CONTENT_LENGTH_NOT_SET = -1;
    private Protocol protocol = Protocol.FALLBACK_VALUE;
    private HttpVersion version = HttpVersion.FALLBACK_VALUE;
    private String method;
    private String uri;
    private String normalizedUri;
    private String queryString;
    private String remoteIp;
    private int port;
    private Map<String, String[]> parameters;
    private Map<String, String[]> headers;
    private String contextPath;
    private String serverVersionInfo;
    private boolean parsedParameters;
    private boolean parsedMultipartParameters;
    private Collection<HttpWatcher> responseWatchers;
    private boolean analyzing;
    private h frameworkInfo;
    private int scope;
    private E cachedBody;
    private String cachedBodyStr;
    private String cachedEncodedBodyAsString;
    private HashMap<String, Object> properties;
    private Set<MultipartItem> multipartItems;
    private d cachedContentType;
    private int cachedContentLength = -1;
    private boolean cachedXForwardedFor;
    private String[] cachedXForwardedForHeaders;
    private boolean cachedXForwardedForAsString;
    private String cachedXForwardedForHeadersAsString;
    private int requestID;
    private boolean appendEllipsisBytes;
    private final g jfrEvent;
    private WeakReference<Object> requestObj;
    private String samplingKey;
    private String template;
    private String normalizedTemplate;
    private String path;
    private boolean secure;
    private final HttpRequestType httpRequestType;
    private boolean checkedForDeserializer;
    private int maxRequestBodyBytesCaptured = 4096;
    private final long startTime;
    private final long elapsedTimeMs;
    private final RequestContextImpl context;
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final Map<l, Boolean> sampling = Collections.synchronizedMap(new EnumMap(l.class));
    private static final char[] ALLOWED_BODY_SPECIAL_CHARS = new char[]{'<', '>', '\"', '\'', '&', ';', '[', ']', '{', '}', '!', '@', '#', '$', '%', '^', '_', '-', '+', '=', ':', ';', '.', ',', '(', ')', '?', '|', '\\', '/'};
    private final byte[] ellipsisBytes = "...".getBytes();
    private static final int TARGET_SCOPE = 1;
    private static final m BUFFER = new q();
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    public static final int NOT_CAPTURE_HTTP_REQUEST_BODY = -1;
    private static final int MAX_REQUEST_BYTES_CACHED = 4096;

    @Override
    public String samplingKey() {
        if (this.samplingKey == null) {
            this.samplingKey = this.method + this.normalizedUri;
        }
        return this.samplingKey;
    }

    public int getRequestID() {
        if (this.requestID == 0) {
            this.requestID = System.identityHashCode(this);
        }
        return this.requestID;
    }

    boolean isSampling(l l2, Function<l, Boolean> function) {
        return this.sampling.computeIfAbsent(l2, function);
    }

    public HttpRequest(HttpRequestType httpRequestType) {
        super("request");
        this.properties = new HashMap();
        this.multipartItems = new HashSet<MultipartItem>();
        this.startTime = System.nanoTime();
        this.elapsedTimeMs = -1L;
        this.context = new RequestContextImpl();
        this.jfrEvent = i.b();
        this.httpRequestType = Objects.requireNonNull(httpRequestType);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl2) {
        this.secure = bl2;
    }

    public static boolean isOfType(HttpRequest httpRequest, HttpRequestType httpRequestType) {
        return httpRequest != null && httpRequest.httpRequestType == httpRequestType;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        String string = this.getUri();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(59);
        String string2 = this.getContextPath();
        int n3 = string2 == null ? -1 : string.indexOf(string2);
        String string3 = string.substring(n3 == -1 ? 0 : n3 + this.getContextPath().length(), n2 == -1 ? string.length() : n2);
        string3 = string3.startsWith("/") ? string3 : "/" + string3;
        try {
            string3 = URLDecoder.decode(string3, Charset.defaultCharset().toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.path = string3;
        return this.path;
    }

    public void setOriginalRequest(WeakReference<Object> weakReference) {
        this.requestObj = weakReference;
    }

    public WeakReference<Object> getOriginalRequest() {
        return this.requestObj;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean endRequest() {
        return this.active.getAndSet(false);
    }

    public boolean isSameRequest(Object object) {
        if (object == null || this.requestObj == null) {
            return false;
        }
        return this.requestObj.get() == object;
    }

    public boolean isCurrentActiveRequest(Object object) {
        return this.isActive() && this.isSameRequest(object);
    }

    public com.contrastsecurity.agent.context.f context() {
        return this.context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public HttpRequest setContextPath(String string) {
        this.contextPath = string;
        return this;
    }

    public String[] getXForwardedFor() {
        if (!this.cachedXForwardedFor) {
            this.cachedXForwardedForHeaders = this.getHeaders("X-Forwarded-For");
            this.cachedXForwardedFor = true;
        }
        return this.cachedXForwardedForHeaders;
    }

    public String getXForwardedForAsString() {
        if (!this.cachedXForwardedForAsString) {
            StringBuilder stringBuilder = new StringBuilder(64);
            String[] stringArray = this.getXForwardedFor();
            if (stringArray != null) {
                for (String string : stringArray) {
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        char c2 = string.charAt(i2);
                        if (c2 == ' ') continue;
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(',');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            this.cachedXForwardedForHeadersAsString = stringBuilder.toString();
            this.cachedXForwardedForAsString = true;
        }
        return this.cachedXForwardedForHeadersAsString;
    }

    public d getContentType() {
        if (this.cachedContentType != null) {
            return this.cachedContentType;
        }
        this.cachedContentType = d.a(this.getHeader("Content-Type"));
        return this.cachedContentType;
    }

    public Charset getCharset() {
        return this.getContentType().b();
    }

    public int getContentLength() {
        if (this.cachedContentLength != -1) {
            return this.cachedContentLength;
        }
        this.cachedContentLength = 0;
        String string = this.getHeader("Content-Length");
        if (string == null || "0".equals(string)) {
            return 0;
        }
        try {
            this.cachedContentLength = (int)Math.min(Long.parseLong(string.trim()), Integer.MAX_VALUE);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Invalid content length header value detected: {}", (Object)string, (Object)numberFormatException);
        }
        return this.cachedContentLength != -1 ? this.cachedContentLength : 0;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        if (string == null) {
            return;
        }
        try {
            this.setProtocol(Protocol.fromString(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setProtocol(Protocol protocol) {
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(String string) {
        this.method = string;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpRequest setUri(String string) {
        this.uri = string;
        this.normalizedUri = r.a(string);
        this.path = null;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void addMultipartItem(MultipartItem multipartItem) {
        this.multipartItems.add(multipartItem);
    }

    public void setMultipartItems(Set<MultipartItem> set) {
        this.multipartItems = set;
    }

    public Set<MultipartItem> getMultipartItems() {
        return this.multipartItems;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> map) {
        this.parameters = map;
    }

    public void setHeaders(Map<String, String[]> map) {
        if (map == null) {
            return;
        }
        this.headers = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        this.headers.putAll(map);
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public String[] getHeaders(String string) {
        if (this.headers == null || this.headers.isEmpty() || StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray = this.headers.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        return null;
    }

    public String getHeader(String string) {
        String[] stringArray = this.getHeaders(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public String getTemplate() {
        return this.template;
    }

    public String getNormalizedTemplate() {
        return this.normalizedTemplate;
    }

    @Deprecated
    public void setTemplate(String string) {
        if (string == null) {
            return;
        }
        this.template = string.length() > 1 && string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        this.normalizedTemplate = r.a(this.template);
    }

    public boolean isParametersResolved() {
        return this.parsedParameters;
    }

    public void resolvedParameters() {
        this.parsedParameters = true;
    }

    public void markParametersUnresolved() {
        this.parsedParameters = false;
    }

    public boolean isMultipartParametersResolved() {
        return this.parsedMultipartParameters;
    }

    public void resolvedMultipartParameters() {
        this.parsedMultipartParameters = true;
    }

    public String getCookie() {
        return this.getHeader("Cookie");
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        if (string == null) {
            return;
        }
        try {
            this.setVersion(HttpVersion.parse(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setVersion(HttpVersion httpVersion) {
        if (httpVersion != null) {
            this.version = httpVersion;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(String string) {
        this.remoteIp = string == null ? DEFAULT_REMOTE_IP : string;
    }

    protected E getBody() {
        this.cacheBody();
        return this.cachedBody;
    }

    public void setCachedBody(E e2) {
        this.cachedBody = e2;
        this.cachedBodyStr = this.cachedBody != null ? this.cachedBody.c() : null;
    }

    void clearBodyCache() {
        this.cachedBody = null;
        this.cachedBodyStr = null;
        this.cachedEncodedBodyAsString = null;
    }

    public void reset(int n2) {
        BUFFER.a(n2);
        this.cachedContentLength = -1;
        this.cachedContentType = null;
    }

    public Collection<HttpWatcher> getResponseWatchers() {
        return this.responseWatchers == null ? Collections.emptyList() : this.responseWatchers;
    }

    public void setResponseWatchers(Collection<HttpWatcher> collection) {
        this.responseWatchers = collection;
    }

    public void setAnalyzing(boolean bl2) {
        this.analyzing = bl2;
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public String getServerVersionInfo() {
        return this.serverVersionInfo;
    }

    public void setServerVersionInfo(String string) {
        this.serverVersionInfo = string;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
    }

    public boolean isScanningResponse() {
        return this.responseWatchers != null && !this.responseWatchers.isEmpty();
    }

    @ScopedSensor
    public void onBytesRead(int n2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            if (this.scope != 1 || n2 == -1) {
                scopeAggregator.leaveScope();
                return;
            }
            if (!this.isCapturingInMemory()) {
                scopeAggregator.leaveScope();
                return;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = BUFFER.a();
                int n3 = byteArrayOutputStream.size();
                if (n3 < this.maxRequestBodyBytesCaptured) {
                    byteArrayOutputStream.write(n2);
                } else if (!this.appendEllipsisBytes && this.maxRequestBodyBytesCaptured != -1) {
                    byteArrayOutputStream.write(this.ellipsisBytes);
                    this.appendEllipsisBytes = true;
                }
                if (this.bufferToPlugins) {
                    for (ContrastPlugin contrastPlugin : this.bufferingPlugins) {
                        contrastPlugin.onRequestBodyChunkRead(this, n2);
                    }
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem writing file", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            if (byArray != null) {
                this.onBytesRead(n2, byArray, 0, byArray.length);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray, int n3, int n4) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            if (this.scope != 1 || byArray == null || n3 < 0 || n4 < 0 && n2 != -1) {
                scopeAggregator.leaveScope();
                return;
            }
            if (!this.isCapturingInMemory()) {
                scopeAggregator.leaveScope();
                return;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = BUFFER.a();
                int n5 = byteArrayOutputStream.size();
                if (n5 < this.maxRequestBodyBytesCaptured) {
                    int n6 = Math.min(n2, this.maxRequestBodyBytesCaptured - n5);
                    byteArrayOutputStream.write(byArray, n3, n6);
                } else if (!this.appendEllipsisBytes && this.maxRequestBodyBytesCaptured != -1) {
                    byteArrayOutputStream.write(this.ellipsisBytes);
                    this.appendEllipsisBytes = true;
                }
                if (this.bufferToPlugins) {
                    for (ContrastPlugin contrastPlugin : this.bufferingPlugins) {
                        contrastPlugin.onRequestBodyChunkRead(this, n2, byArray, n3, n4);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public void cacheBody() {
        if (!(this.cachedBody != null || this.getContentLength() <= 0 && BUFFER.d())) {
            Charset charset = this.getCharset();
            this.cachedBody = BUFFER.a(charset);
            this.cachedBodyStr = BUFFER.b() > 4096 ? new String(this.cachedBody.b(), 0, 4096, charset) + "..." : this.cachedBody.c();
        }
    }

    @Override
    public m getMemoryBuffer() {
        return BUFFER;
    }

    public void enterReadingScope() {
        ++this.scope;
    }

    public void leaveReadingScope() {
        --this.scope;
    }

    public boolean isCheckedForDeserializer() {
        return this.checkedForDeserializer;
    }

    public void setCheckedForDeserializer(boolean bl2) {
        this.checkedForDeserializer = bl2;
    }

    @Override
    protected String getAdditionalBreadCrumbInfo() {
        return this.uri;
    }

    public long startTimeNs() {
        return this.startTime;
    }

    public String getEncodedBodyAsString() {
        String string = this.getBodyAsString();
        if (string != null && !string.isEmpty() && this.cachedEncodedBodyAsString == null) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            this.appendTranslatedBody(stringBuilder, string);
            this.cachedEncodedBodyAsString = stringBuilder.toString();
        }
        return this.cachedEncodedBodyAsString;
    }

    public String getBodyAsString() {
        this.cacheBody();
        return this.cachedBodyStr;
    }

    public String headersToString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            arrayList.add(entry.getKey() + "= " + Arrays.toString(entry.getValue()));
        }
        return "Headers{" + StringUtils.join(arrayList, ", ") + "}";
    }

    public int getMaxRequestBodyBytesCaptured() {
        return this.maxRequestBodyBytesCaptured;
    }

    public void setMaxRequestBodyBytesCaptured(int n2) {
        this.maxRequestBodyBytesCaptured = n2;
    }

    public g getJfrEvent() {
        return this.jfrEvent;
    }

    public boolean hasBeenObserved() {
        return this.context().get(RouteObservationProcessor.CURRENT_OBSERVED_ROUTE) != null;
    }

    public String toString() {
        return "HttpRequest{protocol=" + (Object)((Object)this.protocol) + ", version=" + (Object)((Object)this.version) + ", method='" + this.method + '\'' + ", uri='" + this.uri + '\'' + ", queryString='" + this.queryString + '\'' + ", normalizedUri='" + this.normalizedUri + '\'' + ", port=" + this.port + ", parameters=" + this.parameters + ", headers=" + this.headers + ", contextPath='" + this.contextPath + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", analyzing=" + this.analyzing + ", cachedBodyStr='" + this.cachedBodyStr + '\'' + ", cachedContentLength=" + this.cachedContentLength + ", cachedContentType=" + this.cachedContentType + ", requestID=" + this.requestID + ", template='" + this.template + '\'' + ", normalizedTemplate='" + this.normalizedTemplate + '\'' + ", path='" + this.path + '\'' + ", secure=" + this.secure + ", type=" + (Object)((Object)this.httpRequestType) + ", active=" + this.active + ", capturingInMemory=" + this.isCapturingInMemory() + '}';
    }

    private void appendTranslatedBody(StringBuilder stringBuilder, String string) {
        if (string != null && !string.isEmpty()) {
            int n2;
            for (int i2 = n2 = string.charAt(0) == '\ufeff' ? 1 : 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (Character.isWhitespace(c2) || Character.isLetterOrDigit(c2)) {
                    stringBuilder.append(c2);
                    continue;
                }
                if (ArrayUtils.contains(ALLOWED_BODY_SPECIAL_CHARS, c2)) {
                    f.a(stringBuilder, c2);
                    continue;
                }
                stringBuilder.append(".");
            }
        }
    }

    public void setFrameworkInfo(h h2) {
        this.frameworkInfo = h2;
    }

    public Optional<h> getFrameworkInfo() {
        return Optional.ofNullable(this.frameworkInfo);
    }

    public MqHttpRequestDTM toMqHttpRequestDTM() {
        return MqHttpRequestDTM.builder().body(this.getEncodedBodyAsString()).contextPath(this.contextPath).headers(this.headers).method(this.method).parameters(this.parameters).port(this.port).protocol(this.protocol).queryString(this.queryString).serverVersionInfo(this.serverVersionInfo).isSecure(this.secure).uri(this.uri).version(this.getVersion()).build();
    }

    public HttpRequestDTM toHttpRequestDTM() {
        HttpRequestDTM.Builder builder = HttpRequestDTM.builder().method(this.getMethod()).port(this.getPort()).protocol(this.getProtocol()).uri(this.getUri()).version(this.getVersion()).contextPath(this.getContextPath()).normalizedUri(this.getNormalizedUri()).serverVersionInfo(this.getServerVersionInfo()).requestID(this.getRequestID()).parameters(this.parameters != null ? HttpRequest.convertRequestMap(this.parameters) : null).queryString(this.getQueryString()).headers(this.headers != null ? HttpRequest.convertRequestMap(this.headers) : null).body(this.getBodyAsString()).isFormEncodedContentType(this.getContentType().h()).isMultipartContentType(this.getContentType().g()).isXMLContentType(this.getContentType().d()).boundary(this.getContentType().i()).template(this.getTemplate()).normalizedTemplate(this.getNormalizedTemplate()).path(this.getPath()).normalizedPath(r.a(this.getPath()));
        return builder.build();
    }

    @t
    static Map<String, List<String>> convertRequestMap(Map<String, String[]> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string : map.keySet()) {
            hashMap.put(string, Arrays.asList(map.get(string)));
        }
        return hashMap;
    }

    @DontObfuscate
    public static enum HttpRequestType {
        AKKA,
        GRIZZLY,
        GRPC,
        J2EE,
        JDK_HTTP,
        MULESOFT,
        NETTY,
        UNDERTOW,
        XENON;

    }
}

