/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.assessment.properties;

import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;

public final class CSPInstruction {
    private static final String BASE_URI = "base-uri";
    private static final String DEFAULT_SRC = "default-src";
    private static final String CHILD_SRC = "child-src";
    private static final String CONNECT_SRC = "connect-src";
    private static final String FRAME_SRC = "frame-src";
    private static final String MEDIA_SRC = "media-src";
    private static final String OBJECT_SRC = "object-src";
    private static final String SCRIPT_SRC = "script-src";
    private static final String STYLE_SRC = "style-src";
    private static final String FORM_ACTION = "form-action";
    private static final String FRAME_ANCESTORS = "frame-ancestors";
    private static final String PLUGIN_TYPES = "plugin-types";
    private static final String REFLECTED_XSS = "reflected-xss";
    private static final String REFERRER = "referrer";
    private final boolean baseUriSecure;
    private final String baseUriValue;
    private final boolean defaultSrcSecure;
    private final String defaultSrcValue;
    private final boolean childSrcSecure;
    private final String childSrcValue;
    private final boolean connectSrcSecure;
    private final String connectSrcValue;
    private final boolean frameSrcSecure;
    private final String frameSrcValue;
    private final boolean mediaSrcSecure;
    private final String mediaSrcValue;
    private final boolean objectSrcSecure;
    private final String objectSrcValue;
    private final boolean scriptSrcSecure;
    private final String scriptSrcValue;
    private final boolean styleSrcSecure;
    private final String styleSrcValue;
    private final boolean formActionSecure;
    private final String formActionValue;
    private final boolean frameAncestorsSecure;
    private final String frameAncestorsValue;
    private final boolean pluginTypesSecure;
    private final String pluginTypesValue;
    private final boolean reflectedXssSecure;
    private final String reflectedXssValue;
    @SerializedName(value="refererSecure")
    private final boolean referrerSecure;
    @SerializedName(value="refererValue")
    private final String referrerValue;
    private static final CSPInstruction EMPTY_CSP_INSTRUCTION_JSON = CSPInstruction.create("");

    public static CSPInstruction create(String string) {
        String string2 = CSPInstruction.processSetting(BASE_URI, string);
        String string3 = CSPInstruction.processSetting(DEFAULT_SRC, string);
        String string4 = CSPInstruction.processSetting(CHILD_SRC, string);
        String string5 = CSPInstruction.processSetting(CONNECT_SRC, string);
        String string6 = CSPInstruction.processSetting(FRAME_SRC, string);
        String string7 = CSPInstruction.processSetting(MEDIA_SRC, string);
        String string8 = CSPInstruction.processSetting(OBJECT_SRC, string);
        String string9 = CSPInstruction.processSetting(SCRIPT_SRC, string);
        String string10 = CSPInstruction.processSetting(STYLE_SRC, string);
        String string11 = CSPInstruction.processSetting(FORM_ACTION, string);
        String string12 = CSPInstruction.processSetting(FRAME_ANCESTORS, string);
        String string13 = CSPInstruction.processSetting(PLUGIN_TYPES, string);
        String string14 = CSPInstruction.processSetting(REFLECTED_XSS, string);
        String string15 = CSPInstruction.processSetting(REFERRER, string);
        boolean bl2 = CSPInstruction.isContentSecure(string2);
        boolean bl3 = CSPInstruction.isContentSecure(string3);
        boolean bl4 = CSPInstruction.isContentSecure(string4);
        boolean bl5 = CSPInstruction.isContentSecure(string5);
        boolean bl6 = CSPInstruction.isContentSecure(string6);
        boolean bl7 = CSPInstruction.isContentSecure(string7);
        boolean bl8 = CSPInstruction.isContentSecure(string8);
        boolean bl9 = CSPInstruction.isContentSecure(string9) && CSPInstruction.isContentSafe(string9);
        boolean bl10 = CSPInstruction.isContentSecure(string10) && CSPInstruction.isContentSafe(string10);
        boolean bl11 = CSPInstruction.isContentSecure(string11);
        boolean bl12 = CSPInstruction.isContentSecure(string12);
        boolean bl13 = CSPInstruction.isContentSecure(string13);
        boolean bl14 = "1".equals(string14);
        boolean bl15 = CSPInstruction.isContentSecure(string15) && CSPInstruction.isContentSafe(string15) && !string15.contains("unsafe-url");
        return new CSPInstruction(bl2, string2, bl3, string3, bl4, string4, bl5, string5, bl6, string6, bl7, string7, bl8, string8, bl9, string9, bl10, string10, bl11, string11, bl12, string12, bl13, string13, bl14, string14, bl15, string15);
    }

    public static CSPInstruction empty() {
        return EMPTY_CSP_INSTRUCTION_JSON;
    }

    private CSPInstruction(boolean bl2, String string, boolean bl3, String string2, boolean bl4, String string3, boolean bl5, String string4, boolean bl6, String string5, boolean bl7, String string6, boolean bl8, String string7, boolean bl9, String string8, boolean bl10, String string9, boolean bl11, String string10, boolean bl12, String string11, boolean bl13, String string12, boolean bl14, String string13, boolean bl15, String string14) {
        this.baseUriSecure = bl2;
        this.baseUriValue = string;
        this.defaultSrcSecure = bl3;
        this.defaultSrcValue = string2;
        this.childSrcSecure = bl4;
        this.childSrcValue = string3;
        this.connectSrcSecure = bl5;
        this.connectSrcValue = string4;
        this.frameSrcSecure = bl6;
        this.frameSrcValue = string5;
        this.mediaSrcSecure = bl7;
        this.mediaSrcValue = string6;
        this.objectSrcSecure = bl8;
        this.objectSrcValue = string7;
        this.scriptSrcSecure = bl9;
        this.scriptSrcValue = string8;
        this.styleSrcSecure = bl10;
        this.styleSrcValue = string9;
        this.formActionSecure = bl11;
        this.formActionValue = string10;
        this.frameAncestorsSecure = bl12;
        this.frameAncestorsValue = string11;
        this.pluginTypesSecure = bl13;
        this.pluginTypesValue = string12;
        this.reflectedXssSecure = bl14;
        this.reflectedXssValue = string13;
        this.referrerSecure = bl15;
        this.referrerValue = string14;
    }

    private static String processSetting(String string, String string2) {
        int n2 = string2.indexOf(string);
        String string3 = null;
        if (n2 != -1) {
            int n3 = string2.indexOf(59, n2 += string.length() + 1);
            int n4 = string2.indexOf(62, n2);
            string3 = n3 == -1 ? (n4 == -1 ? string2.substring(n2) : string2.substring(n2, n4 - 1)) : string2.substring(n2, n3);
        }
        return string3;
    }

    private static boolean isContentSecure(String string) {
        return string != null && !string.contains("*");
    }

    private static boolean isContentSafe(String string) {
        return !string.contains("unsafe-inline") && !string.contains("unsafe-eval");
    }

    public boolean isSafe() {
        return this.formActionSecure && this.frameAncestorsSecure && this.pluginTypesSecure && this.reflectedXssSecure && this.baseUriSecure && this.referrerSecure && this.areSourcesSecure();
    }

    private boolean areSourcesSecure() {
        if (this.defaultSrcSecure) {
            if (!this.childSrcSecure && this.childSrcValue != null || !this.frameSrcSecure && this.frameSrcValue != null) {
                return false;
            }
            if (!this.connectSrcSecure && this.connectSrcValue != null) {
                return false;
            }
            if (!this.mediaSrcSecure && this.mediaSrcValue != null) {
                return false;
            }
            if (!this.objectSrcSecure && this.objectSrcValue != null) {
                return false;
            }
            if (!this.scriptSrcSecure && this.scriptSrcValue != null) {
                return false;
            }
            return this.styleSrcSecure || this.styleSrcValue == null;
        }
        return this.childSrcSecure && this.connectSrcSecure && this.frameSrcSecure && this.mediaSrcSecure && this.objectSrcSecure && this.scriptSrcSecure && this.styleSrcSecure;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CSPInstruction cSPInstruction = (CSPInstruction)object;
        if (this.baseUriValue != null ? !this.baseUriValue.equals(cSPInstruction.baseUriValue) : cSPInstruction.baseUriValue != null) {
            return false;
        }
        if (this.defaultSrcValue != null ? !this.defaultSrcValue.equals(cSPInstruction.defaultSrcValue) : cSPInstruction.defaultSrcValue != null) {
            return false;
        }
        if (this.childSrcValue != null ? !this.childSrcValue.equals(cSPInstruction.childSrcValue) : cSPInstruction.childSrcValue != null) {
            return false;
        }
        if (this.connectSrcValue != null ? !this.connectSrcValue.equals(cSPInstruction.connectSrcValue) : cSPInstruction.connectSrcValue != null) {
            return false;
        }
        if (this.frameSrcValue != null ? !this.frameSrcValue.equals(cSPInstruction.frameSrcValue) : cSPInstruction.frameSrcValue != null) {
            return false;
        }
        if (this.mediaSrcValue != null ? !this.mediaSrcValue.equals(cSPInstruction.mediaSrcValue) : cSPInstruction.mediaSrcValue != null) {
            return false;
        }
        if (this.objectSrcValue != null ? !this.objectSrcValue.equals(cSPInstruction.objectSrcValue) : cSPInstruction.objectSrcValue != null) {
            return false;
        }
        if (this.scriptSrcValue != null ? !this.scriptSrcValue.equals(cSPInstruction.scriptSrcValue) : cSPInstruction.scriptSrcValue != null) {
            return false;
        }
        if (this.styleSrcValue != null ? !this.styleSrcValue.equals(cSPInstruction.styleSrcValue) : cSPInstruction.styleSrcValue != null) {
            return false;
        }
        if (this.formActionValue != null ? !this.formActionValue.equals(cSPInstruction.formActionValue) : cSPInstruction.formActionValue != null) {
            return false;
        }
        if (this.frameAncestorsValue != null ? !this.frameAncestorsValue.equals(cSPInstruction.frameAncestorsValue) : cSPInstruction.frameAncestorsValue != null) {
            return false;
        }
        if (this.pluginTypesValue != null ? !this.pluginTypesValue.equals(cSPInstruction.pluginTypesValue) : cSPInstruction.pluginTypesValue != null) {
            return false;
        }
        if (this.reflectedXssValue != null ? !this.reflectedXssValue.equals(cSPInstruction.reflectedXssValue) : cSPInstruction.reflectedXssValue != null) {
            return false;
        }
        return this.referrerValue != null ? this.referrerValue.equals(cSPInstruction.referrerValue) : cSPInstruction.referrerValue == null;
    }

    public int hashCode() {
        int n2 = 0;
        n2 = 31 * n2 + (this.baseUriValue != null ? this.baseUriValue.hashCode() : 0);
        n2 = 31 * n2 + (this.defaultSrcValue != null ? this.defaultSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.childSrcValue != null ? this.childSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.connectSrcValue != null ? this.connectSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.frameSrcValue != null ? this.frameSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaSrcValue != null ? this.mediaSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.objectSrcValue != null ? this.objectSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.scriptSrcValue != null ? this.scriptSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.styleSrcValue != null ? this.styleSrcValue.hashCode() : 0);
        n2 = 31 * n2 + (this.formActionValue != null ? this.formActionValue.hashCode() : 0);
        n2 = 31 * n2 + (this.frameAncestorsValue != null ? this.frameAncestorsValue.hashCode() : 0);
        n2 = 31 * n2 + (this.pluginTypesValue != null ? this.pluginTypesValue.hashCode() : 0);
        n2 = 31 * n2 + (this.reflectedXssValue != null ? this.reflectedXssValue.hashCode() : 0);
        n2 = 31 * n2 + (this.referrerValue != null ? this.referrerValue.hashCode() : 0);
        return n2;
    }

    public String getBaseUriValue() {
        return this.baseUriValue;
    }

    public String getDefaultSrcValue() {
        return this.defaultSrcValue;
    }

    public String getChildSrcValue() {
        return this.childSrcValue;
    }

    public String getConnectSrcValue() {
        return this.connectSrcValue;
    }

    public String getFrameSrcValue() {
        return this.frameSrcValue;
    }

    public String getMediaSrcValue() {
        return this.mediaSrcValue;
    }

    public String getObjectSrcValue() {
        return this.objectSrcValue;
    }

    public String getScriptSrcValue() {
        return this.scriptSrcValue;
    }

    public String getStyleSrcValue() {
        return this.styleSrcValue;
    }

    public String getFormActionValue() {
        return this.formActionValue;
    }

    public String getFrameAncestorsValue() {
        return this.frameAncestorsValue;
    }

    public String getPluginTypesValue() {
        return this.pluginTypesValue;
    }

    public String getReflectedXssValue() {
        return this.reflectedXssValue;
    }

    public String getReferrerValue() {
        return this.referrerValue;
    }

    public boolean isBaseUriSecure() {
        return this.baseUriSecure;
    }

    public boolean isDefaultSrcSecure() {
        return this.defaultSrcSecure;
    }

    public boolean isChildSrcSecure() {
        return this.childSrcSecure;
    }

    public boolean isConnectSrcSecure() {
        return this.connectSrcSecure;
    }

    public boolean isFrameSrcSecure() {
        return this.frameSrcSecure;
    }

    public boolean isMediaSrcSecure() {
        return this.mediaSrcSecure;
    }

    public boolean isObjectSrcSecure() {
        return this.objectSrcSecure;
    }

    public boolean isScriptSrcSecure() {
        return this.scriptSrcSecure;
    }

    public boolean isStyleSrcSecure() {
        return this.styleSrcSecure;
    }

    public boolean isFormActionSecure() {
        return this.formActionSecure;
    }

    public boolean isFrameAncestorsSecure() {
        return this.frameAncestorsSecure;
    }

    public boolean isPluginTypesSecure() {
        return this.pluginTypesSecure;
    }

    public boolean isReflectedXssSecure() {
        return this.reflectedXssSecure;
    }

    public boolean isReferrerSecure() {
        return this.referrerSecure;
    }
}

