/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.preflight;

import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.thirdparty.com.google.gson.JsonArray;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonObject;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializer;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.Objects;

public class PreflightMessageDTM {
    public static final JsonSerializer<PreflightMessageDTM> JSON_SERIALIZER = new PreflightMessageDTMJsonSerializer();
    private final String appLanguage = "Java";
    private final String appName;
    private final String appPath;
    private final String appVersion;
    private final String code;
    private final String data;
    private final Integer key;
    @SerializedName(value="session_id")
    private final String sessionId;
    private final transient ObservedRoute observedRoute;

    private PreflightMessageDTM(Builder builder) {
        Objects.requireNonNull(builder.appName, () -> "appName parameter cannot be null");
        Objects.requireNonNull(builder.appPath, () -> "appPath parameter cannot be null");
        Objects.requireNonNull(builder.code, () -> "code parameter cannot be null");
        Objects.requireNonNull(builder.data, () -> "data parameter cannot be null");
        Objects.requireNonNull(builder.key, () -> "key parameter cannot be null");
        this.appName = builder.appName;
        this.appPath = builder.appPath;
        this.appVersion = builder.appVersion;
        this.code = builder.code;
        this.data = builder.data;
        this.key = builder.key;
        this.sessionId = builder.sessionId;
        this.observedRoute = builder.observedRoute;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class PreflightMessageDTMJson
    extends PreflightMessageDTM {
        private PreflightMessageDTMJson(Builder builder) {
            super(builder);
        }
    }

    private static final class PreflightMessageDTMJsonSerializer
    implements JsonSerializer<PreflightMessageDTM> {
        private PreflightMessageDTMJsonSerializer() {
        }

        @Override
        public JsonElement serialize(PreflightMessageDTM preflightMessageDTM, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = jsonSerializationContext.serialize(preflightMessageDTM, (Type)((Object)PreflightMessageDTMJson.class)).getAsJsonObject();
            if (preflightMessageDTM.observedRoute == null) {
                jsonObject.add("routes", new JsonArray());
                return jsonObject;
            }
            jsonObject.add("routes", preflightMessageDTM.observedRoute.toRouteCoverageJson());
            return jsonObject;
        }
    }

    public static final class Builder {
        private String appName;
        private String appPath;
        private String appVersion;
        private String code;
        private String data;
        private Integer key;
        private String sessionId;
        private ObservedRoute observedRoute;

        private Builder() {
        }

        public PreflightMessageDTM build() {
            return new PreflightMessageDTM(this);
        }

        public Builder appName(String string) {
            this.appName = string;
            return this;
        }

        public Builder appPath(String string) {
            this.appPath = string;
            return this;
        }

        public Builder appVersion(String string) {
            this.appVersion = string;
            return this;
        }

        public Builder code(String string) {
            this.code = string;
            return this;
        }

        public Builder data(String string) {
            this.data = string;
            return this;
        }

        public Builder key(Integer n2) {
            this.key = n2;
            return this;
        }

        public Builder sessionId(String string) {
            this.sessionId = "".equals(string) ? null : string;
            return this;
        }

        public Builder route(ObservedRoute observedRoute) {
            this.observedRoute = observedRoute;
            return this;
        }
    }
}

