/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.finding.trace;

import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.i.b.a;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventPropertyDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSignatureDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.ObjectDTM;
import com.contrastsecurity.agent.messages.finding.trace.ParentObjectIdDTM;
import com.contrastsecurity.agent.messages.finding.trace.StackDTM;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class EventDTM
implements Serializable {
    private final EventActionDTM action;
    private final EventTypeDTM type;
    private final long time;
    private final String thread;
    private final String source;
    private final String target;
    private final ObjectDTM object;
    private final List<ObjectDTM> args;
    private final ObjectDTM ret;
    private final List<StackDTM> stack;
    private final String fieldName;
    private final String context;
    private final String code;
    private final List<EventPropertyDTM> properties;
    private final String tags;
    private final boolean summary;
    private final EventSignatureDTM signature;
    private final List<EventTaintRangeDTM> taintRanges;
    private final long objectId;
    private final Set<EventSourceDTM> eventSources;
    private Set<ParentObjectIdDTM> parentObjectIds;
    private static final long UNDEFINED_OBJECT_ID = -1L;
    private static final long serialVersionUID = 1L;

    private EventDTM(Builder builder) {
        this.action = builder.action;
        this.type = builder.type;
        this.time = builder.time;
        this.thread = builder.thread;
        this.source = builder.source;
        this.target = builder.target;
        this.object = builder.object;
        this.args = builder.args == null ? null : Lists.copy(builder.args);
        this.ret = builder.ret;
        this.stack = builder.stack == null ? null : Lists.copy(builder.stack);
        this.fieldName = builder.fieldName;
        this.context = builder.context;
        this.code = builder.code;
        this.properties = builder.properties == null ? null : Lists.copy(builder.properties);
        this.tags = builder.tags;
        this.summary = builder.summary;
        this.signature = builder.signature;
        this.taintRanges = builder.taintRanges;
        this.objectId = builder.objectId;
        this.eventSources = builder.eventSources == null ? null : Sets.copy(builder.eventSources);
        this.parentObjectIds = builder.parentObjectIds == null ? null : Sets.copy(builder.parentObjectIds);
    }

    public boolean isSummary() {
        return this.summary;
    }

    public EventActionDTM getAction() {
        return this.action;
    }

    public EventTypeDTM getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public String getThread() {
        return this.thread;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public List<EventTaintRangeDTM> getTaintRanges() {
        return this.taintRanges;
    }

    public ObjectDTM getObject() {
        return this.object;
    }

    public List<ObjectDTM> getArgs() {
        return this.args;
    }

    public ObjectDTM getRet() {
        return this.ret;
    }

    public List<StackDTM> getStack() {
        return this.stack;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCode() {
        return this.code;
    }

    public String getContext() {
        return this.context;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public EventSignatureDTM getSignature() {
        return this.signature;
    }

    public List<EventPropertyDTM> getProperties() {
        return this.properties;
    }

    public Set<EventSourceDTM> getEventSources() {
        return this.eventSources;
    }

    @Deprecated
    public String getTags() {
        return this.tags;
    }

    public Set<ParentObjectIdDTM> getParentObjectIds() {
        return this.parentObjectIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "EventDTM{action=" + (Object)((Object)this.action) + ", type=" + (Object)((Object)this.type) + ", tags=" + this.tags + ", taintRanges=" + this.taintRanges + ", signature=" + this.signature + '}';
    }

    public static final class Builder {
        private EventActionDTM action;
        private EventTypeDTM type;
        private long time;
        private String thread;
        private String source;
        private String target;
        private ObjectDTM object;
        private List<ObjectDTM> args;
        private ObjectDTM ret;
        private List<StackDTM> stack;
        private String fieldName;
        private String context;
        private String code;
        private List<EventPropertyDTM> properties;
        private String tags = "";
        private boolean summary;
        private EventSignatureDTM signature;
        private List<EventTaintRangeDTM> taintRanges;
        private long objectId = -1L;
        private Set<EventSourceDTM> eventSources;
        private Set<ParentObjectIdDTM> parentObjectIds;

        private Builder() {
        }

        public Builder action(EventActionDTM eventActionDTM) {
            this.action = eventActionDTM;
            return this;
        }

        public Builder args(List<ObjectDTM> list) {
            this.args = list;
            return this;
        }

        public Builder code(String string) {
            this.code = string;
            return this;
        }

        public Builder context(String string) {
            this.context = string;
            return this;
        }

        public Builder eventSources(EventActionDTM eventActionDTM, Set<EventSourceDTM> set) {
            if (eventActionDTM.shouldAllowSourceAction()) {
                this.eventSources = set;
            }
            return this;
        }

        public Builder fieldName(String string) {
            this.fieldName = string;
            return this;
        }

        public Builder object(ObjectDTM objectDTM) {
            this.object = objectDTM;
            return this;
        }

        public Builder objectId(long l2) {
            this.objectId = l2;
            return this;
        }

        public Builder parentObjectIds(Set<ParentObjectIdDTM> set) {
            this.parentObjectIds = set;
            return this;
        }

        public Builder properties(List<EventPropertyDTM> list) {
            this.properties = list;
            return this;
        }

        public Builder ret(ObjectDTM objectDTM) {
            this.ret = objectDTM;
            return this;
        }

        public Builder signature(EventSignatureDTM eventSignatureDTM) {
            this.signature = eventSignatureDTM;
            return this;
        }

        public Builder source(String string) {
            this.source = string;
            return this;
        }

        public Builder stack(List<StackDTM> list) {
            this.stack = list;
            return this;
        }

        public Builder summary(boolean bl2) {
            this.summary = bl2;
            return this;
        }

        public Builder tags(String string) {
            this.tags = string;
            return this;
        }

        public Builder taintRanges(List<EventTaintRangeDTM> list) {
            this.taintRanges = list;
            return this;
        }

        public Builder target(String string) {
            this.target = string;
            return this;
        }

        public Builder thread(String string) {
            this.thread = string;
            return this;
        }

        public Builder time(long l2) {
            this.time = l2;
            return this;
        }

        public Builder type(EventTypeDTM eventTypeDTM) {
            this.type = eventTypeDTM;
            return this;
        }

        public EventDTM build() {
            return new EventDTM(this);
        }

        public static String buildTagsString(EventTypeDTM eventTypeDTM, Collection<a> collection) {
            if (collection == null || collection.isEmpty() || !EventTypeDTM.PROPAGATION.equals((Object)eventTypeDTM) && !EventTypeDTM.TAG.equals((Object)eventTypeDTM)) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (a a2 : collection) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(a2.a());
            }
            return stringBuilder.toString();
        }
    }
}

