/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.mq;

import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MqHttpRequestDTM {
    private final String body;
    private final String contextPath;
    private final Map<String, List<String>> headers;
    private final String method;
    private final Map<String, List<String>> parameters;
    private final int port;
    private final Protocol protocol;
    private final String queryString;
    private final String serverVersionInfo;
    private final String uri;
    private final HttpVersion version;
    private final boolean secure;

    private MqHttpRequestDTM(Builder builder) {
        this.body = builder.body;
        this.contextPath = builder.contextPath;
        this.headers = builder.headers;
        this.method = builder.method;
        this.parameters = builder.parameters;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.queryString = builder.queryString;
        this.serverVersionInfo = builder.serverVersionInfo;
        this.uri = builder.uri;
        this.version = builder.version;
        this.secure = builder.secure;
    }

    public String getBody() {
        return this.body;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getServerVersionInfo() {
        return this.serverVersionInfo;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MqHttpRequestDTM mqHttpRequestDTM = (MqHttpRequestDTM)object;
        if (this.port != mqHttpRequestDTM.port) {
            return false;
        }
        if (this.secure != mqHttpRequestDTM.secure) {
            return false;
        }
        if (this.body != null ? !this.body.equals(mqHttpRequestDTM.body) : mqHttpRequestDTM.body != null) {
            return false;
        }
        if (this.contextPath != null ? !this.contextPath.equals(mqHttpRequestDTM.contextPath) : mqHttpRequestDTM.contextPath != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(mqHttpRequestDTM.headers) : mqHttpRequestDTM.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(mqHttpRequestDTM.method) : mqHttpRequestDTM.method != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(mqHttpRequestDTM.parameters) : mqHttpRequestDTM.parameters != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals((Object)mqHttpRequestDTM.protocol) : mqHttpRequestDTM.protocol != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(mqHttpRequestDTM.queryString) : mqHttpRequestDTM.queryString != null) {
            return false;
        }
        if (this.serverVersionInfo != null ? !this.serverVersionInfo.equals(mqHttpRequestDTM.serverVersionInfo) : mqHttpRequestDTM.serverVersionInfo != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(mqHttpRequestDTM.uri) : mqHttpRequestDTM.uri != null) {
            return false;
        }
        return this.version != null ? this.version.equals((Object)mqHttpRequestDTM.version) : mqHttpRequestDTM.version == null;
    }

    public int hashCode() {
        int n2 = this.body != null ? this.body.hashCode() : 0;
        n2 = 31 * n2 + (this.contextPath != null ? this.contextPath.hashCode() : 0);
        n2 = 31 * n2 + (this.headers != null ? this.headers.hashCode() : 0);
        n2 = 31 * n2 + (this.method != null ? this.method.hashCode() : 0);
        n2 = 31 * n2 + (this.parameters != null ? this.parameters.hashCode() : 0);
        n2 = 31 * n2 + this.port;
        n2 = 31 * n2 + (this.protocol != null ? this.protocol.hashCode() : 0);
        n2 = 31 * n2 + (this.queryString != null ? this.queryString.hashCode() : 0);
        n2 = 31 * n2 + (this.serverVersionInfo != null ? this.serverVersionInfo.hashCode() : 0);
        n2 = 31 * n2 + (this.uri != null ? this.uri.hashCode() : 0);
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        n2 = 31 * n2 + (this.secure ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "HttpRequestDTM{body='" + this.body + '\'' + ", contextPath='" + this.contextPath + '\'' + ", headers=" + this.headers + ", method='" + this.method + '\'' + ", parameters=" + this.parameters + ", port=" + this.port + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", queryString='" + this.queryString + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", uri='" + this.uri + '\'' + ", version='" + (Object)((Object)this.version) + '\'' + ", secure=" + this.secure + '}';
    }

    public static final class Builder {
        private String body;
        private String contextPath;
        private Map<String, List<String>> headers = Collections.emptyMap();
        private String method;
        private Map<String, List<String>> parameters = Collections.emptyMap();
        private int port;
        private Protocol protocol;
        private String queryString;
        private String serverVersionInfo;
        private String uri;
        private HttpVersion version;
        private boolean secure;

        public Builder body(String string) {
            this.body = string;
            return this;
        }

        public Builder contextPath(String string) {
            this.contextPath = string;
            return this;
        }

        public Builder headers(Map<String, String[]> map) {
            if (map == null || map.isEmpty()) {
                return this;
            }
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                this.headers.put(entry.getKey().toLowerCase(), Arrays.asList(entry.getValue()));
            }
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder parameters(Map<String, String[]> map) {
            if (map == null || map.isEmpty()) {
                return this;
            }
            this.parameters = new HashMap<String, List<String>>();
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                this.parameters.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
            return this;
        }

        public Builder port(int n2) {
            this.port = n2;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder queryString(String string) {
            this.queryString = string;
            return this;
        }

        public Builder serverVersionInfo(String string) {
            this.serverVersionInfo = string != null ? string.trim() : null;
            return this;
        }

        public Builder uri(String string) {
            this.uri = string;
            return this;
        }

        public Builder version(HttpVersion httpVersion) {
            this.version = httpVersion;
            return this;
        }

        public Builder isSecure(boolean bl2) {
            this.secure = bl2;
            return this;
        }

        public MqHttpRequestDTM build() {
            return new MqHttpRequestDTM(this);
        }
    }
}

