/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture.model;

import com.contrastsecurity.agent.apps.m;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentDTM;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentType;
import com.contrastsecurity.agent.plugins.architecture.model.a;
import com.contrastsecurity.thirdparty.com.google.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;

@AutoValue
public abstract class ArchitectureComponent {
    private static final Logger logger = LoggerFactory.getLogger(ArchitectureComponent.class);

    public static ArchitectureComponent of(ArchitectureComponentType architectureComponentType, String string, String string2, String string3, String string4, String string5) {
        if (StringUtils.isNotBlank(string2) && StringUtils.isNotBlank(string3) && StringUtils.isNotBlank(string) && architectureComponentType != null && (architectureComponentType.equals((Object)ArchitectureComponentType.DATABASE) || architectureComponentType.equals((Object)ArchitectureComponentType.LDAP) || architectureComponentType.equals((Object)ArchitectureComponentType.WEB_SERVICE))) {
            String string6 = ArchitectureComponent.simplifyUrlString(string);
            if (string6 == null) {
                return null;
            }
            return new a(architectureComponentType, string5 == null ? "" : string5, string2.toLowerCase(), string3, string4 == null ? "" : string4, string6.toLowerCase());
        }
        return null;
    }

    private static String simplifyUrlString(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getRawPath();
            String string3 = uRI.getRawQuery();
            if (string2 != null && !string2.isEmpty()) {
                if ("/".equals(string2)) {
                    return string.substring(0, string.length() - 1);
                }
                return string.substring(0, string.indexOf(string2));
            }
            if (string3 != null && !string3.isEmpty()) {
                return string.substring(0, string.indexOf("?"));
            }
            return string;
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.debug("ArchitectureComponent's URL is malformed. Discarding.", uRISyntaxException);
            return null;
        }
    }

    public static ArchitectureComponent databaseFrom(String string, String string2, String string3) {
        return ArchitectureComponent.of(ArchitectureComponentType.DATABASE, string, string2, string3, "", "");
    }

    public static ArchitectureComponent databaseFrom(String string, String string2, String string3, String string4, String string5) {
        return ArchitectureComponent.of(ArchitectureComponentType.DATABASE, string, string2, string3, string4, string5);
    }

    public static ArchitectureComponent webServiceFrom(m m2) {
        return ArchitectureComponent.of(ArchitectureComponentType.WEB_SERVICE, m2.c(), m2.a(), Integer.toString(m2.b()), "", "");
    }

    public static ArchitectureComponent webServiceFrom(String string, String string2, String string3) {
        return ArchitectureComponent.of(ArchitectureComponentType.WEB_SERVICE, string, string2, string3, "", "");
    }

    public static ArchitectureComponent ldapFrom(String string, String string2, String string3) {
        return ArchitectureComponent.of(ArchitectureComponentType.LDAP, string, string2, string3, "", "");
    }

    public abstract ArchitectureComponentType type();

    public abstract String name();

    public abstract String remoteHost();

    public abstract String remotePort();

    public abstract String vendor();

    public abstract String url();

    public ArchitectureComponentDTM toDTM() {
        return ArchitectureComponentDTM.builder().remoteHost(this.remoteHost()).remotePort(this.remotePort()).type(this.type()).vendor(this.vendor()).url(this.url()).build();
    }
}

