/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.aws;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.g;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentType;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.util.ArchitectureScope;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.net.URI;

@Singleton
@DontObfuscate
public final class ContrastAWSArchitectureDispatcherImpl
implements ContrastAWSArchitectureDispatcher {
    private final e config;
    private final ArchitectureComponentReporter architectureComponentReporter;
    private final ApplicationManager applicationManager;

    @Inject
    public ContrastAWSArchitectureDispatcherImpl(e e2, ArchitectureComponentReporter architectureComponentReporter, ApplicationManager applicationManager) {
        this.config = e2;
        this.architectureComponentReporter = architectureComponentReporter;
        this.applicationManager = applicationManager;
    }

    @ScopedSensor
    public void onExecute(URI uRI) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            Application application = this.applicationManager.current();
            if (!g.a(this.config) || application == null) {
                scopeAggregator.leaveScope();
                return;
            }
            a a2 = a.a(uRI);
            if (a2 == null || !this.config.c(a2.e)) {
                scopeAggregator.leaveScope();
                return;
            }
            ArchitectureScope.getTrackerScope().enterScope();
            this.architectureComponentReporter.report(application, ArchitectureComponent.of(a2.d, uRI.toString(), uRI.getHost(), String.valueOf(uRI.getPort()), a2.c, ""));
            ArchitectureScope.getTrackerScope().leaveScope();
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private static enum a {
        a("dynamodb", "AWS DynamoDB", ArchitectureComponentType.DATABASE);

        private final String b;
        private final String c;
        private final ArchitectureComponentType d;
        private final ConfigProperty e;
        private static final a[] f;

        private a(String string2, String string3, ArchitectureComponentType architectureComponentType) {
            this.b = string2;
            this.c = string3;
            this.d = architectureComponentType;
            this.e = architectureComponentType == ArchitectureComponentType.DATABASE ? ConfigProperty.DBINSPECTION : (architectureComponentType == ArchitectureComponentType.WEB_SERVICE ? ConfigProperty.INVENTORY_MONITOR_WEB_CALL : ConfigProperty.INVENTORY_MONITOR_LDAP);
        }

        private static a a(String string) {
            if (string == null) {
                return null;
            }
            for (a a2 : f) {
                if (!string.equals(a2.b)) continue;
                return a2;
            }
            return null;
        }

        static a a(URI uRI) {
            if (uRI == null) {
                return null;
            }
            return com.contrastsecurity.agent.plugins.frameworks.aws.ContrastAWSArchitectureDispatcherImpl$a.a(StringUtils.split(uRI.getHost(), ".")[0]);
        }

        static {
            f = com.contrastsecurity.agent.plugins.frameworks.aws.ContrastAWSArchitectureDispatcherImpl$a.values();
        }
    }
}

