/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.java.nio;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.frameworks.antlr.k;
import com.contrastsecurity.agent.plugins.frameworks.java.nio.a;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.model.g;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.agent.v.m;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

@Singleton
@DontObfuscate
public final class ContrastNioDispatcherImpl
implements ContrastNioDispatcher {
    private final AssessmentManager assessmentManager;
    private final c codeEventFactory;
    private final com.contrastsecurity.agent.plugins.security.b.a debugStringFactory;
    private final EventContext eventContext;
    private final Propagator bogusPropagator;
    private final ScopeProviderAssess scopeProvider;
    private final m stackCaptureFactory;
    private final e traceFactory;
    private static final Logger logger = LoggerFactory.getLogger(ContrastNioDispatcherImpl.class);

    @Inject
    public ContrastNioDispatcherImpl(AssessmentManager assessmentManager, c c2, d d2, com.contrastsecurity.agent.plugins.security.b.a a2, EventContext eventContext, ScopeProviderAssess scopeProviderAssess, m m2, e e2) {
        this.assessmentManager = assessmentManager;
        this.codeEventFactory = c2;
        this.debugStringFactory = a2;
        this.eventContext = eventContext;
        this.scopeProvider = scopeProviderAssess;
        this.stackCaptureFactory = m2;
        this.traceFactory = e2;
        ContrastPolicy contrastPolicy = d2.e();
        Propagator propagator = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-bytebuffer-propagator", n.q, n.n, null, null, null, null, false, false, new k());
        d2.a(propagator);
        this.bogusPropagator = propagator;
    }

    public void onByteBufferPut(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        if (this.inMasterOrSamplingScope()) {
            return;
        }
        this.propagateGetAndPut(byteBuffer, byArray, byteBuffer.array(), a.a, n2, n3, byteBuffer.position() - n3, a.b.a);
    }

    public void onByteBufferGet(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        if (this.inMasterOrSamplingScope()) {
            return;
        }
        this.propagateGetAndPut(byteBuffer, byteBuffer.array(), byArray, a.b, n2, n3, n2, a.b.b);
    }

    private void propagateGetAndPut(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2, a a2, int n2, int n3, int n4, a.b b2) {
        Object[] objectArray;
        Object object;
        ArrayList<TagRange> arrayList;
        if (n3 <= 0) {
            return;
        }
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
        Trace trace = map.get(byArray2);
        Trace trace2 = map.get(byArray);
        if (trace == null && trace2 == null && !map.containsKey(byteBuffer)) {
            return;
        }
        trace = trace != null ? trace : this.traceFactory.a();
        TagRanges tagRanges = b2.a(trace2, n2, n3, n4);
        TagRanges tagRanges2 = trace.getTagRanges().copy().clear(n4, n4 + n3);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent != null) {
            arrayList2.add(codeEvent.getId());
        }
        if (trace2 == null) {
            if (tagRanges2.isEmpty()) {
                logger.debug("The dst is no longer tainted and has been removed");
                map.remove(byArray2);
                if (b2.b()) {
                    map.remove(byteBuffer);
                }
                return;
            }
            if (trace.getTagRanges().size() == tagRanges2.size() && new HashSet<TagRange>(trace.getTagRanges().getTagRanges()).containsAll(tagRanges2.getTagRanges())) {
                return;
            }
            arrayList = new ArrayList<TagRange>(tagRanges2.getTagRanges());
        } else {
            object = new ArrayList<TagRange>(tagRanges.getTagRanges());
            object.addAll(tagRanges2.getTagRanges());
            arrayList = object;
            arrayList2.add(trace2.getLastEvent().getId());
            trace.copyEvents(trace2);
        }
        g g2 = (g)((g)((g)((g)((g)((g)((g)this.codeEventFactory.b(this.bogusPropagator).b(trace.getId())).a(b2.a())).a(byteBuffer)).b(byteBuffer)).a(new TagRanges(arrayList))).a(arrayList2)).a(this.stackCaptureFactory.a(m.a.b));
        if (a2 == a.a) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = byArray;
            objectArray2[1] = n2;
            objectArray = objectArray2;
            objectArray2[2] = n3;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = byArray2;
            objectArray3[1] = n2;
            objectArray = objectArray3;
            objectArray3[2] = n3;
        }
        object = (g)g2.a(objectArray);
        PropagationEvent propagationEvent = ((g)object).g();
        trace.addEvent(propagationEvent);
        map.put(byArray2, trace);
        if (b2.b()) {
            map.put(byteBuffer, trace);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.debugStringFactory.a(propagationEvent, "TRACE "));
        }
        if (trace2 == null) {
            return;
        }
        if (assessmentContext == null || !assessmentContext.isIdentityTaggingEnabled()) {
            return;
        }
        com.contrastsecurity.agent.plugins.security.controller.propagate.e.a(byArray, trace, trace2, assessmentContext);
    }

    private boolean inMasterOrSamplingScope() {
        return this.scopeProvider.isEnabled() && this.scopeProvider.scope().inMasterOrSamplingScope();
    }

    private static enum a {
        a,
        b;

    }
}

