/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.file;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.deadzone.g;
import com.contrastsecurity.agent.plugins.observe.i;
import com.contrastsecurity.agent.plugins.observe.semconv.SemanticAttributes;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;

@Singleton
@DontObfuscate
final class FileOpenCreateDispatcherImpl
implements ContrastObserveFileOpenCreateDispatcher {
    final e config;
    final d policyManager;
    final HttpManager httpManager;
    final ApplicationManager applicationManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;
    final g deadzoneManager;
    private static final String SINK_TYPE = "file-open-create";

    @Inject
    public FileOpenCreateDispatcherImpl(e e2, HttpManager httpManager, ApplicationManager applicationManager, d d2, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager, g g2) {
        this.config = e2;
        this.policyManager = d2;
        this.httpManager = httpManager;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
        this.deadzoneManager = g2;
    }

    private Span onFileAccess(String string) {
        RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return null;
        }
        return rootSpan.startChildSpan(SINK_TYPE, string);
    }

    private boolean shouldIgnore(String string) {
        if (string == null) {
            return true;
        }
        return string.endsWith(".class") || string.endsWith(".jar") || string.endsWith(".war") || string.endsWith(".ear") || string.endsWith(".css") || string.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object string(String string, String string2) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider, this.httpManager);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            if (this.shouldIgnore(string2)) {
                Object var5_4 = null;
                return var5_4;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute("file.open.path", string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uri(String string, URI uRI) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider, this.httpManager);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            String string2 = uRI.getPath();
            if (this.shouldIgnore(string2)) {
                Object var6_5 = null;
                return var6_5;
            }
            Span span = this.onFileAccess(string);
            if (span != null) {
                span.setAttribute("file.open.path", string2);
            }
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onFileReturnObserved(File file, String string) {
        if (file == null) {
            return;
        }
        this.startAndStopFileSpan(file.getPath(), string);
    }

    public void onPathObserved(Path path, String string) {
        if (path == null) {
            return;
        }
        this.startAndStopFileSpan(path.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndStopFileSpan(String string, String string2) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            if (this.shouldIgnore(string)) {
                return;
            }
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                return;
            }
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            Span span = this.onFileAccess(string2);
            if (span == null) {
                return;
            }
            span.setAttribute(SemanticAttributes.FILE_OPEN_PATH, string);
            span.end();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, SINK_TYPE, ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.root()));
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        i.a(object, this.scopeProvider, this.rootSpanManager.currentRootSpan(), this.applicationManager.current(), SINK_TYPE);
    }
}

