/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.i;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.semconv.SemanticAttributes;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@Singleton
@DontObfuscate
public final class SqlExecutionDispatcherImpl
implements ContrastObserveSqlExecutionDispatcher {
    private final ObserveRootSpanManager rootSpanManager;
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private final ApplicationManager applicationManager;
    private final ScopeProvider scopeProvider;
    private final e config;
    private static final Logger logger = LoggerFactory.getLogger(SqlExecutionDispatcherImpl.class);
    private static final String SINK_TYPE = "storage-query";

    @Inject
    public SqlExecutionDispatcherImpl(ObserveRootSpanManager observeRootSpanManager, SqlDatabaseInfoCache sqlDatabaseInfoCache, ApplicationManager applicationManager, ScopeProvider scopeProvider, e e2) {
        this.rootSpanManager = observeRootSpanManager;
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.config = e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onExecuteStart(String string, Object object) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return null;
        }
        try {
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                Object var6_5 = null;
                return var6_5;
            }
            Span span = rootSpan.startChildSpan(SINK_TYPE, string);
            this.addSpanAttributes(span, object);
            Span span2 = span;
            return span2;
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    private void addSpanAttributes(Span span, Object object) {
        if (span == null) {
            return;
        }
        try {
            Connection connection = ((Statement)object).getConnection();
            if (connection == null) {
                logger.debug("Got null connection from statement of type {}", (Object)object.getClass());
                return;
            }
            DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
            if (dbInfo == null) {
                logger.debug("Could not get database info for connection of type {}", (Object)connection.getClass());
                return;
            }
            if (dbInfo.name() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.name());
            } else if (dbInfo.db() != null) {
                span.setAttribute(SemanticAttributes.DB_NAME, dbInfo.db());
            }
            if (dbInfo.system() != null) {
                span.setAttribute(SemanticAttributes.DB_SYSTEM, dbInfo.system());
            }
            if (dbInfo.user() != null) {
                span.setAttribute(SemanticAttributes.DB_USER, dbInfo.user());
            }
            if (dbInfo.host() != null) {
                span.setAttribute(SemanticAttributes.SERVER_ADDRESS, dbInfo.host());
                if (dbInfo.port() != null) {
                    span.setAttribute(SemanticAttributes.SERVER_PORT, dbInfo.port());
                }
            }
        }
        catch (SQLException sQLException) {
            logger.debug("Unable to add span attributes because of SQL error", sQLException);
        }
    }

    public void onActionEnd(Object object) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        i.a(object, this.scopeProvider, this.rootSpanManager.currentRootSpan(), this.applicationManager.current(), SINK_TYPE);
    }
}

