/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.k.g;
import com.contrastsecurity.agent.plugins.m;
import com.contrastsecurity.agent.plugins.n;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.ah;
import com.contrastsecurity.agent.plugins.protect.b.b;
import com.contrastsecurity.agent.plugins.protect.b.c;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.h;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@DontObfuscate
public class ProtectContext
implements n<com.contrastsecurity.agent.telemetry.metrics.a.c> {
    private final c canonicalizer;
    private final Memoizer<ConcurrentHashMap<String, Object>> map;
    private final Memoizer<ConcurrentHashMap<ProtectRuleId, List<ah>>> inputs;
    private final Memoizer<ConcurrentHashMap<String, b>> canonicalizationResultsMap;
    private final a reportCard;
    private final Memoizer<Set<ProtectRuleId>> disabledRules;
    private final AtomicBoolean allowlisted;
    private final AtomicBoolean throwExceptionOnParameterAccess;
    private final AtomicBoolean allRulesDisabled;
    private final m[] runningTimeCaptures = new m[com.contrastsecurity.agent.telemetry.metrics.a.c.values().length];
    private static final Logger logger = LoggerFactory.getLogger(ProtectContext.class);

    @t
    public ProtectContext() {
        this(new c(new h(), (com.contrastsecurity.agent.commons.b)new SystemClock()), a.a.a);
    }

    public ProtectContext(ProtectContext protectContext) {
        this.canonicalizer = protectContext.canonicalizer;
        this.reportCard = protectContext.reportCard;
        this.inputs = protectContext.inputs;
        this.canonicalizationResultsMap = protectContext.canonicalizationResultsMap;
        this.map = protectContext.map;
        this.disabledRules = protectContext.disabledRules;
        this.allowlisted = protectContext.allowlisted;
        this.throwExceptionOnParameterAccess = protectContext.throwExceptionOnParameterAccess;
        this.allRulesDisabled = protectContext.allRulesDisabled;
    }

    public ProtectContext(c c2, a a2) {
        this.canonicalizer = c2;
        this.reportCard = a2;
        this.inputs = Suppliers.memoize(() -> new ConcurrentHashMap(ProtectRuleId.class.getModifiers()));
        this.canonicalizationResultsMap = Suppliers.memoize(ConcurrentHashMap::new);
        this.map = Suppliers.memoize(ConcurrentHashMap::new);
        this.disabledRules = Suppliers.memoize(() -> Collections.newSetFromMap(new ConcurrentHashMap(ProtectRuleId.values().length)));
        this.allowlisted = new AtomicBoolean();
        this.throwExceptionOnParameterAccess = new AtomicBoolean();
        this.allRulesDisabled = new AtomicBoolean();
    }

    @Override
    public m startAspectTiming(com.contrastsecurity.agent.telemetry.metrics.a.c c2) {
        m m2 = this.runningTimeCaptures[c2.ordinal()];
        if (m2 == null) {
            this.runningTimeCaptures[c2.ordinal()] = m2 = new m(this.reportCard, c2);
        }
        m2.a = this.reportCard.b();
        return m2;
    }

    @Override
    public long startAspectTiming() {
        return this.reportCard.b();
    }

    @Override
    public void endAspectTiming(com.contrastsecurity.agent.telemetry.metrics.a.c c2, long l2) {
        this.reportCard.b(c2, l2);
    }

    public void markRuleDisabled(ProtectRuleId protectRuleId) {
        this.disabledRules.get().add(protectRuleId);
    }

    public void markAllRulesDisabled() {
        this.allRulesDisabled.getAndSet(true);
    }

    @t
    boolean areAllRulesDisabled() {
        return this.allRulesDisabled.get();
    }

    public boolean isRuleDisabled(ProtectRuleId protectRuleId) {
        return this.allowlisted.get() || this.allRulesDisabled.get() || this.disabledRules != null && this.disabledRules.get().contains((Object)protectRuleId);
    }

    public boolean isRuleEnabled(ProtectRuleId protectRuleId) {
        return !this.isRuleDisabled(protectRuleId);
    }

    public List<ah> getInputs(ProtectRuleId protectRuleId) {
        List<ah> list = this.inputs.get().get((Object)protectRuleId);
        return list != null ? list : Collections.emptyList();
    }

    public void clear() {
        this.canonicalizationResultsMap.ifPresent(Map::clear);
        this.inputs.ifPresent(Map::clear);
        this.map.ifPresent(Map::clear);
        this.disabledRules.ifPresent(Set::clear);
        this.allowlisted.getAndSet(false);
        this.allRulesDisabled.getAndSet(false);
        this.throwExceptionOnParameterAccess.getAndSet(false);
    }

    public void put(String string, Object object) {
        this.map.get().put(string, object);
    }

    public Object get(String string) {
        return this.map.get().get(string);
    }

    public Object remove(String string) {
        return this.map.get().remove(string);
    }

    public void markAllowlisted() {
        this.allowlisted.getAndSet(true);
    }

    public boolean isAllowlisted() {
        return this.allowlisted.get();
    }

    public ah getFirstInput(ProtectRuleId protectRuleId) {
        List<ah> list = this.getInputs(protectRuleId);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    public void saveInput(e e2, Application application, com.contrastsecurity.agent.plugins.protect.rules.n n2, ah ah2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Saving tracked input {} to context {} with input {} for {}", ah2.a().getValue(), JVMUtils.getSafeToString(this, true), JVMUtils.getSafeToString(ah2.a(), true), n2.getRuleId().id());
        }
        boolean bl2 = !this.appliesToApplicationCheckEnabled(e2) || n2.appliesToApplication(application);
        ah2.a(bl2);
        this.inputs.get().computeIfAbsent(n2.getRuleId(), protectRuleId -> new LinkedList()).add(ah2);
    }

    public b canonicalize(String string) {
        b b2 = this.canonicalizationResultsMap.get().get(string);
        if (b2 == null) {
            b2 = this.canonicalizer.a(string);
            this.canonicalizationResultsMap.get().put(string, b2);
        }
        return b2;
    }

    @t
    b getCachedCanonicalizationResults(String string) {
        return this.canonicalizationResultsMap.get().get(string);
    }

    public void finalizeRequestTiming(g g2) {
        long l2 = this.reportCard.a(com.contrastsecurity.agent.telemetry.metrics.a.c.a) + this.reportCard.a(com.contrastsecurity.agent.telemetry.metrics.a.c.b);
        this.reportCard.a(com.contrastsecurity.agent.telemetry.metrics.a.c.c, l2);
        this.reportCard.a(g2);
    }

    public void throwExceptionOnParameterAccess(boolean bl2) {
        this.throwExceptionOnParameterAccess.getAndSet(bl2);
    }

    boolean shouldThrowExceptionOnParameterAccess() {
        return this.throwExceptionOnParameterAccess.get();
    }

    private boolean appliesToApplicationCheckEnabled(e e2) {
        return e2.c(ConfigProperty.PROTECT_APPCHECK_ENABLED);
    }
}

