/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.messages.server.features.assessment.CustomRuleAPI;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.EventHelper;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.a.b;
import com.contrastsecurity.agent.plugins.security.controller.a.d;
import com.contrastsecurity.agent.plugins.security.controller.a.e;
import com.contrastsecurity.agent.plugins.security.controller.a.i;
import com.contrastsecurity.agent.plugins.security.controller.a.j;
import com.contrastsecurity.agent.plugins.security.controller.a.k;
import com.contrastsecurity.agent.plugins.security.controller.a.l;
import com.contrastsecurity.agent.plugins.security.controller.a.n;
import com.contrastsecurity.agent.plugins.security.controller.a.o;
import com.contrastsecurity.agent.plugins.security.controller.a.p;
import com.contrastsecurity.agent.plugins.security.controller.a.q;
import com.contrastsecurity.agent.plugins.security.controller.a.r;
import com.contrastsecurity.agent.plugins.security.controller.a.s;
import com.contrastsecurity.agent.plugins.security.controller.a.t;
import com.contrastsecurity.agent.plugins.security.controller.a.u;
import com.contrastsecurity.agent.plugins.security.controller.a.v;
import com.contrastsecurity.agent.plugins.security.controller.a.w;
import com.contrastsecurity.agent.plugins.security.controller.a.x;
import com.contrastsecurity.agent.plugins.security.controller.a.y;
import com.contrastsecurity.agent.plugins.security.controller.a.z;
import com.contrastsecurity.agent.plugins.security.controller.h;
import com.contrastsecurity.agent.plugins.security.controller.trigger.ObjectCheck;
import com.contrastsecurity.agent.plugins.security.e.f;
import com.contrastsecurity.agent.plugins.security.g;
import com.contrastsecurity.agent.plugins.security.m;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ApplicationAnalyzer;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.crossdomainpolicy.CrossDomainResponseWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.crossdomainpolicy.c;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.u.B;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Singleton
@DontObfuscate
public final class AssessPlugin
extends ContrastPlugin
implements com.contrastsecurity.agent.instr.a.c {
    private final List<com.contrastsecurity.agent.util.z> assessInitializationTasks;
    private final com.contrastsecurity.agent.config.e config;
    private final EventHelper eventHelper;
    private final List<com.contrastsecurity.agent.plugins.d> classEventListeners;
    private final com.contrastsecurity.agent.plugins.security.policy.rules.providers.c ruleActivityListener;
    private final com.contrastsecurity.agent.plugins.security.policy.rules.providers.h ruleProviders;
    private final com.contrastsecurity.agent.features.b featureManager;
    private final List<com.contrastsecurity.agent.http.p> requestListeners;
    private final AssessmentManager assessmentManager;
    private final EventContext eventContext;
    private final HttpManager httpManager;
    private final ScopeProviderAssess scopeProviderAssess;
    private final com.contrastsecurity.agent.plugins.security.b.a debugStringFactory;
    private final TraceController traceController;
    private final h scopeHandler;
    private final int maxRequestBodyBuffering;
    private final com.contrastsecurity.agent.plugins.security.policy.d policyManager;
    private final Purgeable heapProfilerAssessObjects;
    private Set<String> securityControlClassNames;
    private static final Logger logger = LoggerFactory.getLogger(AssessPlugin.class);

    public AssessPlugin(com.contrastsecurity.agent.services.a.f<ObservedRoute> f2, ApplicationManager applicationManager, AssessmentManager assessmentManager, EventContext eventContext, com.contrastsecurity.agent.instr.a.b b2, com.contrastsecurity.agent.commons.b b3, com.contrastsecurity.agent.config.e e2, com.contrastsecurity.agent.plugins.security.policy.d d2, com.contrastsecurity.agent.o.e e3, com.contrastsecurity.agent.services.d d3, com.contrastsecurity.agent.features.b b4, com.contrastsecurity.agent.plugins.frameworks.p p2, com.contrastsecurity.agent.j.g g2, HttpManager httpManager, Instrumentation instrumentation, com.contrastsecurity.agent.plugins.frameworks.j2ee.i i2, com.contrastsecurity.agent.services.ngreporting.h h2, com.contrastsecurity.agent.o.l l2, f f3, B b5, com.contrastsecurity.agent.v.m m2, com.contrastsecurity.agent.telemetry.h h3, com.contrastsecurity.agent.telemetry.errors.o o2, TelemetryMetrics telemetryMetrics, WorkingDirectories workingDirectories, com.contrastsecurity.agent.plugins.j j2, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, HeapProfiler heapProfiler) {
        this.eventContext = eventContext;
        g g3 = m.a().a(applicationManager).a(assessmentManager).a(this).a(eventContext).a(b3).a(e2).a(b2).a(e3).a(d3).a(b4).a(p2).a(g2).a(httpManager).a(instrumentation).a(i2).a(h2).a(l2).a(f2).a(d2).a(f3).a(b5).a(m2).a(h3).a(o2).a(telemetryMetrics).a(workingDirectories).a(j2).a();
        this.config = e2;
        this.featureManager = b4;
        this.httpManager = httpManager;
        this.assessmentManager = assessmentManager;
        this.traceController = g3.b();
        this.eventHelper = g3.c();
        this.classEventListeners = Lists.of(g3.d());
        this.ruleActivityListener = g3.h();
        this.ruleProviders = g3.i();
        applicationSettingsUpdateEventBus.addListener(g3.j());
        this.scopeProviderAssess = g3.l();
        this.debugStringFactory = g3.k();
        this.policyManager = Objects.requireNonNull(d2);
        d2.a(g3.f());
        this.scopeHandler = g3.g();
        this.assessInitializationTasks = Lists.of(new a(h3));
        this.requestListeners = g3.e();
        this.maxRequestBodyBuffering = e2.d(ConfigProperty.MAX_REQUEST_BODY_BUFFERING_DEFAULT);
        this.heapProfilerAssessObjects = heapProfiler.assessPurgeable();
    }

    public static void setEnabled(EventContext eventContext, ScopeProviderAssess scopeProviderAssess, boolean bl2) {
        eventContext.setEnabled(bl2);
        scopeProviderAssess.setEnabled(bl2);
    }

    @Override
    public boolean preventDenylistingOf(String string) {
        if (this.securityControlClassNames == null) {
            this.buildSecurityControlClassList(this.featureManager.b());
        }
        return this.securityControlClassNames.contains(string);
    }

    void buildSecurityControlClassList(ServerSettingsAssessDTM serverSettingsAssessDTM) {
        if (!this.config.c(ConfigProperty.ASSESS_ENABLED) || serverSettingsAssessDTM == null) {
            this.securityControlClassNames = Collections.emptySet();
            return;
        }
        this.securityControlClassNames = new HashSet<String>();
        this.parseSecurityControl(serverSettingsAssessDTM.getSanitizers());
        this.parseSecurityControl(serverSettingsAssessDTM.getValidators());
    }

    private <T extends CustomRuleAPI> void parseSecurityControl(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (CustomRuleAPI customRuleAPI : collection) {
            Set<String> set = this.parseClassNames(customRuleAPI.getApi());
            if (set.isEmpty()) continue;
            logger.debug("Adding {} to the list of security control class names to prevent denylisting", (Object)set);
            this.securityControlClassNames.addAll(set);
        }
    }

    private Set<String> parseClassNames(String string) {
        try {
            com.contrastsecurity.agent.plugins.security.policy.t t2 = com.contrastsecurity.agent.plugins.security.policy.v.a(string, Collections.emptySet(), false, true);
            return t2.a();
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem parsing API {} to prevent denylisting new security controls", (Object)string, (Object)exception2);
            return Collections.emptySet();
        }
    }

    @Override
    public List<com.contrastsecurity.agent.plugins.d> getClassTransformationListeners() {
        if (this.config.c(ConfigProperty.ASSESS_ENABLED)) {
            return this.classEventListeners;
        }
        return Collections.emptyList();
    }

    @Override
    public List<com.contrastsecurity.agent.http.p> getRequestLifecycleListeners() {
        return this.requestListeners;
    }

    @Override
    public void initialize() throws com.contrastsecurity.agent.plugins.i {
        if (!this.config.c(ConfigProperty.ASSESS_ENABLED)) {
            logger.debug("Not assessing, so skipping policy lookup");
            return;
        }
        for (com.contrastsecurity.agent.util.z z2 : this.assessInitializationTasks) {
            z2.b();
        }
    }

    @Override
    public void onCrossDomainXmlRead(Application application, String string) {
        if (!this.config.c(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        for (com.contrastsecurity.agent.plugins.security.policy.rules.providers.f<?> f2 : this.ruleProviders) {
            if (!(f2 instanceof c)) continue;
            HttpWatcher httpWatcher = f2.d();
            if (httpWatcher instanceof CrossDomainResponseWatcher) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Handing analysis of crossdomain.xml to {}", (Object)httpWatcher.getClass().getName());
                }
                try {
                    ((CrossDomainResponseWatcher)httpWatcher).analyzeCrossDomainXML(application, string);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.error("Problem during crossDomainXmlRead() for {}", (Object)f2.getClass().getName(), (Object)throwable2);
                }
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.error("Problem finding the cross domain watcher");
        }
    }

    @Override
    public void onWebConfigurationRead(Application application, String string) {
        if (!this.config.c(ConfigProperty.ASSESS_ENABLED)) {
            return;
        }
        logger.debug("Letting rule providers know about new app loaded");
        for (com.contrastsecurity.agent.plugins.security.policy.rules.providers.f<?> f2 : this.ruleProviders) {
            ApplicationAnalyzer applicationAnalyzer = f2.e();
            if (applicationAnalyzer == null) continue;
            logger.debug("Handing analysis of web root to {}", (Object)applicationAnalyzer.getClass().getName());
            try {
                applicationAnalyzer.onApplicationResolution(application, string);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem during onWebXmlLoaded() for {}", (Object)f2.getClass().getName(), (Object)throwable2);
            }
        }
    }

    @Override
    public boolean requiresPrimordialInstrumentation(Class<?> clazz) {
        return this.config.c(ConfigProperty.ASSESS_ENABLED);
    }

    @Override
    public boolean requiresHttpResponseBuffering(HttpRequest httpRequest, HttpResponse httpResponse) {
        return this.isActivated() && !com.contrastsecurity.agent.util.r.b(httpRequest) && !httpRequest.getResponseWatchers().isEmpty();
    }

    @Override
    public com.contrastsecurity.agent.plugins.f getActivityEventListener() {
        com.contrastsecurity.agent.plugins.security.policy.rules.providers.c c2 = null;
        if (this.config.c(ConfigProperty.ASSESS_ENABLED)) {
            c2 = this.ruleActivityListener;
        }
        return c2;
    }

    @Override
    public int limitRequestBodySizeCapturing() {
        return this.maxRequestBodyBuffering;
    }

    public void onSecurityControlsChanged() {
        this.securityControlClassNames = null;
    }

    @Override
    public boolean isActivated() {
        return super.isActivated() && this.config.c(ConfigProperty.ASSESS_ENABLED);
    }

    @Override
    public boolean isActivatedForUri(Application application, HttpRequest httpRequest) {
        return this.isActivated() && !this.isDisabledUri(httpRequest, application, this.config);
    }

    @Override
    public void activate() {
        super.activate();
        AssessPlugin.setEnabled(this.eventContext, this.scopeProviderAssess, true);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        AssessPlugin.setEnabled(this.eventContext, this.scopeProviderAssess, false);
    }

    @Override
    public List<Purgeable> getPurgeables() {
        return Lists.of(this.debugStringFactory, this.eventContext, this.heapProfilerAssessObjects);
    }

    @Override
    protected boolean isDisabledUri(HttpRequest httpRequest, Application application, com.contrastsecurity.agent.config.e e2) {
        if (httpRequest == null || application == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.g g2 = application.getExclusionProcessor();
        return g2.isDisabledByUrl(c.a.a, "all-rules", httpRequest.getUri()) || g2.isDisabledByUrl(c.a.a, "all-assess-rules", httpRequest.getUri());
    }

    private class a
    extends com.contrastsecurity.agent.util.z {
        private a(com.contrastsecurity.agent.telemetry.h h2) {
            super(h2, "register-agent-telemetry", PerfUtil.a.c);
        }

        @Override
        public void a() {
            AgentChannelHub agentChannelHub = AgentChannelHub.getOrNull(AssessPlugin.this.config);
            if (agentChannelHub == null) {
                return;
            }
            agentChannelHub.listenForMessage("isTracked", new v(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithTag", new w(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithoutTag", new y(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("isTrackedWithType", new x(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("printTagRanges", new z(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasFinding", new r(AssessPlugin.this.assessmentManager));
            agentChannelHub.listenForMessage("hasNoFinding", new t(AssessPlugin.this.assessmentManager));
            agentChannelHub.listenForMessage("hasEventSource", new q(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("enableRecentFindings", new com.contrastsecurity.agent.plugins.security.controller.a.f(AssessPlugin.this.assessmentManager));
            agentChannelHub.listenForMessage("clearRecentFindings", new com.contrastsecurity.agent.plugins.security.controller.a.c(AssessPlugin.this.assessmentManager));
            agentChannelHub.listenForMessage("getBitSetForObject", new com.contrastsecurity.agent.plugins.security.controller.a.g(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventStringRepresentations", new j(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventOperations", new com.contrastsecurity.agent.plugins.security.controller.a.h(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasTagRange", new u(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("hasFrameworkInfo", new s(AssessPlugin.this.httpManager));
            agentChannelHub.listenForMessage("getTagRangeCount", new com.contrastsecurity.agent.plugins.security.controller.a.m(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getCurrentRequestInfo", new k(AssessPlugin.this.httpManager));
            agentChannelHub.listenForMessage("getTagRanges", new n(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("addTags", new b(AssessPlugin.this.eventHelper, AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTags", new o(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("addTagFrom", new com.contrastsecurity.agent.plugins.security.controller.a.a(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("doesTagCheckPass", new e(new ObjectCheck(AssessPlugin.this.eventHelper, AssessPlugin.this.traceController), AssessPlugin.this.traceController, AssessPlugin.this.policyManager));
            agentChannelHub.listenForMessage("clearTagRanges", new d(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getTriggerScope", new p(AssessPlugin.this.eventContext, AssessPlugin.this.scopeHandler));
            agentChannelHub.listenForMessage("getSourceEventReturn", new l(AssessPlugin.this.traceController));
            agentChannelHub.listenForMessage("getEventStackTrace", new i(AssessPlugin.this.assessmentManager, AssessPlugin.this.traceController));
            agentChannelHub.subscribe(AssessPlugin.this.config, "clearTraceMap", AssessPlugin.this.eventContext);
        }
    }
}

