/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.plugins.security.controller.o;
import com.contrastsecurity.agent.plugins.security.controller.trigger.p;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.y;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements p {
    private final HttpManager httpManager;
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    public AssessSourceExclusionHandler(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, o o2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl2 = true;
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        g g2 = application.getExclusionProcessor();
        for (int i2 = 0; i2 < list.size() && bl2; ++i2) {
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl2 = !this.isSourceExclusion(trace, rule, (SourceEvent)codeEvent, httpRequest, g2);
        }
        return bl2;
    }

    @t
    boolean isSourceExclusion(Trace trace, Rule rule, SourceEvent sourceEvent, HttpRequest httpRequest, g g2) {
        if (g2 == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        String string = rule.getId();
        SourceNode sourceNode = sourceEvent.getSource();
        if (!sourceNode.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)sourceNode.getId());
            return false;
        }
        if (sourceEvent.getQueue() != null && (sourceNode.isSourceType(y.u) || sourceNode.isSourceType(y.v) || sourceNode.isSourceType(y.w) || sourceNode.isSourceType(y.x))) {
            return g2.isQueueExclusion(c.a.a, string, sourceEvent.getQueue());
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        if (sourceNode.isSourceType(y.g)) {
            String string2 = this.extractInputName(trace, sourceEvent, sourceNode);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.PARAMETER, string2);
        }
        if (sourceNode.isSourceType(y.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, sourceNode);
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, string3);
        }
        if (sourceNode.isSourceType(y.h)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.QUERYSTRING);
        }
        if (sourceNode.isSourceType(y.c)) {
            String string4 = sourceEvent.getFieldName();
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.COOKIE, string4);
        }
        if (sourceNode.isSourceType(y.a) || sourceNode.isSourceType(y.f)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.BODY);
        }
        if (sourceNode.isSourceType(y.t)) {
            return g2.isInputExclusion(c.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, "authorization");
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, SourceNode sourceNode) {
        String string = null;
        if (sourceEvent != null) {
            string = sourceEvent.getFieldName();
        }
        if (sourceEvent != null && string == null) {
            String string2;
            int n2;
            if (sourceNode != null && sourceNode.isSourceType(y.q)) {
                if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                    string = sourceEvent.getParameters()[0].b();
                }
            } else if (sourceNode != null && sourceNode.isSourceType(y.p) && trace != null && trace.getEvents() != null && !trace.getEvents().isEmpty() && (n2 = trace.getEvents().indexOf(sourceEvent)) >= 0 && trace.getEvents().size() > n2 && (string2 = trace.getEvents().get(n2 + 1).getRet()) != null && !string2.isEmpty()) {
                string = string2;
            }
        }
        return string;
    }
}

