/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.propagate;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.c.d;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.propagate.e;
import com.contrastsecurity.agent.plugins.security.model.h;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.a.j;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.plugins.security.policy.q;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.v.m;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Set;

@Singleton
@DontObfuscate
public final class PropagationHandler
implements q {
    private ContrastPolicy.c propagators;
    private Map<Integer, Propagator> customSanitizers;
    private final e propagationMachine;
    private final ScopeProviderAssess scopeProviderAssess;
    private final EventContext eventContext;
    private final TraceController traceController;
    private final AssessmentManager assessmentManager;
    private final m stackCaptureFactory;
    private final a methodDescriptionCache;
    private final j propagatorAdaptiveOptimizer;
    private final com.contrastsecurity.agent.plugins.security.policy.d policyManager;
    private final Set<d> propagationListeners;
    private static final Logger logger = LoggerFactory.getLogger(PropagationHandler.class);

    @Inject
    public PropagationHandler(e e2, AssessmentManager assessmentManager, ScopeProviderAssess scopeProviderAssess, EventContext eventContext, TraceController traceController, m m2, a a2, j j2, com.contrastsecurity.agent.plugins.security.policy.d d2, Set<d> set) {
        this.propagationMachine = e2;
        this.scopeProviderAssess = scopeProviderAssess;
        this.eventContext = eventContext;
        this.traceController = traceController;
        this.assessmentManager = assessmentManager;
        this.stackCaptureFactory = m2;
        this.methodDescriptionCache = a2;
        this.propagatorAdaptiveOptimizer = j2;
        this.policyManager = d2;
        this.propagationListeners = set;
        ContrastPolicy contrastPolicy = d2.e();
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    @Override
    public void onPolicyChanged(ContrastPolicy contrastPolicy) {
        this.propagators = contrastPolicy.getFastPropagatorLookup();
        this.customSanitizers = contrastPolicy.getIndexedSanitizers();
    }

    public boolean isScopedPropagationAllowed(ScopeAssess scopeAssess) {
        if (!this.scopeProviderAssess.isEnabled()) {
            return false;
        }
        return scopeAssess.getSamplingScope() == 0 && scopeAssess.scope() == 0 && scopeAssess.getPropagationScope() == 1;
    }

    public boolean isUnscopedPropagationAllowed(ScopeAssess scopeAssess) {
        if (!this.scopeProviderAssess.isEnabled()) {
            return true;
        }
        return scopeAssess.getSamplingScope() == 0 && scopeAssess.scope() == 0;
    }

    public void enterPropagationScope(ScopeAssess scopeAssess) {
        scopeAssess.enterPropagationScope();
    }

    public void leavePropagationScope(ScopeAssess scopeAssess) {
        scopeAssess.leavePropagationScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropagation(ScopeAssess scopeAssess, String string, String string2, int n2, Object object, Class<?> clazz, Object[] objectArray, Class<?>[] classArray, Object object2, Class<?> clazz2, int n3, boolean bl2, boolean bl3, int[] nArray) {
        try {
            scopeAssess.enterScope();
            Propagator propagator = this.getPropagator(n3, bl2);
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null && assessmentContext.hasReachedMaximumPropagationEvents()) {
                if (propagator.loggedMaximumEvents()) {
                    logger.debug("Ignoring propagator {} because maximum reached", (Object)propagator.getId());
                } else {
                    logger.warn("Ignoring propagator {} because maximum reached, consider increasing maximum events via the `assess.max_propagation_events` property. Further events will be logged at the `DEBUG` level", (Object)propagator.getId());
                }
                return;
            }
            Map<Object, Trace> map = this.eventContext.getTraceMap(assessmentContext);
            if (map == null) {
                return;
            }
            if (!this.shouldPropagate(propagator, clazz, object, objectArray, nArray, clazz2, object2)) {
                return;
            }
            MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, clazz.getName(), string, string2, n2);
            h h2 = new h();
            h2.a(object);
            h2.a(objectArray);
            h2.b(object2);
            h2.a(methodDescription);
            h2.a(propagator);
            h2.a(clazz);
            h2.b(clazz2);
            h2.a(bl3);
            h2.a(map);
            h2.b(System.currentTimeMillis());
            h2.a(this.stackCaptureFactory.a(m.a.b));
            for (d d2 : this.propagationListeners) {
                if (d2.a(h2)) continue;
                return;
            }
            this.doPropagation(assessmentContext, h2);
            this.propagatorAdaptiveOptimizer.a(this.policyManager, h2);
            if (assessmentContext != null) {
                assessmentContext.onPropagationRecorded();
            }
            for (d d2 : this.propagationListeners) {
                d2.a(scopeAssess, h2);
            }
        }
        catch (InvalidTagRangeException invalidTagRangeException) {
            logger.debug("Invalid tag range exception", invalidTagRangeException);
        }
        finally {
            scopeAssess.leaveScope();
        }
    }

    private Propagator getPropagator(int n2, boolean bl2) {
        Propagator propagator;
        if (bl2 && logger.isDebugEnabled()) {
            logger.debug("custom sanitizer propagator index detected {} ({} total standard propagators)", (Object)n2, (Object)this.propagators.b());
        }
        Propagator propagator2 = propagator = bl2 ? this.customSanitizers.get(n2) : this.propagators.a(n2);
        if (propagator == null) {
            throw new IllegalStateException("Unable to find valid propagator at index " + n2);
        }
        return propagator;
    }

    private boolean shouldPropagate(Propagator propagator, Class<?> clazz, Object object, Object[] objectArray, int[] nArray, Class<?> clazz2, Object object2) {
        boolean bl2 = this.verifySourcePropagation(propagator, clazz, object, objectArray);
        bl2 = bl2 && this.verifyTargetPropagation(propagator, clazz, object, clazz2, object2);
        return bl2;
    }

    private boolean verifySourcePropagation(Propagator propagator, Class<?> clazz, Object object, Object[] objectArray) {
        n[] nArray = propagator.getSources();
        n[] nArray2 = propagator.getTargets();
        boolean bl2 = false;
        if (nArray != null && nArray2 != null) {
            if (nArray.length == 1 && nArray2.length == 1) {
                n n2 = nArray[0];
                n n3 = nArray2[0];
                bl2 = n2.a() && n3.a() ? clazz != String.class && this.traceController.isTracked(object) : true;
            } else {
                for (int i2 = 0; i2 < nArray.length && !bl2; ++i2) {
                    n n4 = nArray[i2];
                    if (n4.a()) {
                        bl2 = this.traceController.isTracked(object);
                        continue;
                    }
                    if (objectArray == null) continue;
                    if (n4.d()) {
                        int n5 = n4.g();
                        if (n5 >= objectArray.length) continue;
                        bl2 = this.traceController.isTracked(objectArray[n5]);
                        continue;
                    }
                    if (!n4.c()) continue;
                    String string = n4.j();
                    for (int i3 = 0; !bl2 && i3 < objectArray.length; ++i3) {
                        if (objectArray[i3] == null || !JVMUtils.isInstanceOf(objectArray[i3], string)) continue;
                        bl2 = this.traceController.isTracked(objectArray[i3]);
                    }
                }
            }
        }
        return bl2;
    }

    private boolean verifyTargetPropagation(Propagator propagator, Class<?> clazz, Object object, Class<?> clazz2, Object object2) {
        n[] nArray = propagator.getTargets();
        boolean bl2 = false;
        Object object3 = null;
        Class<?> clazz3 = null;
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length && !bl2; ++i2) {
                n n2 = nArray[i2];
                if (n2.a()) {
                    object3 = object;
                    clazz3 = clazz;
                } else if (n2.b()) {
                    object3 = object2;
                    clazz3 = clazz2;
                } else {
                    bl2 = true;
                }
                if (bl2) continue;
                bl2 = object3 != null;
                bl2 = bl2 && (clazz3 != String.class || !this.traceController.isTracked(object3));
            }
        }
        return bl2;
    }

    private void doPropagation(AssessmentContext assessmentContext, h h2) throws InvalidTagRangeException {
        Propagator propagator = h2.e();
        boolean bl2 = h2.i();
        Map<Object, Trace> map = h2.k();
        n[] nArray = propagator.getSources();
        n[] nArray2 = propagator.getTargets();
        if (nArray != null && nArray2 != null) {
            boolean bl3;
            n n2;
            int n3;
            int n4 = -1;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (n2.a() && this.traceController.isTracked(h2.b())) {
                    n4 = n3;
                    continue;
                }
                if (!n2.c() || (bl3 = n2.g()) || !this.traceController.isTracked(h2.c()[bl3])) continue;
                n4 = n3;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                bl3 = n3 == nArray.length - 1;
                bl3 = bl3 || n3 == n4;
                bl3 = bl3 || n2.c() && propagator.getCountOfArgSources() > 1;
                Object object = this.getObjectFromContextAtLocation(h2, n2);
                for (n n5 : nArray2) {
                    Object object2 = this.getObjectFromContextAtLocation(h2, n5);
                    if (object == null || object2 == null) continue;
                    if (n2.a() && n5.a()) {
                        this.propagationMachine.a(assessmentContext, object, h2);
                        continue;
                    }
                    this.propagationMachine.a(object, object2, h2, bl2, map, bl3);
                }
            }
        }
    }

    private Object getObjectFromContextAtLocation(h h2, n n2) {
        Object object = h2.b();
        Object object2 = h2.d();
        Object[] objectArray = h2.c();
        Object object3 = null;
        if (n2.a()) {
            object3 = object;
        } else if (n2.d()) {
            int n3 = n2.g();
            object3 = n3 < objectArray.length ? objectArray[n3] : null;
        } else if (n2.f()) {
            for (int i2 = 0; object3 == null && i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null || !JVMUtils.isInstanceOf(objectArray[i2], n2.i())) continue;
                object3 = objectArray[i2];
            }
        } else if (n2.b()) {
            object3 = object2;
        }
        return object3;
    }
}

