/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.propagators;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.plugins.security.policy.h;
import com.contrastsecurity.agent.plugins.security.policy.n;
import com.contrastsecurity.agent.plugins.security.policy.o;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
public class Propagator
extends h
implements Cloneable {
    private String propagationType;
    private final Command cmd;
    private n[] sources;
    private final String[] cmdArguments;
    private int[] integerCmdArguments;
    private boolean[] isLiteralCmdArguments;
    private final Set<String> tags;
    private final Set<String> untags;
    private final boolean cloneOnUnchangedCloneableSource;
    private final boolean shouldTagsApplyWhenInvokedDuringSources;
    private final AtomicInteger totalTimesHit;
    private final AtomicBoolean currentlyDeadzoning;
    private final AtomicBoolean loggedMaximumEvents;
    private Set<String> requiredParameterTypes;
    private static final String TYPE_A2A = "A2A";
    private static final String TYPE_A2O = "A2O";
    private static final String TYPE_A2P = "A2P";
    private static final String TYPE_A2R = "A2R";
    private static final String TYPE_O2A = "O2A";
    private static final String TYPE_O2O = "O2O";
    private static final String TYPE_O2P = "O2P";
    private static final String TYPE_O2R = "O2R";
    private static final String TYPE_P2A = "P2A";
    private static final String TYPE_P2O = "P2O";
    private static final String TYPE_P2P = "P2P";
    private static final String TYPE_P2R = "P2R";
    private static final Logger logger = LoggerFactory.getLogger(Propagator.class);

    public Propagator(int n2, String string, String string2, n[] nArray, n[] nArray2, Command command, String[] stringArray, Set<String> set, Set<String> set2, boolean bl2, boolean bl3, o o2) {
        super(n2, string, string2, nArray2, o2);
        this.sources = Objects.requireNonNull(nArray);
        Preconditions.check(nArray.length > 0, "Propagator with ID=%s has no sources", string2);
        this.isLiteralCmdArguments = new boolean[2];
        this.cmd = command;
        this.cmdArguments = stringArray;
        this.totalTimesHit = new AtomicInteger();
        this.currentlyDeadzoning = new AtomicBoolean();
        this.loggedMaximumEvents = new AtomicBoolean();
        this.requiredParameterTypes = Collections.emptySet();
        this.tags = set != null ? set : Collections.emptySet();
        this.untags = set2 != null ? set2 : Collections.emptySet();
        for (String string3 : this.tags) {
            if (!this.untags.contains(string3)) continue;
            throw new IllegalArgumentException("Propagator with ID=" + string2 + " has overlapping tags and untags");
        }
        this.cloneOnUnchangedCloneableSource = bl2;
        if (bl3) {
            Preconditions.check(this.tags.size() + this.untags.size() > 0, "Propagator with ID=%s has no tags, but is configured to apply during sources", string2);
        }
        this.shouldTagsApplyWhenInvokedDuringSources = bl3;
        this.parseCommandArguments();
        this.calculatePropagationType();
    }

    public boolean loggedMaximumEvents() {
        return this.loggedMaximumEvents.getAndSet(true);
    }

    public n[] getSources() {
        return this.sources;
    }

    public Set<String> getRequiredParameterTypes() {
        return this.requiredParameterTypes;
    }

    public void setSources(n[] nArray) {
        this.sources = nArray;
    }

    public int getCountOfArgSources() {
        int n2 = 0;
        if (this.sources != null) {
            for (n n3 : this.sources) {
                n2 += n3.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public int getCountOfArgTargets() {
        int n2 = 0;
        if (this.targets != null) {
            for (n n3 : this.targets) {
                n2 += n3.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getUntags() {
        return this.untags;
    }

    public boolean isCloneOnUnchangedCloneableSource() {
        return this.cloneOnUnchangedCloneableSource;
    }

    public boolean isShouldTagsApplyWhenInvokedDuringSources() {
        return this.shouldTagsApplyWhenInvokedDuringSources;
    }

    public int onHit() {
        return this.totalTimesHit.incrementAndGet();
    }

    public boolean attemptToEnterExclusiveAccess() {
        return this.currentlyDeadzoning.compareAndSet(false, true);
    }

    public void exitExclusiveAccess() {
        boolean bl2 = this.currentlyDeadzoning.compareAndSet(true, false);
        if (!bl2) {
            logger.warn("Leaving adaptive optimisation for propagation deadzoning, exclusive check failed on exit: {}", (Object)this.getId());
        }
    }

    public void setTargetDescription(String string) {
        this.targetType = string;
    }

    public String getPropagationType() {
        return this.propagationType;
    }

    public String[] getCommandArguments() {
        return this.cmdArguments;
    }

    public int getParameterValue(int n2, Object[] objectArray) {
        if (this.cmdArguments == null || this.cmdArguments.length == 0 || this.integerCmdArguments == null || this.integerCmdArguments.length == 0) {
            logger.error("Configuration problem 1 with command parameters for {}", (Object)this.getId());
        }
        if (this.isLiteralCmdArguments != null && this.isLiteralCmdArguments[n2]) {
            return this.integerCmdArguments[n2];
        }
        if (objectArray == null || n2 > this.integerCmdArguments.length || this.integerCmdArguments[n2] > objectArray.length) {
            logger.error("Configuration problem 2 with command parameters for {}", (Object)this.getId());
        }
        return (Integer)objectArray[this.integerCmdArguments[n2]];
    }

    public Command getCommand() {
        return this.cmd;
    }

    private void parseCommandArguments() {
        boolean bl2 = this.cmdArguments != null;
        int n2 = bl2 ? this.cmdArguments.length : 0;
        this.integerCmdArguments = new int[n2];
        this.isLiteralCmdArguments = new boolean[n2];
        if (bl2 && (n2 != 1 || this.cmdArguments[0].length() > 0)) {
            for (int i2 = 0; i2 < this.cmdArguments.length; ++i2) {
                if (this.cmdArguments[i2].charAt(0) == 'P') {
                    this.cmdArguments[i2] = this.cmdArguments[i2].substring(1);
                    this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]) - 1;
                    continue;
                }
                this.isLiteralCmdArguments[i2] = true;
                this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]);
            }
        }
    }

    private void setLiteralCommandArguments(boolean[] blArray) {
        this.isLiteralCmdArguments = blArray;
    }

    private void setIntegerCommandArguments(int[] nArray) {
        this.integerCmdArguments = nArray;
    }

    public Propagator clone() {
        Propagator propagator = new Propagator(this.policyId, this.policyLocation, this.getId(), this.sources, this.targets, this.cmd, this.cmdArguments != null ? (String[])this.cmdArguments.clone() : null, this.tags, this.untags, this.cloneOnUnchangedCloneableSource, this.shouldTagsApplyWhenInvokedDuringSources, this.getMethodMatcher());
        propagator.setLiteralCommandArguments(this.isLiteralCmdArguments != null ? (boolean[])this.isLiteralCmdArguments.clone() : null);
        propagator.setIntegerCommandArguments(this.integerCmdArguments != null ? (int[])this.integerCmdArguments.clone() : null);
        propagator.deep = this.deep;
        propagator.scoped = this.scoped;
        propagator.operation = this.operation;
        return propagator;
    }

    void setRequiredParameterTypes(Set<String> set) {
        this.requiredParameterTypes = set;
    }

    private void calculatePropagationType() {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (n n2 : this.sources) {
            bl2 = bl2 || n2.a();
            bl3 = bl3 || n2.c();
        }
        n[] nArray = this.targets;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n n2;
            n2 = nArray[i2];
            bl4 = bl4 || n2.a();
            bl5 = bl5 || n2.c();
            bl6 = bl6 || n2.b();
        }
        boolean bl7 = bl2 && bl3;
        int n4 = n3 = bl4 && bl5 || bl4 && bl6 || bl5 && bl6 ? 1 : 0;
        if (bl7) {
            if (n3 != 0) {
                this.propagationType = TYPE_A2A;
            } else if (bl4) {
                this.propagationType = TYPE_A2O;
            } else if (bl5) {
                this.propagationType = TYPE_A2P;
            } else if (bl6) {
                this.propagationType = TYPE_A2R;
            }
        } else if (bl2) {
            if (n3 != 0) {
                this.propagationType = TYPE_O2A;
            } else if (bl4) {
                this.propagationType = TYPE_O2O;
            } else if (bl5) {
                this.propagationType = TYPE_O2P;
            } else if (bl6) {
                this.propagationType = TYPE_O2R;
            }
        } else if (bl3) {
            if (n3 != 0) {
                this.propagationType = TYPE_P2A;
            } else if (bl4) {
                this.propagationType = TYPE_P2O;
            } else if (bl5) {
                this.propagationType = TYPE_P2P;
            } else if (bl6) {
                this.propagationType = TYPE_P2R;
            }
        }
    }

    @Override
    protected String getTypeLabel() {
        return "propagator";
    }

    @DontObfuscate
    public static enum Command {
        ALL,
        INSERT,
        APPEND,
        REMOVE,
        REPLACE,
        SUBSET,
        KEEP,
        GUESS,
        CONCAT,
        PREPEND,
        OVERWRITE,
        STRIP_WHITESPACE,
        STRIP_TRAILING_WHITESPACE,
        STRIP_LEADING_WHITESPACE;

    }
}

