/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.n;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.s;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.TraceEvent;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Map;

@Singleton
@DontObfuscate
public class ProviderUtil {
    private final com.contrastsecurity.agent.config.e config;
    private final h legacyReportingService;
    private final Finding.d findingFactory;
    private final e traceFactory;
    private final n disabledRulesFilter;
    private final AssessmentManager assessmentManager;
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final d policyManager;
    private static final Logger logger = LoggerFactory.getLogger(ProviderUtil.class);

    @Inject
    public ProviderUtil(com.contrastsecurity.agent.config.e e2, AssessmentManager assessmentManager, ApplicationManager applicationManager, Finding.d d2, HttpManager httpManager, h h2, e e3, d d3, n n2) {
        this.assessmentManager = assessmentManager;
        this.applicationManager = applicationManager;
        this.policyManager = d3;
        this.config = e2;
        this.findingFactory = d2;
        this.httpManager = httpManager;
        this.legacyReportingService = h2;
        this.traceFactory = e3;
        this.disabledRulesFilter = n2;
    }

    public void reportFinding(String string, String string2, long l2) {
        this.reportFinding(string, string2, l2, null, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2) {
        this.reportFinding(string, null, l2, map, true, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map) {
        this.reportFinding(string, string2, l2, map, true, null);
    }

    public void reportFinding(String string, Map<PropertyKey, String> map, long l2, boolean bl2) {
        this.reportFinding(string, null, l2, map, bl2, null);
    }

    public void reportFinding(String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, s s2) {
        Application application = this.applicationManager.current();
        this.reportFinding(application, string, string2, l2, map, bl2, s2);
    }

    public void reportFinding(Application application, String string, String string2, long l2, Map<PropertyKey, String> map, boolean bl2, s s2) {
        if (application == null) {
            logger.debug("Unable to send report, app == NULL");
            return;
        }
        if (this.disabledRulesFilter.a(application).test(string)) {
            logger.debug("Suppressed finding in {} for the disabled rule {}", (Object)application, (Object)string);
            return;
        }
        Trace trace = this.traceFactory.a();
        trace.setEvidence(string2);
        trace.setRuleId(string);
        ContrastPolicy contrastPolicy = this.policyManager.e();
        if (contrastPolicy == null) {
            return;
        }
        Rule rule = contrastPolicy.getRuleById(string);
        if (rule == null) {
            return;
        }
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        if (bl2) {
            finding.setRequest(this.httpManager.getCurrentRequest());
        }
        finding.setProperties(map);
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)l2);
        TraceEvent traceEvent = new TraceEvent(trace);
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        if (assessmentContext != null) {
            assessmentContext.onFindingOccurred(string, l2);
        }
        finding.setListener(s2);
        this.legacyReportingService.a(finding);
    }
}

