/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.socketfactory;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.model.f;
import com.contrastsecurity.agent.plugins.security.n;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.x;
import com.contrastsecurity.agent.r;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.v.l;
import com.contrastsecurity.agent.v.m;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

@Singleton
@DontObfuscate
public final class ContrastSocketFactoryDispatcherImpl
implements ContrastSocketFactoryDispatcher {
    private final ApplicationManager applicationManager;
    private final com.contrastsecurity.agent.config.e config;
    private final AssessmentManager assessmentManager;
    private final HttpManager httpManager;
    private final e traceFactory;
    private final c codeEventFactory;
    private final Finding.d findingFactory;
    private final m stackCaptureFactory;
    private final h legacyReportingService;
    private final a methodDescriptionCache;
    private final x.h triggerHasher;
    private final d policyManager;
    private final n disabledRulesFilter;
    private static final boolean IS_SUSCEPTIBLE = ContrastSocketFactoryDispatcherImpl.isSusceptibleJavaVersion();
    private static final String MASQUERADE_NAME = "insecure-socket-factory";
    public static final String RULE_NAME = "insecure-socket-factory";
    private static final String DEFAULT_SOCKET_FACTORY_PROPERTY = "ssl.SocketFactory.provider";
    private static final Logger logger = LoggerFactory.getLogger(ContrastSocketFactoryDispatcherImpl.class);

    @Inject
    public ContrastSocketFactoryDispatcherImpl(ApplicationManager applicationManager, AssessmentManager assessmentManager, com.contrastsecurity.agent.config.e e2, HttpManager httpManager, e e3, c c2, Finding.d d2, m m2, h h2, a a2, x x2, d d3, n n2) {
        this.applicationManager = applicationManager;
        this.assessmentManager = assessmentManager;
        this.config = e2;
        this.httpManager = httpManager;
        this.traceFactory = e3;
        this.codeEventFactory = c2;
        this.findingFactory = d2;
        this.stackCaptureFactory = m2;
        this.legacyReportingService = h2;
        this.methodDescriptionCache = a2;
        this.triggerHasher = x2.d();
        this.policyManager = d3;
        this.disabledRulesFilter = n2;
    }

    @ScopedSensor
    public void trackSocketCreate(Object object, Object object2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                if (this.isDefaultSocketFactory() && IS_SUSCEPTIBLE) {
                    this.reportInsecureSocket((SSLSocketFactory)object, (Socket)object2, this.findingFactory);
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem checking insecure-socket-factory trigger during socket creation", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private boolean isDefaultSocketFactory() {
        return r.b(DEFAULT_SOCKET_FACTORY_PROPERTY) == null;
    }

    private void reportInsecureSocket(SSLSocketFactory sSLSocketFactory, Socket socket, Finding.d d2) {
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        if (this.disabledRulesFilter.a(application).test("insecure-socket-factory")) {
            logger.debug("Suppressed socket connection report in {} for the disabled rule {}", (Object)application, (Object)"insecure-socket-factory");
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.e();
        Rule rule = contrastPolicy.getRuleById("insecure-socket-factory");
        if (rule == null || !rule.isEnabled()) {
            return;
        }
        l l2 = this.stackCaptureFactory.a(m.a.d);
        StackTraceElement stackTraceElement = l2.a().get(0);
        MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), "()Ljava/net/Socket;", 0);
        TriggerEvent triggerEvent = ((com.contrastsecurity.agent.plugins.security.model.n)((com.contrastsecurity.agent.plugins.security.model.n)((com.contrastsecurity.agent.plugins.security.model.n)((com.contrastsecurity.agent.plugins.security.model.n)((com.contrastsecurity.agent.plugins.security.model.n)this.codeEventFactory.b().a(methodDescription)).a(rule).e("O")).a(sSLSocketFactory)).b(socket)).a(l2)).g();
        try {
            Trace trace = this.traceFactory.a();
            trace.addEvent(triggerEvent);
            trace.setRuleId("insecure-socket-factory");
            long l3 = this.triggerHasher.a("insecure-socket-factory", this.httpManager.getCurrentRequest());
            Finding finding = d2.a(application, "insecure-socket-factory", trace, l3);
            HttpRequest httpRequest = this.httpManager.getCurrentRequest();
            if (httpRequest != null) {
                finding.setRequest(httpRequest);
            }
            logger.info("Added finding for rule ID: insecure-socket-factory");
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null) {
                assessmentContext.onFindingOccurred("insecure-socket-factory", finding.getHash());
            }
            if (assessmentContext != null) {
                assessmentContext.setLastTriggerEvent(triggerEvent);
            }
            this.legacyReportingService.a(finding);
        }
        catch (f f2) {
            logger.info("Duplicate event detected for rule ID: insecure-socket-factory");
        }
    }

    private static boolean isSusceptibleJavaVersion() {
        String string = JVMUtils.getJavaVersion();
        return string == null || string.contains("1.6");
    }
}

