/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.queues.lockfree;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.queues.lockfree.ConsumerWaitStrategies;
import com.contrastsecurity.agent.queues.lockfree.ContrastJ8MpscBlockingQueue;
import com.contrastsecurity.agent.queues.lockfree.ContrastJ9MpscBlockingQueue;
import com.contrastsecurity.agent.queues.lockfree.VarHandleUtil;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.util.NumberUtil;
import com.contrastsecurity.thirdparty.org.jctools.queues.MessagePassingQueue;
import java.util.concurrent.BlockingQueue;

@DontObfuscate
public final class LockFreeBlockingQueueFactory {
    private final boolean useVarHandles;
    @t
    public static final int MINIMUM_CAPACITY_TO_USE_OFFER_THRESHOLD = 1024;

    @t
    LockFreeBlockingQueueFactory(boolean bl2) {
        this.useVarHandles = bl2;
    }

    public static LockFreeBlockingQueueFactory factory() {
        return new LockFreeBlockingQueueFactory(VarHandleUtil.SUPPORTS_VAR_HANDLES);
    }

    public <E> BlockingQueue<E> create(int n2) {
        return this.create(n2, 0, ConsumerWaitStrategies.waitParkedDefault());
    }

    public <E> BlockingQueue<E> create(int n2, int n3, MessagePassingQueue.WaitStrategy waitStrategy) {
        if (!NumberUtil.isPowerOf2(n2)) {
            throw new IllegalArgumentException("Queue capacity must be a power of 2");
        }
        if (n3 < 0 || n3 > n2) {
            throw new IllegalArgumentException("offerIfBelowThreshold must be between 0 and capacity");
        }
        int n4 = n2 < 1024 ? 0 : n3;
        return this.useVarHandles ? new ContrastJ9MpscBlockingQueue(n2, n4, waitStrategy) : new ContrastJ8MpscBlockingQueue(n2, n4, waitStrategy);
    }

    @t
    boolean useVarHandles() {
        return this.useVarHandles;
    }
}

