/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.reflection;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.reflection.ReflectCache;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Optional;

@DontObfuscate
public final class Reflect {
    private Object object;
    private Class<?> type;
    private a error = a.a;
    private Throwable thrown;
    private Logger callerLogger;

    public static Reflect reflect(Object object, Logger logger) {
        return Reflect.reflect(object, null, logger);
    }

    public static Reflect reflect(Object object, Class<?> clazz, Logger logger) {
        Reflect reflect = new Reflect();
        reflect.reset(object, clazz);
        reflect.callerLogger = Objects.requireNonNull(logger);
        return reflect;
    }

    public static Reflect reflect(Class<?> clazz, Logger logger) {
        return Reflect.reflect(null, clazz, logger);
    }

    public static Reflect reflect(Logger logger) {
        return Reflect.reflect(null, null, logger);
    }

    private Reflect() {
    }

    public Reflect reset(Object object) {
        return this.reset(object, null);
    }

    public Reflect reset(Class<?> clazz) {
        return this.reset(null, clazz);
    }

    public Reflect reset(Object object, Class<?> clazz) {
        Preconditions.check(!(object instanceof Reflect) && !(object instanceof Logger), "Object must not be a Reflect or Contrast Logger.");
        this.error = a.a;
        this.thrown = null;
        if (clazz == null) {
            this.continueReflecting(object);
        } else {
            this.object = object;
            this.type = clazz;
            if (object != null && !clazz.isInstance(object)) {
                throw new IllegalArgumentException(object.getClass().getTypeName() + " is not an instance of " + clazz.getTypeName());
            }
        }
        return this;
    }

    private Reflect errored(a a2) {
        Preconditions.check(a2 != null && a.a != a2, "Expected an error.");
        this.object = null;
        this.type = null;
        this.error = a2;
        return this;
    }

    private Reflect continueReflecting(Object object) {
        this.object = object;
        this.type = object != null ? object.getClass() : null;
        return this;
    }

    private static boolean isError(a a2) {
        return Objects.requireNonNull(a2) != a.a;
    }

    private boolean hasError() {
        return Reflect.isError(this.error);
    }

    private boolean stopReflecting() {
        return this.hasError() || this.type == null;
    }

    public Reflect invoke(String string) {
        return this.invoke(string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    public Reflect invoke(String string, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Class<?>[] classArray = this.getArgTypes(objectArray);
        return this.invoke(string, classArray, objectArray);
    }

    public Reflect invoke(String string, Class<?>[] classArray, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Method method = com.contrastsecurity.agent.reflection.a.a(this.type, string, false, classArray, objectArray);
        return this.invokeMethod(method, string, classArray, objectArray);
    }

    public Reflect invokeCached(String string) {
        return this.invokeCached(string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    public Reflect invokeCached(String string, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Class<?>[] classArray = this.getArgTypes(objectArray);
        return this.invokeCached(string, classArray, objectArray);
    }

    public Reflect invokeCached(String string, Class<?>[] classArray, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Method method = ReflectCache.getInstance().getMethod(this.type, string, classArray, false, objectArray);
        return this.invokeMethod(method, string, classArray, objectArray);
    }

    public Reflect invokePublic(String string) {
        return this.invokePublic(string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    public Reflect invokePublic(String string, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Class<?>[] classArray = this.getArgTypes(objectArray);
        return this.invokePublic(string, classArray, objectArray);
    }

    public Reflect invokePublic(String string, Class<?>[] classArray, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Method method = com.contrastsecurity.agent.reflection.a.a(this.type, string, true, classArray, objectArray);
        return this.invokeMethod(method, string, classArray, objectArray);
    }

    public Reflect invokePublicCached(String string) {
        return this.invokePublicCached(string, Empty.CLASS_ARRAY, Empty.OBJ_ARRAY);
    }

    public Reflect invokePublicCached(String string, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Class<?>[] classArray = this.getArgTypes(objectArray);
        return this.invokePublicCached(string, classArray, objectArray);
    }

    public Reflect invokePublicCached(String string, Class<?>[] classArray, Object ... objectArray) {
        if (this.stopReflecting()) {
            return this;
        }
        Method method = ReflectCache.getInstance().getMethod(this.type, string, classArray, true, objectArray);
        return this.invokeMethod(method, string, classArray, objectArray);
    }

    private Class<?>[] getArgTypes(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return Empty.CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2].getClass();
        }
        return classArray;
    }

    private Reflect invokeMethod(Method method, String string, Class<?>[] classArray, Object[] objectArray) {
        Object object;
        if (method == null) {
            this.callerLogger.debug("Method {} with arg types [{}] not found on {}", string, classArray, this.type);
            return this.errored(a.c);
        }
        boolean bl2 = Modifier.isStatic(method.getModifiers());
        if (!bl2 && this.object == null) {
            this.callerLogger.debug("Static method {} with arg types [{}] not found on {}", string, classArray, this.type);
            return this.errored(a.c);
        }
        try {
            object = bl2 ? method.invoke(null, objectArray) : method.invoke(this.object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Method \"" + method.getName() + "\" on class type \"" + this.type.getTypeName() + "\" was inaccessible.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.throwIfCritical(invocationTargetException);
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            this.callerLogger.debug("Error calling method {} with args [{}] on {}", string, objectArray, this.object, invocationTargetException2);
            this.errored(a.b);
            this.thrown = Throwables.unwrap(invocationTargetException2, 5);
            return this;
        }
        return this.continueReflecting(object);
    }

    public Reflect field(String string) {
        return this.getField(string, false, false);
    }

    public Reflect publicField(String string) {
        return this.getField(string, true, false);
    }

    public Reflect fieldCached(String string) {
        return this.getField(string, false, true);
    }

    public Reflect publicFieldCached(String string) {
        return this.getField(string, true, true);
    }

    private Field lookupField(String string, boolean bl2) {
        return bl2 ? com.contrastsecurity.agent.reflection.a.c(this.type, string) : com.contrastsecurity.agent.reflection.a.a(this.type, string);
    }

    private Field lookupFieldOrError(String string, boolean bl2, boolean bl3) {
        Field field;
        if (this.stopReflecting()) {
            return null;
        }
        Field field2 = field = bl3 ? ReflectCache.getInstance().getField(this.type, string, bl2) : this.lookupField(string, bl2);
        if (field == null) {
            this.callerLogger.debug("Field {} not found on {}", (Object)string, (Object)this.type);
            this.errored(a.d);
            return null;
        }
        boolean bl4 = Modifier.isStatic(field.getModifiers());
        if (!bl4 && this.object == null) {
            this.callerLogger.debug("Static field {} not found on {}", (Object)string, (Object)this.type);
            this.errored(a.d);
            return null;
        }
        return field;
    }

    private Reflect getField(String string, boolean bl2, boolean bl3) {
        Object object;
        Field field = this.lookupFieldOrError(string, bl2, bl3);
        if (field == null) {
            return this;
        }
        try {
            object = Modifier.isStatic(field.getModifiers()) ? field.get(null) : field.get(this.object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Field \"" + string + "\" on class type \"" + this.type.getTypeName() + "\" was inaccessible.", illegalAccessException);
        }
        return this.continueReflecting(object);
    }

    public Reflect setPublicField(String string, Object object) {
        return this.setField(string, object, true, false);
    }

    public Reflect setField(String string, Object object) {
        return this.setField(string, object, false, false);
    }

    private Reflect setField(String string, Object object, boolean bl2, boolean bl3) {
        Field field = this.lookupFieldOrError(string, bl2, bl3);
        if (field == null) {
            return this;
        }
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                field.set(null, object);
            } else {
                field.set(this.object, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Field \"" + string + "\" on class type \"" + this.type.getTypeName() + "\" was inaccessible.", illegalAccessException);
        }
        return this;
    }

    public Reflect setPublicFieldCached(String string, Object object) {
        return this.setField(string, object, true, true);
    }

    public Reflect setFieldCached(String string, Object object) {
        return this.setField(string, object, false, true);
    }

    public void handleError(b b2) {
        Objects.requireNonNull(b2);
        if (this.hasError()) {
            b2.handleError(this.error, this.thrown, this.callerLogger);
        }
    }

    public <T> T asNullable(Class<T> clazz, b b2) {
        return this._asNullable(clazz, Objects.requireNonNull(b2));
    }

    public <T> T asNullable(Class<T> clazz) {
        return this._asNullable(clazz, null);
    }

    public <T> Optional<T> asOptional(Class<T> clazz) {
        return Optional.ofNullable(this._asNullable(clazz, null));
    }

    public <T> Optional<T> asOptional(Class<T> clazz, b b2) {
        return Optional.ofNullable(this._asNullable(clazz, Objects.requireNonNull(b2)));
    }

    private <T> T _asNullable(Class<T> clazz, b b2) {
        if (Objects.requireNonNull(clazz).isPrimitive()) {
            throw new IllegalArgumentException("Primitive types cannot be used for reflection. Reflection always boxes types.");
        }
        if (b2 != null && this.hasError()) {
            b2.handleError(this.error, this.thrown, this.callerLogger);
        }
        if (this.object == null) {
            return null;
        }
        if (!clazz.isInstance(this.object)) {
            this.error = a.e;
        }
        if (a.a != this.error) {
            this.callerLogger.debug("Cannot cast {} to type {}", this.object, (Object)clazz);
            this.errored(this.error);
            if (b2 != null && this.hasError()) {
                b2.handleError(this.error, this.thrown, this.callerLogger);
            }
            return null;
        }
        return clazz.cast(this.object);
    }

    public <T> T as(Class<T> clazz, T t2, b b2) {
        return this._as(clazz, t2, Objects.requireNonNull(b2));
    }

    public <T> T as(Class<T> clazz, T t2) {
        return this._as(clazz, t2, null);
    }

    private <T> T _as(Class<T> clazz, T t2, b b2) {
        Objects.requireNonNull(t2);
        T t3 = this._asNullable(clazz, b2);
        return t3 != null ? t3 : t2;
    }

    public boolean asBoolean(boolean bl2) {
        return this.as(Boolean.class, bl2);
    }

    public int asInt(int n2) {
        return this.as(Integer.class, n2);
    }

    public long asLong(long l2) {
        return this.as(Long.class, l2);
    }

    public String asString() {
        return this.asString("");
    }

    public String asString(String string) {
        return this.as(String.class, string);
    }

    public String asNullableString() {
        return this.asNullable(String.class);
    }

    public <T> c<T> result(Class<T> clazz) {
        T t2 = this.asNullable(clazz);
        return this.hasError() ? c.b(this.error, this.thrown) : c.c(t2);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(false, true);
        public static final /* enum */ a b = new a(false, false);
        public static final /* enum */ a c = new a(true, true);
        public static final /* enum */ a d = new a(true, true);
        public static final /* enum */ a e = new a(true, true);
        public final boolean f;
        @t
        final c<?> g;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private a(boolean bl2, boolean bl3) {
            this.f = bl2;
            this.g = bl3 ? com.contrastsecurity.agent.reflection.Reflect$c.b(this, null) : null;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d, e};
        }

        static {
            h = com.contrastsecurity.agent.reflection.Reflect$a.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public void handleError(a var1, Throwable var2, Logger var3);
    }

    public static final class c<T> {
        private final T a;
        private final a b;
        private final Throwable c;

        private c(T t2, a a2, Throwable throwable) {
            Preconditions.check(t2 == null || a2 == com.contrastsecurity.agent.reflection.Reflect$a.a && throwable == null, "Result must contain either a result value or an error but not both.");
            this.a = t2;
            this.b = Objects.requireNonNull(a2);
            this.c = throwable;
        }

        private static <T> c<T> c(T t2) {
            if (t2 == null) {
                return com.contrastsecurity.agent.reflection.Reflect$a.a.g;
            }
            return new c<T>(t2, com.contrastsecurity.agent.reflection.Reflect$a.a, null);
        }

        private static <T> c<T> b(a a2, Throwable throwable) {
            Preconditions.check(a2 != null && a2 != com.contrastsecurity.agent.reflection.Reflect$a.a, "Error results must have an error.");
            if (throwable == null && a2.g != null) {
                return a2.g;
            }
            return new c<Object>(null, a2, throwable);
        }

        public a a() {
            return this.b;
        }

        public T b() {
            return this.a;
        }

        public T a(T t2) {
            Objects.requireNonNull(t2);
            if (this.a == null) {
                return t2;
            }
            return this.a;
        }

        public boolean c() {
            return this.a != null;
        }

        public boolean d() {
            return Reflect.isError(this.b);
        }

        public Throwable e() {
            return this.c;
        }

        public static <T> c<T> f() {
            return com.contrastsecurity.agent.reflection.Reflect$a.a.g;
        }
    }
}

