/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.reloadable;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.reloadable.ChannelServer;
import com.contrastsecurity.agent.reloadable.ChannelSubscriber;
import com.contrastsecurity.agent.reloadable.ReloadableBeanManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public class AgentChannelHub {
    private static AgentChannelHub INSTANCE;
    private ConcurrentHashMap<String, Set<ChannelSubscriber>> channelSubscriberMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ChannelServer> channelServerMap = new ConcurrentHashMap();
    private static final String RELOAD_BEANS = "reloadBeans";

    public static AgentChannelHub getOrNull(e e2) {
        return e2.c(ConfigProperty.ENABLE_AGENT_CHANNEL_HUB) ? AgentChannelHub.get() : null;
    }

    public static AgentChannelHub get() {
        if (INSTANCE == null) {
            INSTANCE = new AgentChannelHub();
        }
        return INSTANCE;
    }

    AgentChannelHub() {
        this.listenForMessage(RELOAD_BEANS, object -> {
            ReloadableBeanManager.get().reload();
            return null;
        });
    }

    public void subscribe(e e2, String string2, ChannelSubscriber channelSubscriber) {
        if (e2.c(ConfigProperty.ENABLE_RELOADABLE_BEANS)) {
            if (channelSubscriber == null) {
                throw new IllegalArgumentException("subscriber can't be null");
            }
            this.channelSubscriberMap.computeIfAbsent(string2, string -> new HashSet()).add(channelSubscriber);
        }
    }

    public void broadcast(String string, Map<String, Object> map) {
        Set<ChannelSubscriber> set = this.getChannelSubscribers(string);
        if (set != null && !set.isEmpty()) {
            for (ChannelSubscriber channelSubscriber : set) {
                channelSubscriber.onMessageReceived(map);
            }
        }
    }

    private Set<ChannelSubscriber> getChannelSubscribers(String string) {
        return this.channelSubscriberMap.get(string);
    }

    public boolean hasSubscribers(String string) {
        Set<ChannelSubscriber> set = this.getChannelSubscribers(string);
        return set != null && !set.isEmpty();
    }

    public Object sendMessage(String string, Object object) throws a {
        ChannelServer channelServer = this.channelServerMap.get(string);
        if (channelServer == null) {
            throw new a(string);
        }
        return channelServer.handleMessage(object);
    }

    public void listenForMessage(String string, ChannelServer channelServer) {
        this.channelServerMap.put(string, channelServer);
    }

    public static class a
    extends Exception {
        public a(String string) {
            super(string);
        }
    }
}

