/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.e.g;
import com.contrastsecurity.agent.h.a;
import com.contrastsecurity.agent.messages.app.ApplicationResponse;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.l;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.m;
import com.contrastsecurity.agent.services.ngreporting.p;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;

@Singleton
public class c
extends p {
    private static final String b = "Contrast Application Updater";
    private final ApplicationSettingsUpdateEventBus c;
    private final e d;
    private final b e;
    private final h f;
    private final a g;
    private final long h;
    private final com.contrastsecurity.agent.plugins.frameworks.p i;
    private final com.contrastsecurity.agent.o.e j;
    private static final Logger k = LoggerFactory.getLogger(c.class);

    @Inject
    c(a a2, ApplicationManager applicationManager, com.contrastsecurity.agent.plugins.frameworks.p p2, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, e e2, b b2, h h2, ScopeProvider scopeProvider, o o2, com.contrastsecurity.agent.o.e e3) {
        super(b, e2.e(ConfigProperty.APP_UPDATE_PERIOD), applicationManager, scopeProvider, o2);
        this.i = p2;
        this.c = applicationSettingsUpdateEventBus;
        this.g = a2;
        this.d = e2;
        this.e = b2;
        this.h = e2.e(ConfigProperty.APP_UPDATE_STALE_THRESHOLD);
        this.f = h2;
        this.j = e3;
    }

    @Override
    void a() {
        Collection<Application> collection = this.a.getApplications();
        for (Application application : collection) {
            if (application.isUnwanted()) continue;
            try {
                this.b(application);
                this.a.inventory(this.i, application);
                if (this.a(application)) {
                    if (k.isDebugEnabled()) {
                        k.debug("Sending app update for {} [dirty={}]", (Object)application, (Object)application.isDirty());
                    }
                    this.c(application);
                    continue;
                }
                k.debug("Not sending an app update for {} [dirty={},lastReport={},lastChange={}]", application, application.isDirty(), application.getLastReportedTime(), application.getLastChangeOccurred());
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                this.g.a(k, "Problem with app updater process", throwable2);
            }
        }
    }

    boolean a(Application application) {
        if (!this.d.c(ConfigProperty.INVENTORY_ENABLED)) {
            k.debug("Inventory disabled by config... skipping");
            return false;
        }
        return application.getState().c() && !application.isUnwanted() && (application.isDirty() || this.d(application));
    }

    private boolean d(Application application) {
        long l2 = application.getLastReportedTime();
        long l3 = this.e.now();
        return l3 - l2 > this.h;
    }

    void b(Application application) {
        if (!application.getState().f()) {
            return;
        }
        k.debug("Sending appcreate for: {}", (Object)application);
        m m2 = new m(application, this.d);
        g<String> g2 = this.f.b(m2);
        int n2 = g2 != null ? g2.a() : -1;
        switch (n2) {
            case 200: {
                k.info("Successfully created app on TeamServer: {}", (Object)application);
                application.created();
                ApplicationResponse applicationResponse = ObjectShare.GSON.fromJson(g2.b(), ApplicationResponse.class);
                if (applicationResponse == null) {
                    k.error("ApplicationResponse is null, unable to update settings");
                } else {
                    ApplicationSettingsDTM applicationSettingsDTM = applicationResponse.getSettings();
                    if (applicationSettingsDTM != null) {
                        this.c.publish(application, applicationSettingsDTM, this.e.now());
                    }
                }
                this.j.a(application);
                break;
            }
            case 409: {
                l.a(n2, g2.b(), application, "appcreate");
                break;
            }
            case -1: {
                k.info("Can't send appcreate to TeamServer - nobody's answering. Marking as created.");
                this.j.a(application);
                application.created();
                break;
            }
            default: {
                k.error("Problem creating app on TeamServer: {}, status={}", (Object)application, (Object)n2);
            }
        }
    }

    void c(Application application) {
        k.debug("Generating app report for {}", (Object)application);
        com.contrastsecurity.agent.plugins.apps.h h2 = new com.contrastsecurity.agent.plugins.apps.h(application);
        this.f.a(h2);
        this.a.onApplicationUpdate(application);
        application.markClean();
        application.setLastReportedTime(this.e.now());
        k.debug("Queued app update report for {}", (Object)application);
        Collection<LibraryFacts> collection = application.getAllLibraryFacts();
        for (LibraryFacts libraryFacts : collection) {
            if (libraryFacts.getUsedClasses().isEmpty()) continue;
            application.getActivity().addUpdatedLibrary(libraryFacts);
        }
    }
}

