/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry.metrics;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.telemetry.h;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.Gauge;
import com.contrastsecurity.agent.telemetry.metrics.MetricBuilder;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.f;
import com.contrastsecurity.agent.telemetry.metrics.i;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

@DontObfuscate
public interface TelemetryMetrics {
    public void start(ThreadFactory var1);

    public void stop();

    public boolean isEnabled();

    public Counter.Builder newCounter(String var1, TelemetryCategory var2);

    public DistributionSummary.Builder newDistributionSummary(String var1, TelemetryCategory var2);

    public <T> Gauge.a<T> newGauge(String var1, TelemetryCategory var2);

    public <T extends f> d.a<T> newGrouped(MetricBuilder<T> var1);

    public i.a newTimer(String var1, TelemetryCategory var2);

    public boolean publishMetrics();

    public Counter register(Counter.Builder var1);

    public DistributionSummary register(DistributionSummary.Builder var1);

    public <T> Gauge register(Gauge.a<T> var1);

    public i register(i.a var1);

    public List<? extends f> getMetrics();

    public void scheduleStartupReporting(ScheduledExecutorService var1, long var2, h var4);

    public Runnable shutdownRunnable(int var1, long var2);

    @DontObfuscate
    public static enum TelemetryCategory {
        STARTUP("metrics/java/startup"),
        ENVIRONMENT_PARAMETERS("metrics/java/envParameters"),
        VERSIONS("metrics/java/versions"),
        GENERAL("metrics/java/general"),
        PERFORMANCE_PROTECT("metrics/java/perf-protect"),
        PERFORMANCE_PROTECT_SEARCHERS("metrics/java/perf-protect-searchers"),
        PERFORMANCE_PROTECT_RULES("metrics/java/perf-protect-rules"),
        PERFORMANCE_PROTECT_SINK("metrics/java/perf-protect-sink"),
        PERFORMANCE_IMPROVEMENT("metrics/java/perf-improvement"),
        PROTECT("metrics/java/protect"),
        ASSESS("metrics/java/assess"),
        ASSESS_SINK("metrics/java/assess-sink"),
        OBSERVE("metrics/java/observe"),
        REPORTING("metrics/java/reporting"),
        TELEMETRY("metrics/java/telemetry"),
        TESTING("metrics/java/test"),
        CANONICALIZER("metrics/java/canonicalizer");

        private final String path;

        private TelemetryCategory(String string2) {
            this.path = string2;
        }

        public String getPath() {
            return this.path;
        }

        public String buildPath(String string) {
            return this.path + "/" + string;
        }

        public static TelemetryCategory from(String string) {
            for (TelemetryCategory telemetryCategory : TelemetryCategory.values()) {
                if (!telemetryCategory.path.equalsIgnoreCase(string)) continue;
                return telemetryCategory;
            }
            throw new IllegalArgumentException("Invalid input to build TelemetryCategory, input: " + string);
        }
    }
}

