/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@DontObfuscate
public class ContrastJsonWriter
extends JsonWriter {
    private Field stackField;
    private Field stackSizeField;
    private Method pushMethod;
    private static final String RESET_KEY = "ContrastJsonWriter.reset";
    private static final String RESET_ELIGIBLE_KEY = "ContrastJsonWriter.resetEligible";
    private static final Logger logger = LoggerFactory.getLogger(ContrastJsonWriter.class);

    public ContrastJsonWriter(Writer writer) {
        super(writer);
        Class<?> clazz = this.getClass().getSuperclass();
        this.reflectStack(clazz);
        this.reflectStackSize(clazz);
        this.reflectPush(clazz);
    }

    public boolean reset() {
        boolean bl2;
        block3: {
            bl2 = false;
            if (this.canReset()) {
                try {
                    this.stackField.set(this, new int[32]);
                    this.stackSizeField.setInt(this, 0);
                    this.pushMethod.invoke((Object)this, 6);
                    bl2 = true;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                    if (!logger.isDebugEnabled()) break block3;
                    com.contrastsecurity.agent.logging.a.a(RESET_KEY, logger, "Unable to reset JsonWriter {(stackfield:" + this.stackField + "),(stackSizeField:" + this.stackSizeField + "),(pushMethod:" + this.pushMethod + ")}.", (Throwable)exception2);
                }
            }
        }
        return bl2;
    }

    private void reflectStack(Class<?> clazz) {
        try {
            this.stackField = a.d(clazz, "stack");
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Unable to reflect JsonWriter stack field.", exception2);
        }
    }

    private void reflectStackSize(Class<?> clazz) {
        try {
            this.stackSizeField = a.d(clazz, "stackSize");
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Unable to reflect JsonWriter stackSize field.", exception2);
        }
    }

    private void reflectPush(Class<?> clazz) {
        try {
            this.pushMethod = a.d(clazz, "push", Integer.TYPE);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Unable to reflect JsonWriter push method.", exception2);
        }
    }

    private boolean canReset() {
        if (this.stackField != null && this.stackSizeField != null && this.pushMethod != null) {
            return true;
        }
        com.contrastsecurity.agent.logging.a.a(RESET_ELIGIBLE_KEY, logger, "Cannot reset JsonWriter because not all fields are available {(stackfield:" + this.stackField + "),(stackSizeField:" + this.stackSizeField + "),(pushMethod:" + this.pushMethod + ")}. Will continue without reusing writer.");
        return false;
    }
}

