/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.gson.internal.bind;

import com.contrastsecurity.thirdparty.com.google.gson.Gson;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.com.google.gson.ToNumberPolicy;
import com.contrastsecurity.thirdparty.com.google.gson.ToNumberStrategy;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapter;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapterFactory;
import com.contrastsecurity.thirdparty.com.google.gson.reflect.TypeToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        NumberTypeAdapter numberTypeAdapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                return typeToken.getRawType() == Number.class ? NumberTypeAdapter.this : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader jsonReader) throws IOException {
        JsonToken jsonToken = jsonReader.peek();
        switch (jsonToken) {
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(jsonReader);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + jsonReader.getPath());
    }

    @Override
    public void write(JsonWriter jsonWriter, Number number) throws IOException {
        jsonWriter.value(number);
    }
}

