/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import java.nio.ByteBuffer;

abstract class AllocatedBuffer {
    AllocatedBuffer() {
    }

    public abstract boolean hasNioBuffer();

    public abstract boolean hasArray();

    public abstract ByteBuffer nioBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract int position();

    public abstract AllocatedBuffer position(int var1);

    public abstract int limit();

    public abstract int remaining();

    public static AllocatedBuffer wrap(byte[] byArray) {
        return AllocatedBuffer.wrapNoCheck(byArray, 0, byArray.length);
    }

    public static AllocatedBuffer wrap(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException(String.format("bytes.length=%d, offset=%d, length=%d", byArray.length, n2, n3));
        }
        return AllocatedBuffer.wrapNoCheck(byArray, n2, n3);
    }

    public static AllocatedBuffer wrap(final ByteBuffer byteBuffer) {
        Internal.checkNotNull(byteBuffer, "buffer");
        return new AllocatedBuffer(){

            @Override
            public boolean hasNioBuffer() {
                return true;
            }

            @Override
            public ByteBuffer nioBuffer() {
                return byteBuffer;
            }

            @Override
            public boolean hasArray() {
                return byteBuffer.hasArray();
            }

            @Override
            public byte[] array() {
                return byteBuffer.array();
            }

            @Override
            public int arrayOffset() {
                return byteBuffer.arrayOffset();
            }

            @Override
            public int position() {
                return byteBuffer.position();
            }

            @Override
            public AllocatedBuffer position(int n2) {
                byteBuffer.position(n2);
                return this;
            }

            @Override
            public int limit() {
                return byteBuffer.limit();
            }

            @Override
            public int remaining() {
                return byteBuffer.remaining();
            }
        };
    }

    private static AllocatedBuffer wrapNoCheck(final byte[] byArray, final int n2, final int n3) {
        return new AllocatedBuffer(){
            private int position;

            @Override
            public boolean hasNioBuffer() {
                return false;
            }

            @Override
            public ByteBuffer nioBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasArray() {
                return true;
            }

            @Override
            public byte[] array() {
                return byArray;
            }

            @Override
            public int arrayOffset() {
                return n2;
            }

            @Override
            public int position() {
                return this.position;
            }

            @Override
            public AllocatedBuffer position(int n22) {
                if (n22 < 0 || n22 > n3) {
                    throw new IllegalArgumentException("Invalid position: " + n22);
                }
                this.position = n22;
                return this;
            }

            @Override
            public int limit() {
                return n3;
            }

            @Override
            public int remaining() {
                return n3 - this.position;
            }
        };
    }
}

