/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.Android;
import com.contrastsecurity.thirdparty.com.google.protobuf.ByteOutput;
import com.contrastsecurity.thirdparty.com.google.protobuf.CanIgnoreReturnValue;
import com.contrastsecurity.thirdparty.com.google.protobuf.CheckReturnValue;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedOutputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.NioByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.RopeByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.TextFormatEscaper;
import com.contrastsecurity.thirdparty.com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

@CheckReturnValue
public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier() : new ArraysByteArrayCopier();
    private int hash = 0;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new Comparator<ByteString>(){

        @Override
        public int compare(ByteString byteString, ByteString byteString2) {
            ByteIterator byteIterator = byteString.iterator();
            ByteIterator byteIterator2 = byteString2.iterator();
            while (byteIterator.hasNext() && byteIterator2.hasNext()) {
                int n2 = Integer.compare(ByteString.toInt(byteIterator.nextByte()), ByteString.toInt(byteIterator2.nextByte()));
                if (n2 == 0) continue;
                return n2;
            }
            return Integer.compare(byteString.size(), byteString2.size());
        }
    };

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public ByteIterator iterator() {
        return new AbstractByteIterator(){
            private int position = 0;
            private final int limit = ByteString.this.size();

            @Override
            public boolean hasNext() {
                return this.position < this.limit;
            }

            @Override
            public byte nextByte() {
                int n2 = this.position;
                if (n2 >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = n2 + 1;
                return ByteString.this.internalByteAt(n2);
            }
        };
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private static int toInt(byte by2) {
        return by2 & 0xFF;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    }

    public final ByteString substring(int n2) {
        return this.substring(n2, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public final boolean startsWith(ByteString byteString) {
        return this.size() >= byteString.size() && this.substring(0, byteString.size()).equals(byteString);
    }

    public final boolean endsWith(ByteString byteString) {
        return this.size() >= byteString.size() && this.substring(this.size() - byteString.size()).equals(byteString);
    }

    public static ByteString copyFrom(byte[] byArray, int n2, int n3) {
        ByteString.checkRange(n2, n2 + n3, byArray.length);
        return new LiteralByteString(byteArrayCopier.copyFrom(byArray, n2, n3));
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    static ByteString wrap(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n2 = byteBuffer.arrayOffset();
            return ByteString.wrap(byteBuffer.array(), n2 + byteBuffer.position(), byteBuffer.remaining());
        }
        return new NioByteString(byteBuffer);
    }

    static ByteString wrap(byte[] byArray) {
        return new LiteralByteString(byArray);
    }

    static ByteString wrap(byte[] byArray, int n2, int n3) {
        return new BoundedByteString(byArray, n2, n3);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer, int n2) {
        ByteString.checkRange(0, n2, byteBuffer.remaining());
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return new LiteralByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String string, String string2) throws UnsupportedEncodingException {
        return new LiteralByteString(string.getBytes(string2));
    }

    public static ByteString copyFrom(String string, Charset charset) {
        return new LiteralByteString(string.getBytes(charset));
    }

    public static ByteString copyFromUtf8(String string) {
        return new LiteralByteString(string.getBytes(Internal.UTF_8));
    }

    public static ByteString readFrom(InputStream inputStream) throws IOException {
        return ByteString.readFrom(inputStream, 256, 8192);
    }

    public static ByteString readFrom(InputStream inputStream, int n2) throws IOException {
        return ByteString.readFrom(inputStream, n2, n2);
    }

    public static ByteString readFrom(InputStream inputStream, int n2, int n3) throws IOException {
        ByteString byteString;
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        int n4 = n2;
        while ((byteString = ByteString.readChunk(inputStream, n4)) != null) {
            arrayList.add(byteString);
            n4 = Math.min(n4 * 2, n3);
        }
        return ByteString.copyFrom(arrayList);
    }

    private static ByteString readChunk(InputStream inputStream, int n2) throws IOException {
        int n3;
        int n4;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 == 0) {
            return null;
        }
        return ByteString.copyFrom(byArray, 0, n3);
    }

    public final ByteString concat(ByteString byteString) {
        if (Integer.MAX_VALUE - this.size() < byteString.size()) {
            throw new IllegalArgumentException("ByteString would be too long: " + this.size() + "+" + byteString.size());
        }
        return RopeByteString.concatenate(this, byteString);
    }

    public static ByteString copyFrom(Iterable<ByteString> iterable) {
        int n2;
        if (!(iterable instanceof Collection)) {
            int n3 = 0;
            Iterator<ByteString> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n3;
            }
            n2 = n3;
        } else {
            n2 = ((Collection)iterable).size();
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return ByteString.balancedConcat(iterable.iterator(), n2);
    }

    private static ByteString balancedConcat(Iterator<ByteString> iterator, int n2) {
        ByteString byteString;
        if (n2 < 1) {
            throw new IllegalArgumentException(String.format("length (%s) must be >= 1", n2));
        }
        if (n2 == 1) {
            byteString = iterator.next();
        } else {
            int n3 = n2 >>> 1;
            ByteString byteString2 = ByteString.balancedConcat(iterator, n3);
            ByteString byteString3 = ByteString.balancedConcat(iterator, n2 - n3);
            byteString = byteString2.concat(byteString3);
        }
        return byteString;
    }

    public void copyTo(byte[] byArray, int n2) {
        this.copyTo(byArray, 0, n2, this.size());
    }

    @Deprecated
    public final void copyTo(byte[] byArray, int n2, int n3, int n4) {
        ByteString.checkRange(n2, n2 + n4, this.size());
        ByteString.checkRange(n3, n3 + n4, byArray.length);
        if (n4 > 0) {
            this.copyToInternal(byArray, n2, n3, n4);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public final byte[] toByteArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        this.copyToInternal(byArray, 0, 0, n2);
        return byArray;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    final void writeTo(OutputStream outputStream, int n2, int n3) throws IOException {
        ByteString.checkRange(n2, n2 + n3, this.size());
        if (n3 > 0) {
            this.writeToInternal(outputStream, n2, n3);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3) throws IOException;

    abstract void writeTo(ByteOutput var1) throws IOException;

    abstract void writeToReverse(ByteOutput var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    public final String toString(String string) throws UnsupportedEncodingException {
        try {
            return this.toString(Charset.forName(string));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
            unsupportedEncodingException.initCause(unsupportedCharsetException);
            throw unsupportedEncodingException;
        }
    }

    public final String toString(Charset charset) {
        return this.size() == 0 ? "" : this.toStringInternal(charset);
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            int n3 = this.size();
            n2 = this.partialHash(n3, 0, n3);
            if (n2 == 0) {
                n2 = 1;
            }
            this.hash = n2;
        }
        return n2;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int n2) {
        return new Output(n2);
    }

    public static Output newOutput() {
        return new Output(128);
    }

    static CodedBuilder newCodedBuilder(int n2) {
        return new CodedBuilder(n2);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    static void checkIndex(int n2, int n3) {
        if ((n2 | n3 - (n2 + 1)) < 0) {
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + n2);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + n2 + ", " + n3);
        }
    }

    @CanIgnoreReturnValue
    static int checkRange(int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if ((n2 | n3 | n5 | n4 - n3) < 0) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + n2 + " < 0");
            }
            if (n3 < n2) {
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + n2 + ", " + n3);
            }
            throw new IndexOutOfBoundsException("End index: " + n3 + " >= " + n4);
        }
        return n5;
    }

    public final String toString() {
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), this.truncateAndEscapeForDisplay());
    }

    private String truncateAndEscapeForDisplay() {
        int n2 = 50;
        return this.size() <= 50 ? TextFormatEscaper.escapeBytes(this) : TextFormatEscaper.escapeBytes(this.substring(0, 47)) + "...";
    }

    private static final class BoundedByteString
    extends LiteralByteString {
        private final int bytesOffset;
        private final int bytesLength;
        private static final long serialVersionUID = 1L;

        BoundedByteString(byte[] byArray, int n2, int n3) {
            super(byArray);
            BoundedByteString.checkRange(n2, n2 + n3, byArray.length);
            this.bytesOffset = n2;
            this.bytesLength = n3;
        }

        @Override
        public byte byteAt(int n2) {
            BoundedByteString.checkIndex(n2, this.size());
            return this.bytes[this.bytesOffset + n2];
        }

        @Override
        byte internalByteAt(int n2) {
            return this.bytes[this.bytesOffset + n2];
        }

        @Override
        public int size() {
            return this.bytesLength;
        }

        @Override
        protected int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        @Override
        protected void copyToInternal(byte[] byArray, int n2, int n3, int n4) {
            System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n2, byArray, n3, n4);
        }

        Object writeReplace() {
            return ByteString.wrap(this.toByteArray());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
        }
    }

    private static class LiteralByteString
    extends LeafByteString {
        private static final long serialVersionUID = 1L;
        protected final byte[] bytes;

        LiteralByteString(byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.bytes = byArray;
        }

        @Override
        public byte byteAt(int n2) {
            return this.bytes[n2];
        }

        @Override
        byte internalByteAt(int n2) {
            return this.bytes[n2];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public final ByteString substring(int n2, int n3) {
            int n4 = LiteralByteString.checkRange(n2, n3, this.size());
            if (n4 == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + n2, n4);
        }

        @Override
        protected void copyToInternal(byte[] byArray, int n2, int n3, int n4) {
            System.arraycopy(this.bytes, n2, byArray, n3, n4);
        }

        @Override
        public final void copyTo(ByteBuffer byteBuffer) {
            byteBuffer.put(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
        }

        @Override
        public final List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(this.asReadOnlyByteBuffer());
        }

        @Override
        public final void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.toByteArray());
        }

        @Override
        final void writeToInternal(OutputStream outputStream, int n2, int n3) throws IOException {
            outputStream.write(this.bytes, this.getOffsetIntoBytes() + n2, n3);
        }

        @Override
        final void writeTo(ByteOutput byteOutput) throws IOException {
            byteOutput.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        protected final String toStringInternal(Charset charset) {
            return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
        }

        @Override
        public final boolean isValidUtf8() {
            int n2 = this.getOffsetIntoBytes();
            return Utf8.isValidUtf8(this.bytes, n2, n2 + this.size());
        }

        @Override
        protected final int partialIsValidUtf8(int n2, int n3, int n4) {
            int n5 = this.getOffsetIntoBytes() + n3;
            return Utf8.partialIsValidUtf8(n2, this.bytes, n5, n5 + n4);
        }

        @Override
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ByteString)) {
                return false;
            }
            if (this.size() != ((ByteString)object).size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (object instanceof LiteralByteString) {
                LiteralByteString literalByteString = (LiteralByteString)object;
                int n2 = this.peekCachedHashCode();
                int n3 = literalByteString.peekCachedHashCode();
                if (n2 != 0 && n3 != 0 && n2 != n3) {
                    return false;
                }
                return this.equalsRange((LiteralByteString)object, 0, this.size());
            }
            return object.equals(this);
        }

        @Override
        final boolean equalsRange(ByteString byteString, int n2, int n3) {
            if (n3 > byteString.size()) {
                throw new IllegalArgumentException("Length too large: " + n3 + this.size());
            }
            if (n2 + n3 > byteString.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + n2 + ", " + n3 + ", " + byteString.size());
            }
            if (byteString instanceof LiteralByteString) {
                LiteralByteString literalByteString = (LiteralByteString)byteString;
                byte[] byArray = this.bytes;
                byte[] byArray2 = literalByteString.bytes;
                int n4 = this.getOffsetIntoBytes() + n3;
                int n5 = this.getOffsetIntoBytes();
                int n6 = literalByteString.getOffsetIntoBytes() + n2;
                while (n5 < n4) {
                    if (byArray[n5] != byArray2[n6]) {
                        return false;
                    }
                    ++n5;
                    ++n6;
                }
                return true;
            }
            return byteString.substring(n2, n2 + n3).equals(this.substring(0, n3));
        }

        @Override
        protected final int partialHash(int n2, int n3, int n4) {
            return Internal.partialHash(n2, this.bytes, this.getOffsetIntoBytes() + n3, n4);
        }

        @Override
        public final InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size(), true);
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int n2) {
            this.buffer = new byte[n2];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        Output(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = n2;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[n2];
        }

        @Override
        public synchronized void write(int n2) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)n2;
        }

        @Override
        public synchronized void write(byte[] byArray, int n2, int n3) {
            if (n3 <= this.buffer.length - this.bufferPos) {
                System.arraycopy(byArray, n2, this.buffer, this.bufferPos, n3);
                this.bufferPos += n3;
            } else {
                int n4 = this.buffer.length - this.bufferPos;
                System.arraycopy(byArray, n2, this.buffer, this.bufferPos, n4);
                this.flushFullBuffer(n3 -= n4);
                System.arraycopy(byArray, n2 += n4, this.buffer, 0, n3);
                this.bufferPos = n3;
            }
        }

        public synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        private byte[] copyArray(byte[] byArray, int n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
            return byArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outputStream) throws IOException {
            ByteString[] byteStringArray = this;
            synchronized (this) {
                ByteString[] byteStringArray2 = this.flushedBuffers.toArray(new ByteString[this.flushedBuffers.size()]);
                byte[] byArray = this.buffer;
                int n2 = this.bufferPos;
                // ** MonitorExit[var5_2] (shouldn't be in output)
                for (ByteString byteString : byteStringArray2) {
                    byteString.writeTo(outputStream);
                }
                outputStream.write(super.copyArray(byArray, n2));
                return;
            }
        }

        public synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        private void flushFullBuffer(int n2) {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int n3 = Math.max(this.initialCapacity, Math.max(n2, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[n3];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    byte[] byArray = this.copyArray(this.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString(byArray));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        LeafByteString() {
        }

        @Override
        protected final int getTreeDepth() {
            return 0;
        }

        @Override
        protected final boolean isBalanced() {
            return true;
        }

        @Override
        void writeToReverse(ByteOutput byteOutput) throws IOException {
            this.writeTo(byteOutput);
        }

        abstract boolean equalsRange(ByteString var1, int var2, int var3);
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final Byte next() {
            return this.nextByte();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] byArray, int n2, int n3) {
            return Arrays.copyOfRange(byArray, n2, n2 + n3);
        }
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        @Override
        public byte[] copyFrom(byte[] byArray, int n2, int n3) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            return byArray2;
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }
}

