/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedOutputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.LazyField;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.SmallSortedMap;
import com.contrastsecurity.thirdparty.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private static final int DEFAULT_FIELD_MAP_ARRAY_SIZE = 16;
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl2) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> smallSortedMap) {
        this.fields = smallSortedMap;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldSet)) {
            return false;
        }
        FieldSet fieldSet = (FieldSet)object;
        return this.fields.equals(fieldSet.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> fieldSet = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                smallSortedMap.makeImmutable();
            }
            return smallSortedMap;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> smallSortedMap, boolean bl2) {
        SmallSortedMap smallSortedMap2 = SmallSortedMap.newFieldMap(16);
        for (int i2 = 0; i2 < smallSortedMap.getNumArrayEntries(); ++i2) {
            FieldSet.cloneFieldEntry(smallSortedMap2, smallSortedMap.getArrayEntryAt(i2), bl2);
        }
        for (Map.Entry<T, Object> entry : smallSortedMap.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(smallSortedMap2, entry, bl2);
        }
        return smallSortedMap2;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map, Map.Entry<T, Object> entry, boolean bl2) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            map.put(fieldDescriptorLite, ((LazyField)object).getValue());
        } else if (bl2 && object instanceof List) {
            map.put(fieldDescriptorLite, new ArrayList((List)object));
        } else {
            map.put(fieldDescriptorLite, object);
        }
    }

    public Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public boolean hasField(T t2) {
        if (t2.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(t2) != null;
    }

    public Object getField(T t2) {
        Object object = this.fields.get(t2);
        if (object instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public void setField(T t2, Object arrayList) {
        if (t2.isRepeated()) {
            if (!(arrayList instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(arrayList);
            for (Object e2 : arrayList2) {
                this.verifyType(t2, e2);
            }
            arrayList = arrayList2;
        } else {
            this.verifyType(t2, arrayList);
        }
        if (arrayList instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(t2, (Object)arrayList);
    }

    public void clearField(T t2) {
        this.fields.remove(t2);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(T t2) {
        if (!t2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(t2);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public Object getRepeatedField(T t2, int n2) {
        if (!t2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(t2);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n2);
    }

    public void setRepeatedField(T t2, int n2, Object object) {
        if (!t2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object2 = this.getField(t2);
        if (object2 == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(t2, object);
        ((List)object2).set(n2, object);
    }

    public void addRepeatedField(T t2, Object object) {
        ArrayList<Object> arrayList;
        if (!t2.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(t2, object);
        Object object2 = this.getField(t2);
        if (object2 == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(t2, (Object)arrayList);
        } else {
            arrayList = (ArrayList<Object>)object2;
        }
        arrayList.add(object);
    }

    private void verifyType(T t2, Object object) {
        if (!FieldSet.isValidType(t2.getLiteType(), object)) {
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{t2.getNumber(), t2.getLiteType().getJavaType(), object.getClass().getName()}));
        }
    }

    private static boolean isValidType(WireFormat.FieldType fieldType, Object object) {
        Internal.checkNotNull(object);
        switch (fieldType.getJavaType()) {
            case INT: {
                return object instanceof Integer;
            }
            case LONG: {
                return object instanceof Long;
            }
            case FLOAT: {
                return object instanceof Float;
            }
            case DOUBLE: {
                return object instanceof Double;
            }
            case BOOLEAN: {
                return object instanceof Boolean;
            }
            case STRING: {
                return object instanceof String;
            }
            case BYTE_STRING: {
                return object instanceof ByteString || object instanceof byte[];
            }
            case ENUM: {
                return object instanceof Integer || object instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return object instanceof MessageLite || object instanceof LazyField;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                for (MessageLite messageLite : (List)entry.getValue()) {
                    if (messageLite.isInitialized()) continue;
                    return false;
                }
            } else {
                Object object = entry.getValue();
                if (object instanceof MessageLite) {
                    if (!((MessageLite)object).isInitialized()) {
                        return false;
                    }
                } else {
                    if (object instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType fieldType, boolean bl2) {
        if (bl2) {
            return 2;
        }
        return fieldType.getWireType();
    }

    public void mergeFrom(FieldSet<T> fieldSet) {
        for (int i2 = 0; i2 < fieldSet.fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(fieldSet.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : fieldSet.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return object;
    }

    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            for (Object e2 : (List)object) {
                ((List)arrayList).add(FieldSet.cloneIfMutable(e2));
            }
            this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
        } else if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object object2 = this.getField(fieldDescriptorLite);
            if (object2 == null) {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            } else {
                object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
                this.fields.put((T)fieldDescriptorLite, object2);
            }
        } else {
            this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
        }
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat.FieldType fieldType, boolean bl2) throws IOException {
        if (bl2) {
            return WireFormat.readPrimitiveField(codedInputStream, fieldType, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(codedInputStream, fieldType, WireFormat.Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
    }

    public void writeMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i2), codedOutputStream);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, codedOutputStream);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream codedOutputStream) throws IOException {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            codedOutputStream.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        } else {
            FieldSet.writeField(fieldDescriptorLite, entry.getValue(), codedOutputStream);
        }
    }

    static void writeElement(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, int n2, Object object) throws IOException {
        if (fieldType == WireFormat.FieldType.GROUP) {
            codedOutputStream.writeGroup(n2, (MessageLite)object);
        } else {
            codedOutputStream.writeTag(n2, FieldSet.getWireFormatForFieldType(fieldType, false));
            FieldSet.writeElementNoTag(codedOutputStream, fieldType, object);
        }
    }

    static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                break;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                break;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                break;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                break;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                break;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                break;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                break;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                break;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                break;
            }
            case STRING: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                break;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                break;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                break;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                break;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                break;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                break;
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal.EnumLite)object).getNumber());
                    break;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> fieldDescriptorLite, Object object, CodedOutputStream codedOutputStream) throws IOException {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n2 = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            List list = (List)object;
            if (fieldDescriptorLite.isPacked()) {
                codedOutputStream.writeTag(n2, 2);
                int n3 = 0;
                for (Object e2 : list) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                codedOutputStream.writeRawVarint32(n3);
                for (Object e2 : list) {
                    FieldSet.writeElementNoTag(codedOutputStream, fieldType, e2);
                }
            } else {
                for (Object e3 : list) {
                    FieldSet.writeElement(codedOutputStream, fieldType, n2, e3);
                }
            }
        } else if (object instanceof LazyField) {
            FieldSet.writeElement(codedOutputStream, fieldType, n2, ((LazyField)object).getValue());
        } else {
            FieldSet.writeElement(codedOutputStream, fieldType, n2, object);
        }
    }

    public int getSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n2;
    }

    public int getMessageSetSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            n2 += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n2 += this.getMessageSetSerializedSize(entry);
        }
        return n2;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            if (object instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)object);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, object);
    }

    static int computeElementSize(WireFormat.FieldType fieldType, int n2, Object object) {
        int n3 = CodedOutputStream.computeTagSize(n2);
        if (fieldType == WireFormat.FieldType.GROUP) {
            n3 *= 2;
        }
        return n3 + FieldSet.computeElementSizeNoTag(fieldType, object);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType fieldType, Object object) {
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object);
            }
            case STRING: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case MESSAGE: {
                if (object instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)object);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case ENUM: {
                if (object instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)object).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> fieldDescriptorLite, Object object) {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n2 = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            if (fieldDescriptorLite.isPacked()) {
                int n3 = 0;
                for (Object e2 : (List)object) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                return n3 + CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeRawVarint32Size(n3);
            }
            int n4 = 0;
            for (Object e3 : (List)object) {
                n4 += FieldSet.computeElementSize(fieldType, n2, e3);
            }
            return n4;
        }
        return FieldSet.computeElementSize(fieldType, n2, object);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> smallSortedMap) {
            this.fields = smallSortedMap;
            this.isMutable = true;
        }

        public FieldSet<T> build() {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap smallSortedMap = this.fields;
            if (this.hasNestedBuilders) {
                smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(smallSortedMap);
            }
            FieldSet fieldSet = new FieldSet(smallSortedMap);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> smallSortedMap) {
            for (int i2 = 0; i2 < smallSortedMap.getNumArrayEntries(); ++i2) {
                Builder.replaceBuilders(smallSortedMap.getArrayEntryAt(i2));
            }
            for (Map.Entry<T, Object> entry : smallSortedMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry) {
            entry.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry.getKey(), entry.getValue()));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T t2, Object object) {
            if (object == null) {
                return object;
            }
            if (t2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (t2.isRepeated()) {
                    if (!(object instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + object.getClass());
                    }
                    ArrayList<Object> arrayList = (ArrayList<Object>)object;
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        Object e2 = arrayList.get(i2);
                        Object object2 = Builder.replaceBuilder(e2);
                        if (object2 == e2) continue;
                        if (arrayList == object) {
                            arrayList = new ArrayList<Object>(arrayList);
                        }
                        arrayList.set(i2, object2);
                    }
                    return arrayList;
                }
                return Builder.replaceBuilder(object);
            }
            return object;
        }

        private static Object replaceBuilder(Object object) {
            return object instanceof MessageLite.Builder ? ((MessageLite.Builder)object).build() : object;
        }

        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            Builder<T> builder = new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true));
            builder.hasLazyField = ((FieldSet)fieldSet).hasLazyField;
            return builder;
        }

        public Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    smallSortedMap.makeImmutable();
                } else {
                    Builder.replaceBuilders(smallSortedMap);
                }
                return smallSortedMap;
            }
            return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
        }

        public boolean hasField(T t2) {
            if (t2.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(t2) != null;
        }

        public Object getField(T t2) {
            Object object = this.getFieldAllowBuilders(t2);
            return Builder.replaceBuilders(t2, object);
        }

        Object getFieldAllowBuilders(T t2) {
            Object object = this.fields.get(t2);
            if (object instanceof LazyField) {
                return ((LazyField)object).getValue();
            }
            return object;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public void setField(T t2, Object arrayList) {
            this.ensureIsMutable();
            if (t2.isRepeated()) {
                if (!(arrayList instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList arrayList2 = new ArrayList(arrayList);
                for (Object e2 : arrayList2) {
                    this.verifyType(t2, e2);
                    this.hasNestedBuilders = this.hasNestedBuilders || e2 instanceof MessageLite.Builder;
                }
                arrayList = arrayList2;
            } else {
                this.verifyType(t2, arrayList);
            }
            if (arrayList instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || arrayList instanceof MessageLite.Builder;
            this.fields.put(t2, (Object)arrayList);
        }

        public void clearField(T t2) {
            this.ensureIsMutable();
            this.fields.remove(t2);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public int getRepeatedFieldCount(T t2) {
            if (!t2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object object = this.getField(t2);
            if (object == null) {
                return 0;
            }
            return ((List)object).size();
        }

        public Object getRepeatedField(T t2, int n2) {
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            Object object = this.getRepeatedFieldAllowBuilders(t2, n2);
            return Builder.replaceBuilder(object);
        }

        Object getRepeatedFieldAllowBuilders(T t2, int n2) {
            if (!t2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object object = this.getFieldAllowBuilders(t2);
            if (object == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)object).get(n2);
        }

        public void setRepeatedField(T t2, int n2, Object object) {
            this.ensureIsMutable();
            if (!t2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || object instanceof MessageLite.Builder;
            Object object2 = this.getField(t2);
            if (object2 == null) {
                throw new IndexOutOfBoundsException();
            }
            this.verifyType(t2, object);
            ((List)object2).set(n2, object);
        }

        public void addRepeatedField(T t2, Object object) {
            ArrayList<Object> arrayList;
            this.ensureIsMutable();
            if (!t2.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || object instanceof MessageLite.Builder;
            this.verifyType(t2, object);
            Object object2 = this.getField(t2);
            if (object2 == null) {
                arrayList = new ArrayList<Object>();
                this.fields.put(t2, (Object)arrayList);
            } else {
                arrayList = (ArrayList<Object>)object2;
            }
            arrayList.add(object);
        }

        private void verifyType(T t2, Object object) {
            if (!FieldSet.isValidType(t2.getLiteType(), object)) {
                if (t2.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && object instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{t2.getNumber(), t2.getLiteType().getJavaType(), object.getClass().getName()}));
            }
        }

        public boolean isInitialized() {
            for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public void mergeFrom(FieldSet<T> fieldSet) {
            this.ensureIsMutable();
            for (int i2 = 0; i2 < ((FieldSet)fieldSet).fields.getNumArrayEntries(); ++i2) {
                this.mergeFromField(((FieldSet)fieldSet).fields.getArrayEntryAt(i2));
            }
            for (Map.Entry entry : ((FieldSet)fieldSet).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            if (fieldDescriptorLite.isRepeated()) {
                ArrayList arrayList = this.getField(fieldDescriptorLite);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                for (Object e2 : (List)object) {
                    ((List)arrayList).add(FieldSet.cloneIfMutable(e2));
                }
                this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
            } else if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object object2 = this.getField(fieldDescriptorLite);
                if (object2 == null) {
                    this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
                } else if (object2 instanceof MessageLite.Builder) {
                    fieldDescriptorLite.internalMergeFrom((MessageLite.Builder)object2, (MessageLite)object);
                } else {
                    object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
                    this.fields.put((T)fieldDescriptorLite, object2);
                }
            } else {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            }
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

