/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.LongString;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Method;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQBasicProperties;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQImpl;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ContentHeaderPropertyReader;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.LongStringHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public interface AMQP {
    public static final int FRAME_METHOD = 1;
    public static final int FRAME_HEADER = 2;
    public static final int FRAME_BODY = 3;
    public static final int FRAME_HEARTBEAT = 8;
    public static final int FRAME_MIN_SIZE = 4096;
    public static final int FRAME_END = 206;
    public static final int REPLY_SUCCESS = 200;
    public static final int CONTENT_TOO_LARGE = 311;
    public static final int NO_ROUTE = 312;
    public static final int NO_CONSUMERS = 313;
    public static final int ACCESS_REFUSED = 403;
    public static final int NOT_FOUND = 404;
    public static final int RESOURCE_LOCKED = 405;
    public static final int PRECONDITION_FAILED = 406;
    public static final int CONNECTION_FORCED = 320;
    public static final int INVALID_PATH = 402;
    public static final int FRAME_ERROR = 501;
    public static final int SYNTAX_ERROR = 502;
    public static final int COMMAND_INVALID = 503;
    public static final int CHANNEL_ERROR = 504;
    public static final int UNEXPECTED_FRAME = 505;
    public static final int RESOURCE_ERROR = 506;
    public static final int NOT_ALLOWED = 530;
    public static final int NOT_IMPLEMENTED = 540;
    public static final int INTERNAL_ERROR = 541;

    public static class BasicProperties
    extends AMQBasicProperties {
        private String contentType;
        private String contentEncoding;
        private Map<String, Object> headers;
        private Integer deliveryMode;
        private Integer priority;
        private String correlationId;
        private String replyTo;
        private String expiration;
        private String messageId;
        private Date timestamp;
        private String type;
        private String userId;
        private String appId;
        private String clusterId;

        public BasicProperties(String string, String string2, Map<String, Object> map, Integer n2, Integer n3, String string3, String string4, String string5, String string6, Date date, String string7, String string8, String string9, String string10) {
            this.contentType = string;
            this.contentEncoding = string2;
            this.headers = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
            this.deliveryMode = n2;
            this.priority = n3;
            this.correlationId = string3;
            this.replyTo = string4;
            this.expiration = string5;
            this.messageId = string6;
            this.timestamp = date;
            this.type = string7;
            this.userId = string8;
            this.appId = string9;
            this.clusterId = string10;
        }

        public BasicProperties(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
            ContentHeaderPropertyReader contentHeaderPropertyReader = new ContentHeaderPropertyReader(dataInputStream);
            boolean bl2 = contentHeaderPropertyReader.readPresence();
            boolean bl3 = contentHeaderPropertyReader.readPresence();
            boolean bl4 = contentHeaderPropertyReader.readPresence();
            boolean bl5 = contentHeaderPropertyReader.readPresence();
            boolean bl6 = contentHeaderPropertyReader.readPresence();
            boolean bl7 = contentHeaderPropertyReader.readPresence();
            boolean bl8 = contentHeaderPropertyReader.readPresence();
            boolean bl9 = contentHeaderPropertyReader.readPresence();
            boolean bl10 = contentHeaderPropertyReader.readPresence();
            boolean bl11 = contentHeaderPropertyReader.readPresence();
            boolean bl12 = contentHeaderPropertyReader.readPresence();
            boolean bl13 = contentHeaderPropertyReader.readPresence();
            boolean bl14 = contentHeaderPropertyReader.readPresence();
            boolean bl15 = contentHeaderPropertyReader.readPresence();
            contentHeaderPropertyReader.finishPresence();
            this.contentType = bl2 ? contentHeaderPropertyReader.readShortstr() : null;
            this.contentEncoding = bl3 ? contentHeaderPropertyReader.readShortstr() : null;
            this.headers = bl4 ? contentHeaderPropertyReader.readTable() : null;
            this.deliveryMode = bl5 ? Integer.valueOf(contentHeaderPropertyReader.readOctet()) : null;
            this.priority = bl6 ? Integer.valueOf(contentHeaderPropertyReader.readOctet()) : null;
            this.correlationId = bl7 ? contentHeaderPropertyReader.readShortstr() : null;
            this.replyTo = bl8 ? contentHeaderPropertyReader.readShortstr() : null;
            this.expiration = bl9 ? contentHeaderPropertyReader.readShortstr() : null;
            this.messageId = bl10 ? contentHeaderPropertyReader.readShortstr() : null;
            this.timestamp = bl11 ? contentHeaderPropertyReader.readTimestamp() : null;
            this.type = bl12 ? contentHeaderPropertyReader.readShortstr() : null;
            this.userId = bl13 ? contentHeaderPropertyReader.readShortstr() : null;
            this.appId = bl14 ? contentHeaderPropertyReader.readShortstr() : null;
            this.clusterId = bl15 ? contentHeaderPropertyReader.readShortstr() : null;
        }

        public BasicProperties() {
        }

        @Override
        public int getClassId() {
            return 60;
        }

        @Override
        public String getClassName() {
            return "basic";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BasicProperties basicProperties = (BasicProperties)object;
            if (this.contentType != null ? !this.contentType.equals(basicProperties.contentType) : basicProperties.contentType != null) {
                return false;
            }
            if (this.contentEncoding != null ? !this.contentEncoding.equals(basicProperties.contentEncoding) : basicProperties.contentEncoding != null) {
                return false;
            }
            if (this.headers != null ? !this.headers.equals(basicProperties.headers) : basicProperties.headers != null) {
                return false;
            }
            if (this.deliveryMode != null ? !this.deliveryMode.equals(basicProperties.deliveryMode) : basicProperties.deliveryMode != null) {
                return false;
            }
            if (this.priority != null ? !this.priority.equals(basicProperties.priority) : basicProperties.priority != null) {
                return false;
            }
            if (this.correlationId != null ? !this.correlationId.equals(basicProperties.correlationId) : basicProperties.correlationId != null) {
                return false;
            }
            if (this.replyTo != null ? !this.replyTo.equals(basicProperties.replyTo) : basicProperties.replyTo != null) {
                return false;
            }
            if (this.expiration != null ? !this.expiration.equals(basicProperties.expiration) : basicProperties.expiration != null) {
                return false;
            }
            if (this.messageId != null ? !this.messageId.equals(basicProperties.messageId) : basicProperties.messageId != null) {
                return false;
            }
            if (this.timestamp != null ? !this.timestamp.equals(basicProperties.timestamp) : basicProperties.timestamp != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(basicProperties.type) : basicProperties.type != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(basicProperties.userId) : basicProperties.userId != null) {
                return false;
            }
            if (this.appId != null ? !this.appId.equals(basicProperties.appId) : basicProperties.appId != null) {
                return false;
            }
            return !(this.clusterId != null ? !this.clusterId.equals(basicProperties.clusterId) : basicProperties.clusterId != null);
        }

        public int hashCode() {
            int n2 = 0;
            n2 = 31 * n2 + (this.contentType != null ? this.contentType.hashCode() : 0);
            n2 = 31 * n2 + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
            n2 = 31 * n2 + (this.headers != null ? this.headers.hashCode() : 0);
            n2 = 31 * n2 + (this.deliveryMode != null ? this.deliveryMode.hashCode() : 0);
            n2 = 31 * n2 + (this.priority != null ? this.priority.hashCode() : 0);
            n2 = 31 * n2 + (this.correlationId != null ? this.correlationId.hashCode() : 0);
            n2 = 31 * n2 + (this.replyTo != null ? this.replyTo.hashCode() : 0);
            n2 = 31 * n2 + (this.expiration != null ? this.expiration.hashCode() : 0);
            n2 = 31 * n2 + (this.messageId != null ? this.messageId.hashCode() : 0);
            n2 = 31 * n2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
            n2 = 31 * n2 + (this.userId != null ? this.userId.hashCode() : 0);
            n2 = 31 * n2 + (this.appId != null ? this.appId.hashCode() : 0);
            n2 = 31 * n2 + (this.clusterId != null ? this.clusterId.hashCode() : 0);
            return n2;
        }

        public Builder builder() {
            Builder builder = new Builder().contentType(this.contentType).contentEncoding(this.contentEncoding).headers(this.headers).deliveryMode(this.deliveryMode).priority(this.priority).correlationId(this.correlationId).replyTo(this.replyTo).expiration(this.expiration).messageId(this.messageId).timestamp(this.timestamp).type(this.type).userId(this.userId).appId(this.appId).clusterId(this.clusterId);
            return builder;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        @Override
        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        @Override
        public Integer getPriority() {
            return this.priority;
        }

        @Override
        public String getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public String getExpiration() {
            return this.expiration;
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        @Override
        public void writePropertiesTo(ContentHeaderPropertyWriter contentHeaderPropertyWriter) throws IOException {
            contentHeaderPropertyWriter.writePresence(this.contentType != null);
            contentHeaderPropertyWriter.writePresence(this.contentEncoding != null);
            contentHeaderPropertyWriter.writePresence(this.headers != null);
            contentHeaderPropertyWriter.writePresence(this.deliveryMode != null);
            contentHeaderPropertyWriter.writePresence(this.priority != null);
            contentHeaderPropertyWriter.writePresence(this.correlationId != null);
            contentHeaderPropertyWriter.writePresence(this.replyTo != null);
            contentHeaderPropertyWriter.writePresence(this.expiration != null);
            contentHeaderPropertyWriter.writePresence(this.messageId != null);
            contentHeaderPropertyWriter.writePresence(this.timestamp != null);
            contentHeaderPropertyWriter.writePresence(this.type != null);
            contentHeaderPropertyWriter.writePresence(this.userId != null);
            contentHeaderPropertyWriter.writePresence(this.appId != null);
            contentHeaderPropertyWriter.writePresence(this.clusterId != null);
            contentHeaderPropertyWriter.finishPresence();
            if (this.contentType != null) {
                contentHeaderPropertyWriter.writeShortstr(this.contentType);
            }
            if (this.contentEncoding != null) {
                contentHeaderPropertyWriter.writeShortstr(this.contentEncoding);
            }
            if (this.headers != null) {
                contentHeaderPropertyWriter.writeTable(this.headers);
            }
            if (this.deliveryMode != null) {
                contentHeaderPropertyWriter.writeOctet(this.deliveryMode);
            }
            if (this.priority != null) {
                contentHeaderPropertyWriter.writeOctet(this.priority);
            }
            if (this.correlationId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.correlationId);
            }
            if (this.replyTo != null) {
                contentHeaderPropertyWriter.writeShortstr(this.replyTo);
            }
            if (this.expiration != null) {
                contentHeaderPropertyWriter.writeShortstr(this.expiration);
            }
            if (this.messageId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.messageId);
            }
            if (this.timestamp != null) {
                contentHeaderPropertyWriter.writeTimestamp(this.timestamp);
            }
            if (this.type != null) {
                contentHeaderPropertyWriter.writeShortstr(this.type);
            }
            if (this.userId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.userId);
            }
            if (this.appId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.appId);
            }
            if (this.clusterId != null) {
                contentHeaderPropertyWriter.writeShortstr(this.clusterId);
            }
        }

        @Override
        public void appendPropertyDebugStringTo(StringBuilder stringBuilder) {
            stringBuilder.append("(content-type=").append(this.contentType).append(", content-encoding=").append(this.contentEncoding).append(", headers=").append(this.headers).append(", delivery-mode=").append(this.deliveryMode).append(", priority=").append(this.priority).append(", correlation-id=").append(this.correlationId).append(", reply-to=").append(this.replyTo).append(", expiration=").append(this.expiration).append(", message-id=").append(this.messageId).append(", timestamp=").append(this.timestamp).append(", type=").append(this.type).append(", user-id=").append(this.userId).append(", app-id=").append(this.appId).append(", cluster-id=").append(this.clusterId).append(")");
        }

        public static final class Builder {
            private String contentType;
            private String contentEncoding;
            private Map<String, Object> headers;
            private Integer deliveryMode;
            private Integer priority;
            private String correlationId;
            private String replyTo;
            private String expiration;
            private String messageId;
            private Date timestamp;
            private String type;
            private String userId;
            private String appId;
            private String clusterId;

            public Builder contentType(String string) {
                this.contentType = string;
                return this;
            }

            public Builder contentEncoding(String string) {
                this.contentEncoding = string;
                return this;
            }

            public Builder headers(Map<String, Object> map) {
                this.headers = map;
                return this;
            }

            public Builder deliveryMode(Integer n2) {
                this.deliveryMode = n2;
                return this;
            }

            public Builder priority(Integer n2) {
                this.priority = n2;
                return this;
            }

            public Builder correlationId(String string) {
                this.correlationId = string;
                return this;
            }

            public Builder replyTo(String string) {
                this.replyTo = string;
                return this;
            }

            public Builder expiration(String string) {
                this.expiration = string;
                return this;
            }

            public Builder messageId(String string) {
                this.messageId = string;
                return this;
            }

            public Builder timestamp(Date date) {
                this.timestamp = date;
                return this;
            }

            public Builder type(String string) {
                this.type = string;
                return this;
            }

            public Builder userId(String string) {
                this.userId = string;
                return this;
            }

            public Builder appId(String string) {
                this.appId = string;
                return this;
            }

            public Builder clusterId(String string) {
                this.clusterId = string;
                return this;
            }

            public BasicProperties build() {
                return new BasicProperties(this.contentType, this.contentEncoding, this.headers, this.deliveryMode, this.priority, this.correlationId, this.replyTo, this.expiration, this.messageId, this.timestamp, this.type, this.userId, this.appId, this.clusterId);
            }
        }
    }

    public static class Confirm {

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Confirm.SelectOk();
                }
            }
        }

        public static interface Select
        extends Method {
            public boolean getNowait();

            public static final class Builder {
                private boolean nowait = false;

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Select build() {
                    return new AMQImpl.Confirm.Select(this.nowait);
                }
            }
        }
    }

    public static class Tx {

        public static interface RollbackOk
        extends Method {

            public static final class Builder {
                public RollbackOk build() {
                    return new AMQImpl.Tx.RollbackOk();
                }
            }
        }

        public static interface Rollback
        extends Method {

            public static final class Builder {
                public Rollback build() {
                    return new AMQImpl.Tx.Rollback();
                }
            }
        }

        public static interface CommitOk
        extends Method {

            public static final class Builder {
                public CommitOk build() {
                    return new AMQImpl.Tx.CommitOk();
                }
            }
        }

        public static interface Commit
        extends Method {

            public static final class Builder {
                public Commit build() {
                    return new AMQImpl.Tx.Commit();
                }
            }
        }

        public static interface SelectOk
        extends Method {

            public static final class Builder {
                public SelectOk build() {
                    return new AMQImpl.Tx.SelectOk();
                }
            }
        }

        public static interface Select
        extends Method {

            public static final class Builder {
                public Select build() {
                    return new AMQImpl.Tx.Select();
                }
            }
        }
    }

    public static class Basic {

        public static interface Nack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;
                private boolean requeue = true;

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder multiple(boolean bl2) {
                    this.multiple = bl2;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Nack build() {
                    return new AMQImpl.Basic.Nack(this.deliveryTag, this.multiple, this.requeue);
                }
            }
        }

        public static interface RecoverOk
        extends Method {

            public static final class Builder {
                public RecoverOk build() {
                    return new AMQImpl.Basic.RecoverOk();
                }
            }
        }

        public static interface Recover
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Recover build() {
                    return new AMQImpl.Basic.Recover(this.requeue);
                }
            }
        }

        public static interface RecoverAsync
        extends Method {
            public boolean getRequeue();

            public static final class Builder {
                private boolean requeue = false;

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public RecoverAsync build() {
                    return new AMQImpl.Basic.RecoverAsync(this.requeue);
                }
            }
        }

        public static interface Reject
        extends Method {
            public long getDeliveryTag();

            public boolean getRequeue();

            public static final class Builder {
                private long deliveryTag;
                private boolean requeue = true;

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder requeue(boolean bl2) {
                    this.requeue = bl2;
                    return this;
                }

                public Builder requeue() {
                    return this.requeue(true);
                }

                public Reject build() {
                    return new AMQImpl.Basic.Reject(this.deliveryTag, this.requeue);
                }
            }
        }

        public static interface Ack
        extends Method {
            public long getDeliveryTag();

            public boolean getMultiple();

            public static final class Builder {
                private long deliveryTag = 0L;
                private boolean multiple = false;

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder multiple(boolean bl2) {
                    this.multiple = bl2;
                    return this;
                }

                public Builder multiple() {
                    return this.multiple(true);
                }

                public Ack build() {
                    return new AMQImpl.Basic.Ack(this.deliveryTag, this.multiple);
                }
            }
        }

        public static interface GetEmpty
        extends Method {
            public String getClusterId();

            public static final class Builder {
                private String clusterId = "";

                public Builder clusterId(String string) {
                    this.clusterId = string;
                    return this;
                }

                public GetEmpty build() {
                    return new AMQImpl.Basic.GetEmpty(this.clusterId);
                }
            }
        }

        public static interface GetOk
        extends Method {
            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public int getMessageCount();

            public static final class Builder {
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;
                private int messageCount;

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder redelivered(boolean bl2) {
                    this.redelivered = bl2;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public GetOk build() {
                    return new AMQImpl.Basic.GetOk(this.deliveryTag, this.redelivered, this.exchange, this.routingKey, this.messageCount);
                }
            }
        }

        public static interface Get
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNoAck();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean noAck = false;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder noAck(boolean bl2) {
                    this.noAck = bl2;
                    return this;
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Get build() {
                    return new AMQImpl.Basic.Get(this.ticket, this.queue, this.noAck);
                }
            }
        }

        public static interface Deliver
        extends Method {
            public String getConsumerTag();

            public long getDeliveryTag();

            public boolean getRedelivered();

            public String getExchange();

            public String getRoutingKey();

            public static final class Builder {
                private String consumerTag;
                private long deliveryTag;
                private boolean redelivered = false;
                private String exchange;
                private String routingKey;

                public Builder consumerTag(String string) {
                    this.consumerTag = string;
                    return this;
                }

                public Builder deliveryTag(long l2) {
                    this.deliveryTag = l2;
                    return this;
                }

                public Builder redelivered(boolean bl2) {
                    this.redelivered = bl2;
                    return this;
                }

                public Builder redelivered() {
                    return this.redelivered(true);
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Deliver build() {
                    return new AMQImpl.Basic.Deliver(this.consumerTag, this.deliveryTag, this.redelivered, this.exchange, this.routingKey);
                }
            }
        }

        public static interface Return
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public String getExchange();

            public String getRoutingKey();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private String exchange;
                private String routingKey;

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string) {
                    this.replyText = string;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Return build() {
                    return new AMQImpl.Basic.Return(this.replyCode, this.replyText, this.exchange, this.routingKey);
                }
            }
        }

        public static interface Publish
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getRoutingKey();

            public boolean getMandatory();

            public boolean getImmediate();

            public static final class Builder {
                private int ticket = 0;
                private String exchange = "";
                private String routingKey = "";
                private boolean mandatory = false;
                private boolean immediate = false;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder mandatory(boolean bl2) {
                    this.mandatory = bl2;
                    return this;
                }

                public Builder mandatory() {
                    return this.mandatory(true);
                }

                public Builder immediate(boolean bl2) {
                    this.immediate = bl2;
                    return this;
                }

                public Builder immediate() {
                    return this.immediate(true);
                }

                public Publish build() {
                    return new AMQImpl.Basic.Publish(this.ticket, this.exchange, this.routingKey, this.mandatory, this.immediate);
                }
            }
        }

        public static interface CancelOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public Builder consumerTag(String string) {
                    this.consumerTag = string;
                    return this;
                }

                public CancelOk build() {
                    return new AMQImpl.Basic.CancelOk(this.consumerTag);
                }
            }
        }

        public static interface Cancel
        extends Method {
            public String getConsumerTag();

            public boolean getNowait();

            public static final class Builder {
                private String consumerTag;
                private boolean nowait = false;

                public Builder consumerTag(String string) {
                    this.consumerTag = string;
                    return this;
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Cancel build() {
                    return new AMQImpl.Basic.Cancel(this.consumerTag, this.nowait);
                }
            }
        }

        public static interface ConsumeOk
        extends Method {
            public String getConsumerTag();

            public static final class Builder {
                private String consumerTag;

                public Builder consumerTag(String string) {
                    this.consumerTag = string;
                    return this;
                }

                public ConsumeOk build() {
                    return new AMQImpl.Basic.ConsumeOk(this.consumerTag);
                }
            }
        }

        public static interface Consume
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getConsumerTag();

            public boolean getNoLocal();

            public boolean getNoAck();

            public boolean getExclusive();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String consumerTag = "";
                private boolean noLocal = false;
                private boolean noAck = false;
                private boolean exclusive = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder consumerTag(String string) {
                    this.consumerTag = string;
                    return this;
                }

                public Builder noLocal(boolean bl2) {
                    this.noLocal = bl2;
                    return this;
                }

                public Builder noLocal() {
                    return this.noLocal(true);
                }

                public Builder noAck(boolean bl2) {
                    this.noAck = bl2;
                    return this;
                }

                public Builder noAck() {
                    return this.noAck(true);
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Consume build() {
                    return new AMQImpl.Basic.Consume(this.ticket, this.queue, this.consumerTag, this.noLocal, this.noAck, this.exclusive, this.nowait, this.arguments);
                }
            }
        }

        public static interface QosOk
        extends Method {

            public static final class Builder {
                public QosOk build() {
                    return new AMQImpl.Basic.QosOk();
                }
            }
        }

        public static interface Qos
        extends Method {
            public int getPrefetchSize();

            public int getPrefetchCount();

            public boolean getGlobal();

            public static final class Builder {
                private int prefetchSize = 0;
                private int prefetchCount = 0;
                private boolean global = false;

                public Builder prefetchSize(int n2) {
                    this.prefetchSize = n2;
                    return this;
                }

                public Builder prefetchCount(int n2) {
                    this.prefetchCount = n2;
                    return this;
                }

                public Builder global(boolean bl2) {
                    this.global = bl2;
                    return this;
                }

                public Builder global() {
                    return this.global(true);
                }

                public Qos build() {
                    return new AMQImpl.Basic.Qos(this.prefetchSize, this.prefetchCount, this.global);
                }
            }
        }
    }

    public static class Queue {

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Queue.UnbindOk();
                }
            }
        }

        public static interface Unbind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Queue.Unbind(this.ticket, this.queue, this.exchange, this.routingKey, this.arguments);
                }
            }
        }

        public static interface DeleteOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public DeleteOk build() {
                    return new AMQImpl.Queue.DeleteOk(this.messageCount);
                }
            }
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getIfUnused();

            public boolean getIfEmpty();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean ifUnused = false;
                private boolean ifEmpty = false;
                private boolean nowait = false;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder ifUnused(boolean bl2) {
                    this.ifUnused = bl2;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder ifEmpty(boolean bl2) {
                    this.ifEmpty = bl2;
                    return this;
                }

                public Builder ifEmpty() {
                    return this.ifEmpty(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Delete build() {
                    return new AMQImpl.Queue.Delete(this.ticket, this.queue, this.ifUnused, this.ifEmpty, this.nowait);
                }
            }
        }

        public static interface PurgeOk
        extends Method {
            public int getMessageCount();

            public static final class Builder {
                private int messageCount;

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public PurgeOk build() {
                    return new AMQImpl.Queue.PurgeOk(this.messageCount);
                }
            }
        }

        public static interface Purge
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean nowait = false;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Purge build() {
                    return new AMQImpl.Queue.Purge(this.ticket, this.queue, this.nowait);
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Queue.BindOk();
                }
            }
        }

        public static interface Bind
        extends Method {
            public int getTicket();

            public String getQueue();

            public String getExchange();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private String exchange;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Queue.Bind(this.ticket, this.queue, this.exchange, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface DeclareOk
        extends Method {
            public String getQueue();

            public int getMessageCount();

            public int getConsumerCount();

            public static final class Builder {
                private String queue;
                private int messageCount;
                private int consumerCount;

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder messageCount(int n2) {
                    this.messageCount = n2;
                    return this;
                }

                public Builder consumerCount(int n2) {
                    this.consumerCount = n2;
                    return this;
                }

                public DeclareOk build() {
                    return new AMQImpl.Queue.DeclareOk(this.queue, this.messageCount, this.consumerCount);
                }
            }
        }

        public static interface Declare
        extends Method {
            public int getTicket();

            public String getQueue();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getExclusive();

            public boolean getAutoDelete();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String queue = "";
                private boolean passive = false;
                private boolean durable = false;
                private boolean exclusive = false;
                private boolean autoDelete = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder queue(String string) {
                    this.queue = string;
                    return this;
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder durable(boolean bl2) {
                    this.durable = bl2;
                    return this;
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder autoDelete(boolean bl2) {
                    this.autoDelete = bl2;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Queue.Declare(this.ticket, this.queue, this.passive, this.durable, this.exclusive, this.autoDelete, this.nowait, this.arguments);
                }
            }
        }
    }

    public static class Exchange {

        public static interface UnbindOk
        extends Method {

            public static final class Builder {
                public UnbindOk build() {
                    return new AMQImpl.Exchange.UnbindOk();
                }
            }
        }

        public static interface Unbind
        extends Method {
            public int getTicket();

            public String getDestination();

            public String getSource();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder destination(String string) {
                    this.destination = string;
                    return this;
                }

                public Builder source(String string) {
                    this.source = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Unbind build() {
                    return new AMQImpl.Exchange.Unbind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface BindOk
        extends Method {

            public static final class Builder {
                public BindOk build() {
                    return new AMQImpl.Exchange.BindOk();
                }
            }
        }

        public static interface Bind
        extends Method {
            public int getTicket();

            public String getDestination();

            public String getSource();

            public String getRoutingKey();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String destination;
                private String source;
                private String routingKey = "";
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder destination(String string) {
                    this.destination = string;
                    return this;
                }

                public Builder source(String string) {
                    this.source = string;
                    return this;
                }

                public Builder routingKey(String string) {
                    this.routingKey = string;
                    return this;
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Bind build() {
                    return new AMQImpl.Exchange.Bind(this.ticket, this.destination, this.source, this.routingKey, this.nowait, this.arguments);
                }
            }
        }

        public static interface DeleteOk
        extends Method {

            public static final class Builder {
                public DeleteOk build() {
                    return new AMQImpl.Exchange.DeleteOk();
                }
            }
        }

        public static interface Delete
        extends Method {
            public int getTicket();

            public String getExchange();

            public boolean getIfUnused();

            public boolean getNowait();

            public static final class Builder {
                private int ticket = 0;
                private String exchange;
                private boolean ifUnused = false;
                private boolean nowait = false;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder ifUnused(boolean bl2) {
                    this.ifUnused = bl2;
                    return this;
                }

                public Builder ifUnused() {
                    return this.ifUnused(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Delete build() {
                    return new AMQImpl.Exchange.Delete(this.ticket, this.exchange, this.ifUnused, this.nowait);
                }
            }
        }

        public static interface DeclareOk
        extends Method {

            public static final class Builder {
                public DeclareOk build() {
                    return new AMQImpl.Exchange.DeclareOk();
                }
            }
        }

        public static interface Declare
        extends Method {
            public int getTicket();

            public String getExchange();

            public String getType();

            public boolean getPassive();

            public boolean getDurable();

            public boolean getAutoDelete();

            public boolean getInternal();

            public boolean getNowait();

            public Map<String, Object> getArguments();

            public static final class Builder {
                private int ticket = 0;
                private String exchange;
                private String type = "direct";
                private boolean passive = false;
                private boolean durable = false;
                private boolean autoDelete = false;
                private boolean internal = false;
                private boolean nowait = false;
                private Map<String, Object> arguments = null;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public Builder exchange(String string) {
                    this.exchange = string;
                    return this;
                }

                public Builder type(String string) {
                    this.type = string;
                    return this;
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder durable(boolean bl2) {
                    this.durable = bl2;
                    return this;
                }

                public Builder durable() {
                    return this.durable(true);
                }

                public Builder autoDelete(boolean bl2) {
                    this.autoDelete = bl2;
                    return this;
                }

                public Builder autoDelete() {
                    return this.autoDelete(true);
                }

                public Builder internal(boolean bl2) {
                    this.internal = bl2;
                    return this;
                }

                public Builder internal() {
                    return this.internal(true);
                }

                public Builder nowait(boolean bl2) {
                    this.nowait = bl2;
                    return this;
                }

                public Builder nowait() {
                    return this.nowait(true);
                }

                public Builder arguments(Map<String, Object> map) {
                    this.arguments = map;
                    return this;
                }

                public Declare build() {
                    return new AMQImpl.Exchange.Declare(this.ticket, this.exchange, this.type, this.passive, this.durable, this.autoDelete, this.internal, this.nowait, this.arguments);
                }
            }
        }
    }

    public static class Access {

        public static interface RequestOk
        extends Method {
            public int getTicket();

            public static final class Builder {
                private int ticket = 1;

                public Builder ticket(int n2) {
                    this.ticket = n2;
                    return this;
                }

                public RequestOk build() {
                    return new AMQImpl.Access.RequestOk(this.ticket);
                }
            }
        }

        public static interface Request
        extends Method {
            public String getRealm();

            public boolean getExclusive();

            public boolean getPassive();

            public boolean getActive();

            public boolean getWrite();

            public boolean getRead();

            public static final class Builder {
                private String realm = "/data";
                private boolean exclusive = false;
                private boolean passive = true;
                private boolean active = true;
                private boolean write = true;
                private boolean read = true;

                public Builder realm(String string) {
                    this.realm = string;
                    return this;
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Builder exclusive() {
                    return this.exclusive(true);
                }

                public Builder passive(boolean bl2) {
                    this.passive = bl2;
                    return this;
                }

                public Builder passive() {
                    return this.passive(true);
                }

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public Builder write(boolean bl2) {
                    this.write = bl2;
                    return this;
                }

                public Builder write() {
                    return this.write(true);
                }

                public Builder read(boolean bl2) {
                    this.read = bl2;
                    return this;
                }

                public Builder read() {
                    return this.read(true);
                }

                public Request build() {
                    return new AMQImpl.Access.Request(this.realm, this.exclusive, this.passive, this.active, this.write, this.read);
                }
            }
        }
    }

    public static class Channel {

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Channel.CloseOk();
                }
            }
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string) {
                    this.replyText = string;
                    return this;
                }

                public Builder classId(int n2) {
                    this.classId = n2;
                    return this;
                }

                public Builder methodId(int n2) {
                    this.methodId = n2;
                    return this;
                }

                public Close build() {
                    return new AMQImpl.Channel.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }
            }
        }

        public static interface FlowOk
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public FlowOk build() {
                    return new AMQImpl.Channel.FlowOk(this.active);
                }
            }
        }

        public static interface Flow
        extends Method {
            public boolean getActive();

            public static final class Builder {
                private boolean active;

                public Builder active(boolean bl2) {
                    this.active = bl2;
                    return this;
                }

                public Builder active() {
                    return this.active(true);
                }

                public Flow build() {
                    return new AMQImpl.Channel.Flow(this.active);
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public LongString getChannelId();

            public static final class Builder {
                private LongString channelId = LongStringHelper.asLongString("");

                public Builder channelId(LongString longString) {
                    this.channelId = longString;
                    return this;
                }

                public Builder channelId(String string) {
                    return this.channelId(LongStringHelper.asLongString(string));
                }

                public OpenOk build() {
                    return new AMQImpl.Channel.OpenOk(this.channelId);
                }
            }
        }

        public static interface Open
        extends Method {
            public String getOutOfBand();

            public static final class Builder {
                private String outOfBand = "";

                public Builder outOfBand(String string) {
                    this.outOfBand = string;
                    return this;
                }

                public Open build() {
                    return new AMQImpl.Channel.Open(this.outOfBand);
                }
            }
        }
    }

    public static class Connection {

        public static interface Unblocked
        extends Method {

            public static final class Builder {
                public Unblocked build() {
                    return new AMQImpl.Connection.Unblocked();
                }
            }
        }

        public static interface Blocked
        extends Method {
            public String getReason();

            public static final class Builder {
                private String reason = "";

                public Builder reason(String string) {
                    this.reason = string;
                    return this;
                }

                public Blocked build() {
                    return new AMQImpl.Connection.Blocked(this.reason);
                }
            }
        }

        public static interface CloseOk
        extends Method {

            public static final class Builder {
                public CloseOk build() {
                    return new AMQImpl.Connection.CloseOk();
                }
            }
        }

        public static interface Close
        extends Method {
            public int getReplyCode();

            public String getReplyText();

            public int getClassId();

            public int getMethodId();

            public static final class Builder {
                private int replyCode;
                private String replyText = "";
                private int classId;
                private int methodId;

                public Builder replyCode(int n2) {
                    this.replyCode = n2;
                    return this;
                }

                public Builder replyText(String string) {
                    this.replyText = string;
                    return this;
                }

                public Builder classId(int n2) {
                    this.classId = n2;
                    return this;
                }

                public Builder methodId(int n2) {
                    this.methodId = n2;
                    return this;
                }

                public Close build() {
                    return new AMQImpl.Connection.Close(this.replyCode, this.replyText, this.classId, this.methodId);
                }
            }
        }

        public static interface OpenOk
        extends Method {
            public String getKnownHosts();

            public static final class Builder {
                private String knownHosts = "";

                public Builder knownHosts(String string) {
                    this.knownHosts = string;
                    return this;
                }

                public OpenOk build() {
                    return new AMQImpl.Connection.OpenOk(this.knownHosts);
                }
            }
        }

        public static interface Open
        extends Method {
            public String getVirtualHost();

            public String getCapabilities();

            public boolean getInsist();

            public static final class Builder {
                private String virtualHost = "/";
                private String capabilities = "";
                private boolean insist = false;

                public Builder virtualHost(String string) {
                    this.virtualHost = string;
                    return this;
                }

                public Builder capabilities(String string) {
                    this.capabilities = string;
                    return this;
                }

                public Builder insist(boolean bl2) {
                    this.insist = bl2;
                    return this;
                }

                public Builder insist() {
                    return this.insist(true);
                }

                public Open build() {
                    return new AMQImpl.Connection.Open(this.virtualHost, this.capabilities, this.insist);
                }
            }
        }

        public static interface TuneOk
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder channelMax(int n2) {
                    this.channelMax = n2;
                    return this;
                }

                public Builder frameMax(int n2) {
                    this.frameMax = n2;
                    return this;
                }

                public Builder heartbeat(int n2) {
                    this.heartbeat = n2;
                    return this;
                }

                public TuneOk build() {
                    return new AMQImpl.Connection.TuneOk(this.channelMax, this.frameMax, this.heartbeat);
                }
            }
        }

        public static interface Tune
        extends Method {
            public int getChannelMax();

            public int getFrameMax();

            public int getHeartbeat();

            public static final class Builder {
                private int channelMax = 0;
                private int frameMax = 0;
                private int heartbeat = 0;

                public Builder channelMax(int n2) {
                    this.channelMax = n2;
                    return this;
                }

                public Builder frameMax(int n2) {
                    this.frameMax = n2;
                    return this;
                }

                public Builder heartbeat(int n2) {
                    this.heartbeat = n2;
                    return this;
                }

                public Tune build() {
                    return new AMQImpl.Connection.Tune(this.channelMax, this.frameMax, this.heartbeat);
                }
            }
        }

        public static interface SecureOk
        extends Method {
            public LongString getResponse();

            public static final class Builder {
                private LongString response;

                public Builder response(LongString longString) {
                    this.response = longString;
                    return this;
                }

                public Builder response(String string) {
                    return this.response(LongStringHelper.asLongString(string));
                }

                public SecureOk build() {
                    return new AMQImpl.Connection.SecureOk(this.response);
                }
            }
        }

        public static interface Secure
        extends Method {
            public LongString getChallenge();

            public static final class Builder {
                private LongString challenge;

                public Builder challenge(LongString longString) {
                    this.challenge = longString;
                    return this;
                }

                public Builder challenge(String string) {
                    return this.challenge(LongStringHelper.asLongString(string));
                }

                public Secure build() {
                    return new AMQImpl.Connection.Secure(this.challenge);
                }
            }
        }

        public static interface StartOk
        extends Method {
            public Map<String, Object> getClientProperties();

            public String getMechanism();

            public LongString getResponse();

            public String getLocale();

            public static final class Builder {
                private Map<String, Object> clientProperties;
                private String mechanism = "PLAIN";
                private LongString response;
                private String locale = "en_US";

                public Builder clientProperties(Map<String, Object> map) {
                    this.clientProperties = map;
                    return this;
                }

                public Builder mechanism(String string) {
                    this.mechanism = string;
                    return this;
                }

                public Builder response(LongString longString) {
                    this.response = longString;
                    return this;
                }

                public Builder response(String string) {
                    return this.response(LongStringHelper.asLongString(string));
                }

                public Builder locale(String string) {
                    this.locale = string;
                    return this;
                }

                public StartOk build() {
                    return new AMQImpl.Connection.StartOk(this.clientProperties, this.mechanism, this.response, this.locale);
                }
            }
        }

        public static interface Start
        extends Method {
            public int getVersionMajor();

            public int getVersionMinor();

            public Map<String, Object> getServerProperties();

            public LongString getMechanisms();

            public LongString getLocales();

            public static final class Builder {
                private int versionMajor = 0;
                private int versionMinor = 9;
                private Map<String, Object> serverProperties;
                private LongString mechanisms = LongStringHelper.asLongString("PLAIN");
                private LongString locales = LongStringHelper.asLongString("en_US");

                public Builder versionMajor(int n2) {
                    this.versionMajor = n2;
                    return this;
                }

                public Builder versionMinor(int n2) {
                    this.versionMinor = n2;
                    return this;
                }

                public Builder serverProperties(Map<String, Object> map) {
                    this.serverProperties = map;
                    return this;
                }

                public Builder mechanisms(LongString longString) {
                    this.mechanisms = longString;
                    return this;
                }

                public Builder mechanisms(String string) {
                    return this.mechanisms(LongStringHelper.asLongString(string));
                }

                public Builder locales(LongString longString) {
                    this.locales = longString;
                    return this;
                }

                public Builder locales(String string) {
                    return this.locales(LongStringHelper.asLongString(string));
                }

                public Start build() {
                    return new AMQImpl.Connection.Start(this.versionMajor, this.versionMinor, this.serverProperties, this.mechanisms, this.locales);
                }
            }
        }
    }

    public static class PROTOCOL {
        public static final int MAJOR = 0;
        public static final int MINOR = 9;
        public static final int REVISION = 1;
        public static final int PORT = 5672;
    }
}

