/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConsumerCancelledException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.DefaultConsumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Envelope;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueueingConsumer
extends DefaultConsumer {
    private final BlockingQueue<Delivery> _queue;
    private volatile ShutdownSignalException _shutdown;
    private volatile ConsumerCancelledException _cancelled;
    private static final Delivery POISON = new Delivery(null, null, null);

    public QueueingConsumer(Channel channel) {
        this(channel, new LinkedBlockingQueue<Delivery>());
    }

    public QueueingConsumer(Channel channel, BlockingQueue<Delivery> blockingQueue) {
        super(channel);
        this._queue = blockingQueue;
    }

    @Override
    public void handleShutdownSignal(String string, ShutdownSignalException shutdownSignalException) {
        this._shutdown = shutdownSignalException;
        this._queue.add(POISON);
    }

    @Override
    public void handleCancel(String string) throws IOException {
        this._cancelled = new ConsumerCancelledException();
        this._queue.add(POISON);
    }

    @Override
    public void handleDelivery(String string, Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.checkShutdown();
        this._queue.add(new Delivery(envelope, basicProperties, byArray));
    }

    private void checkShutdown() {
        if (this._shutdown != null) {
            throw Utility.fixStackTrace(this._shutdown);
        }
    }

    private Delivery handle(Delivery delivery) {
        if (delivery == POISON || delivery == null && (this._shutdown != null || this._cancelled != null)) {
            if (delivery == POISON) {
                this._queue.add(POISON);
                if (this._shutdown == null && this._cancelled == null) {
                    throw new IllegalStateException("POISON in queue, but null _shutdown and null _cancelled. This should never happen, please report as a BUG");
                }
            }
            if (null != this._shutdown) {
                throw Utility.fixStackTrace(this._shutdown);
            }
            if (null != this._cancelled) {
                throw Utility.fixStackTrace(this._cancelled);
            }
        }
        return delivery;
    }

    public Delivery nextDelivery() throws InterruptedException, ShutdownSignalException, ConsumerCancelledException {
        return this.handle(this._queue.take());
    }

    public Delivery nextDelivery(long l2) throws InterruptedException, ShutdownSignalException, ConsumerCancelledException {
        return this.handle(this._queue.poll(l2, TimeUnit.MILLISECONDS));
    }

    public static class Delivery {
        private final Envelope _envelope;
        private final AMQP.BasicProperties _properties;
        private final byte[] _body;

        public Delivery(Envelope envelope, AMQP.BasicProperties basicProperties, byte[] byArray) {
            this._envelope = envelope;
            this._properties = basicProperties;
            this._body = byArray;
        }

        public Envelope getEnvelope() {
            return this._envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this._properties;
        }

        public byte[] getBody() {
            return this._body;
        }
    }
}

