/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.QueueingConsumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;

public class RpcServer {
    private final Channel _channel;
    private final String _queueName;
    private boolean _mainloopRunning = true;
    private QueueingConsumer _consumer;

    public RpcServer(Channel channel) throws IOException {
        this(channel, null);
    }

    public RpcServer(Channel channel, String string) throws IOException {
        this._channel = channel;
        this._queueName = string == null || string.equals("") ? this._channel.queueDeclare().getQueue() : string;
        this._consumer = this.setupConsumer();
    }

    public void close() throws IOException {
        if (this._consumer != null) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
            this._consumer = null;
        }
        this.terminateMainloop();
    }

    protected QueueingConsumer setupConsumer() throws IOException {
        QueueingConsumer queueingConsumer = new QueueingConsumer(this._channel);
        this._channel.basicConsume(this._queueName, queueingConsumer);
        return queueingConsumer;
    }

    public ShutdownSignalException mainloop() throws IOException {
        try {
            while (this._mainloopRunning) {
                QueueingConsumer.Delivery delivery;
                try {
                    delivery = this._consumer.nextDelivery();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                this.processRequest(delivery);
                this._channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
            }
            return null;
        }
        catch (ShutdownSignalException shutdownSignalException) {
            return shutdownSignalException;
        }
    }

    public void terminateMainloop() {
        this._mainloopRunning = false;
    }

    public void processRequest(QueueingConsumer.Delivery delivery) throws IOException {
        AMQP.BasicProperties basicProperties = delivery.getProperties();
        String string = basicProperties.getCorrelationId();
        String string2 = basicProperties.getReplyTo();
        if (string != null && string2 != null) {
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder().correlationId(string);
            AMQP.BasicProperties basicProperties2 = this.preprocessReplyProperties(delivery, builder);
            byte[] byArray = this.handleCall(delivery, basicProperties2);
            basicProperties2 = this.postprocessReplyProperties(delivery, basicProperties2.builder());
            this._channel.basicPublish("", string2, basicProperties2, byArray);
        } else {
            this.handleCast(delivery);
        }
    }

    public byte[] handleCall(QueueingConsumer.Delivery delivery, AMQP.BasicProperties basicProperties) {
        return this.handleCall(delivery.getProperties(), delivery.getBody(), basicProperties);
    }

    public byte[] handleCall(AMQP.BasicProperties basicProperties, byte[] byArray, AMQP.BasicProperties basicProperties2) {
        return this.handleCall(byArray, basicProperties2);
    }

    public byte[] handleCall(byte[] byArray, AMQP.BasicProperties basicProperties) {
        return new byte[0];
    }

    protected AMQP.BasicProperties preprocessReplyProperties(QueueingConsumer.Delivery delivery, AMQP.BasicProperties.Builder builder) {
        return builder.build();
    }

    protected AMQP.BasicProperties postprocessReplyProperties(QueueingConsumer.Delivery delivery, AMQP.BasicProperties.Builder builder) {
        return builder.build();
    }

    public void handleCast(QueueingConsumer.Delivery delivery) {
        this.handleCast(delivery.getProperties(), delivery.getBody());
    }

    public void handleCast(AMQP.BasicProperties basicProperties, byte[] byArray) {
        this.handleCast(byArray);
    }

    public void handleCast(byte[] byArray) {
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getQueueName() {
        return this._queueName;
    }
}

