/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.ContentHeader;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.ContentHeaderPropertyWriter;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AMQContentHeader
implements ContentHeader {
    private long bodySize;

    protected AMQContentHeader() {
        this.bodySize = 0L;
    }

    protected AMQContentHeader(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readShort();
        this.bodySize = dataInputStream.readLong();
    }

    public long getBodySize() {
        return this.bodySize;
    }

    private void writeTo(DataOutputStream dataOutputStream, long l2) throws IOException {
        dataOutputStream.writeShort(0);
        dataOutputStream.writeLong(l2);
        this.writePropertiesTo(new ContentHeaderPropertyWriter(dataOutputStream));
    }

    public abstract void writePropertiesTo(ContentHeaderPropertyWriter var1) throws IOException;

    @Override
    public void appendPropertyDebugStringTo(StringBuilder stringBuilder) {
        stringBuilder.append("(?)");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#contentHeader<").append(this.getClassName()).append(">");
        this.appendPropertyDebugStringTo(stringBuilder);
        return stringBuilder.toString();
    }

    public Frame toFrame(int n2, long l2) throws IOException {
        Frame frame = new Frame(2, n2);
        DataOutputStream dataOutputStream = frame.getOutputStream();
        dataOutputStream.writeShort(this.getClassId());
        this.writeTo(dataOutputStream, l2);
        return frame;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

