/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class LongStringHelper {
    public static LongString asLongString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayLongString(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("utf-8 encoding support required");
        }
    }

    public static LongString asLongString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayLongString(byArray);
    }

    private static class ByteArrayLongString
    implements LongString {
        private final byte[] bytes;

        public ByteArrayLongString(byte[] byArray) {
            this.bytes = byArray;
        }

        public boolean equals(Object object) {
            if (object instanceof LongString) {
                LongString longString = (LongString)object;
                return Arrays.equals(this.bytes, longString.getBytes());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        @Override
        public DataInputStream getStream() throws IOException {
            return new DataInputStream(new ByteArrayInputStream(this.bytes));
        }

        @Override
        public long length() {
            return this.bytes.length;
        }

        @Override
        public String toString() {
            try {
                return new String(this.bytes, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("utf-8 encoding support required");
            }
        }
    }
}

