/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.ByteBufferFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioContext;
import java.nio.ByteBuffer;

public class DefaultByteBufferFactory
implements ByteBufferFactory {
    private final ByteBufferAllocator allocator;

    public DefaultByteBufferFactory(ByteBufferAllocator byteBufferAllocator) {
        this.allocator = byteBufferAllocator;
    }

    public DefaultByteBufferFactory() {
        this(new ByteBufferAllocator(){

            @Override
            public ByteBuffer allocate(int n2) {
                return ByteBuffer.allocate(n2);
            }
        });
    }

    @Override
    public ByteBuffer createReadBuffer(NioContext nioContext) {
        if (nioContext.getSslEngine() == null) {
            return this.allocator.allocate(nioContext.getNioParams().getReadByteBufferSize());
        }
        return this.allocator.allocate(nioContext.getSslEngine().getSession().getApplicationBufferSize());
    }

    @Override
    public ByteBuffer createWriteBuffer(NioContext nioContext) {
        if (nioContext.getSslEngine() == null) {
            return this.allocator.allocate(nioContext.getNioParams().getWriteByteBufferSize());
        }
        return this.allocator.allocate(nioContext.getSslEngine().getSession().getApplicationBufferSize());
    }

    @Override
    public ByteBuffer createEncryptedReadBuffer(NioContext nioContext) {
        return this.createEncryptedByteBuffer(nioContext);
    }

    @Override
    public ByteBuffer createEncryptedWriteBuffer(NioContext nioContext) {
        return this.createEncryptedByteBuffer(nioContext);
    }

    protected ByteBuffer createEncryptedByteBuffer(NioContext nioContext) {
        if (nioContext.getSslEngine() == null) {
            throw new IllegalArgumentException("Encrypted byte buffer should be created only in SSL/TLS context");
        }
        return this.allocator.allocate(nioContext.getSslEngine().getSession().getPacketBufferSize());
    }

    public static interface ByteBufferAllocator {
        public ByteBuffer allocate(int var1);
    }
}

