/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Environment;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioLoop;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SelectorHolder;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerFactory;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class NioLoopContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioLoopContext.class);
    private final SocketChannelFrameHandlerFactory socketChannelFrameHandlerFactory;
    private final ExecutorService executorService;
    private final ThreadFactory threadFactory;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    SelectorHolder readSelectorState;
    SelectorHolder writeSelectorState;

    public NioLoopContext(SocketChannelFrameHandlerFactory socketChannelFrameHandlerFactory, NioParams nioParams) {
        this.socketChannelFrameHandlerFactory = socketChannelFrameHandlerFactory;
        this.executorService = nioParams.getNioExecutor();
        this.threadFactory = nioParams.getThreadFactory();
        NioContext nioContext = new NioContext(nioParams, null);
        this.readBuffer = nioParams.getByteBufferFactory().createReadBuffer(nioContext);
        this.writeBuffer = nioParams.getByteBufferFactory().createWriteBuffer(nioContext);
    }

    void initStateIfNecessary() throws IOException {
        if (this.readSelectorState == null) {
            this.readSelectorState = new SelectorHolder(Selector.open());
            this.writeSelectorState = new SelectorHolder(Selector.open());
            this.startIoLoops();
        }
    }

    private void startIoLoops() {
        if (this.executorService == null) {
            Thread thread = Environment.newThread(this.threadFactory, new NioLoop(this.socketChannelFrameHandlerFactory.nioParams, this), "rabbitmq-nio");
            thread.start();
        } else {
            this.executorService.submit(new NioLoop(this.socketChannelFrameHandlerFactory.nioParams, this));
        }
    }

    protected boolean cleanUp() {
        int n2 = this.readSelectorState.registrations.size();
        if (n2 != 0) {
            return false;
        }
        this.socketChannelFrameHandlerFactory.lock();
        try {
            if (n2 != this.readSelectorState.registrations.size()) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                this.readSelectorState.selector.close();
            }
            catch (IOException iOException) {
                LOGGER.warn("Could not close read selector: {}", (Object)iOException.getMessage());
            }
            try {
                this.writeSelectorState.selector.close();
            }
            catch (IOException iOException) {
                LOGGER.warn("Could not close write selector: {}", (Object)iOException.getMessage());
            }
            this.readSelectorState = null;
            this.writeSelectorState = null;
        }
        finally {
            this.socketChannelFrameHandlerFactory.unlock();
        }
        return true;
    }
}

