/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.AMQP;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.BuiltinExchangeType;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Channel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Command;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConfirmListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Connection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Consumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.FlowListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.GetResponse;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.Method;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.RecoverableChannel;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.RecoveryListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ReturnListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownListener;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ShutdownSignalException;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQCommand;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.recovery.RecoveryAwareChannelN;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;

public class AutorecoveringChannel
implements RecoverableChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutorecoveringChannel.class);
    private volatile RecoveryAwareChannelN delegate;
    private volatile AutorecoveringConnection connection;
    private final List<ShutdownListener> shutdownHooks = new CopyOnWriteArrayList<ShutdownListener>();
    private final List<RecoveryListener> recoveryListeners = new CopyOnWriteArrayList<RecoveryListener>();
    private final List<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private final List<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private final List<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private final Set<String> consumerTags = Collections.synchronizedSet(new HashSet());
    private int prefetchCountConsumer;
    private int prefetchCountGlobal;
    private boolean usesPublisherConfirms;
    private boolean usesTransactions;

    public AutorecoveringChannel(AutorecoveringConnection autorecoveringConnection, RecoveryAwareChannelN recoveryAwareChannelN) {
        this.connection = autorecoveringConnection;
        this.delegate = recoveryAwareChannelN;
    }

    @Override
    public int getChannelNumber() {
        return this.delegate.getChannelNumber();
    }

    @Override
    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    public Channel getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() throws IOException, TimeoutException {
        try {
            this.delegate.close();
        }
        finally {
            for (String string : this.consumerTags) {
                this.connection.deleteRecordedConsumer(string);
            }
            this.connection.unregisterChannel(this);
        }
    }

    @Override
    public void close(int n2, String string) throws IOException, TimeoutException {
        try {
            this.delegate.close(n2, string);
        }
        finally {
            this.connection.unregisterChannel(this);
        }
    }

    @Override
    @Deprecated
    public boolean flowBlocked() {
        return this.delegate.flowBlocked();
    }

    @Override
    public void abort() throws IOException {
        this.delegate.abort();
    }

    @Override
    public void abort(int n2, String string) throws IOException {
        this.delegate.abort(n2, string);
    }

    @Override
    public void addReturnListener(ReturnListener returnListener) {
        this.returnListeners.add(returnListener);
        this.delegate.addReturnListener(returnListener);
    }

    @Override
    public boolean removeReturnListener(ReturnListener returnListener) {
        this.returnListeners.remove(returnListener);
        return this.delegate.removeReturnListener(returnListener);
    }

    @Override
    public void clearReturnListeners() {
        this.returnListeners.clear();
        this.delegate.clearReturnListeners();
    }

    @Override
    @Deprecated
    public void addFlowListener(FlowListener flowListener) {
        this.flowListeners.add(flowListener);
        this.delegate.addFlowListener(flowListener);
    }

    @Override
    @Deprecated
    public boolean removeFlowListener(FlowListener flowListener) {
        this.flowListeners.remove(flowListener);
        return this.delegate.removeFlowListener(flowListener);
    }

    @Override
    @Deprecated
    public void clearFlowListeners() {
        this.flowListeners.clear();
        this.delegate.clearFlowListeners();
    }

    @Override
    public void addConfirmListener(ConfirmListener confirmListener) {
        this.confirmListeners.add(confirmListener);
        this.delegate.addConfirmListener(confirmListener);
    }

    @Override
    public boolean removeConfirmListener(ConfirmListener confirmListener) {
        this.confirmListeners.remove(confirmListener);
        return this.delegate.removeConfirmListener(confirmListener);
    }

    @Override
    public void clearConfirmListeners() {
        this.confirmListeners.clear();
        this.delegate.clearConfirmListeners();
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.delegate.getDefaultConsumer();
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.delegate.setDefaultConsumer(consumer);
    }

    @Override
    public void basicQos(int n2, int n3, boolean bl2) throws IOException {
        if (bl2) {
            this.prefetchCountGlobal = n3;
        } else {
            this.prefetchCountConsumer = n3;
        }
        this.delegate.basicQos(n2, n3, bl2);
    }

    @Override
    public void basicQos(int n2) throws IOException {
        this.basicQos(0, n2, false);
    }

    @Override
    public void basicQos(int n2, boolean bl2) throws IOException {
        this.basicQos(0, n2, bl2);
    }

    @Override
    public void basicPublish(String string, String string2, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.delegate.basicPublish(string, string2, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string, String string2, boolean bl2, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.delegate.basicPublish(string, string2, bl2, basicProperties, byArray);
    }

    @Override
    public void basicPublish(String string, String string2, boolean bl2, boolean bl3, AMQP.BasicProperties basicProperties, byte[] byArray) throws IOException {
        this.delegate.basicPublish(string, string2, bl2, bl3, basicProperties, byArray);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, String string2) throws IOException {
        return this.exchangeDeclare(string, string2, false, false, null);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType());
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2) throws IOException {
        return this.exchangeDeclare(string, string2, bl2, false, null);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2, boolean bl3, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, string2, bl2, bl3, false, map);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2, bl3, map);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, String string2, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        AMQP.Exchange.DeclareOk declareOk = this.delegate.exchangeDeclare(string, string2, bl2, bl3, bl4, (Map)map);
        this.recordExchange(declareOk, string, string2, bl2, bl3, map);
        return declareOk;
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclare(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        return this.exchangeDeclare(string, builtinExchangeType.getType(), bl2, bl3, bl4, map);
    }

    @Override
    public void exchangeDeclareNoWait(String string, String string2, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        RecordedExchange recordedExchange = new RecordedExchange(this, string).type(string2).durable(bl2).autoDelete(bl3).arguments(map);
        this.recordExchange(string, recordedExchange);
        this.delegate.exchangeDeclareNoWait(string, string2, bl2, bl3, bl4, map);
    }

    @Override
    public void exchangeDeclareNoWait(String string, BuiltinExchangeType builtinExchangeType, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        this.exchangeDeclareNoWait(string, builtinExchangeType.getType(), bl2, bl3, bl4, map);
    }

    @Override
    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String string) throws IOException {
        return this.delegate.exchangeDeclarePassive(string);
    }

    @Override
    public AMQP.Exchange.DeleteOk exchangeDelete(String string, boolean bl2) throws IOException {
        this.deleteRecordedExchange(string);
        return this.delegate.exchangeDelete(string, bl2);
    }

    @Override
    public void exchangeDeleteNoWait(String string, boolean bl2) throws IOException {
        this.deleteRecordedExchange(string);
        this.delegate.exchangeDeleteNoWait(string, bl2);
    }

    @Override
    public AMQP.Exchange.DeleteOk exchangeDelete(String string) throws IOException {
        return this.exchangeDelete(string, false);
    }

    @Override
    public AMQP.Exchange.BindOk exchangeBind(String string, String string2, String string3) throws IOException {
        return this.exchangeBind(string, string2, string3, null);
    }

    @Override
    public AMQP.Exchange.BindOk exchangeBind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        AMQP.Exchange.BindOk bindOk = this.delegate.exchangeBind(string, string2, string3, (Map)map);
        this.recordExchangeBinding(string, string2, string3, map);
        return bindOk;
    }

    @Override
    public void exchangeBindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.delegate.exchangeBindNoWait(string, string2, string3, map);
        this.recordExchangeBinding(string, string2, string3, map);
    }

    @Override
    public AMQP.Exchange.UnbindOk exchangeUnbind(String string, String string2, String string3) throws IOException {
        return this.exchangeUnbind(string, string2, string3, null);
    }

    @Override
    public AMQP.Exchange.UnbindOk exchangeUnbind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.deleteRecordedExchangeBinding(string, string2, string3, map);
        this.maybeDeleteRecordedAutoDeleteExchange(string2);
        return this.delegate.exchangeUnbind(string, string2, string3, (Map)map);
    }

    @Override
    public void exchangeUnbindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.delegate.exchangeUnbindNoWait(string, string2, string3, map);
        this.deleteRecordedExchangeBinding(string, string2, string3, map);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare("", false, true, true, null);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare(String string, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        AMQP.Queue.DeclareOk declareOk = this.delegate.queueDeclare(string, bl2, bl3, bl4, (Map)map);
        this.recordQueue(declareOk, string, bl2, bl3, bl4, map);
        return declareOk;
    }

    @Override
    public void queueDeclareNoWait(String string, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) throws IOException {
        RecordedQueue recordedQueue = new RecordedQueue(this, string).durable(bl2).exclusive(bl3).autoDelete(bl4).arguments(map);
        this.delegate.queueDeclareNoWait(string, bl2, bl3, bl4, map);
        this.recordQueue(string, recordedQueue);
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclarePassive(String string) throws IOException {
        return this.delegate.queueDeclarePassive(string);
    }

    @Override
    public long messageCount(String string) throws IOException {
        return this.delegate.messageCount(string);
    }

    @Override
    public long consumerCount(String string) throws IOException {
        return this.delegate.consumerCount(string);
    }

    @Override
    public AMQP.Queue.DeleteOk queueDelete(String string) throws IOException {
        return this.queueDelete(string, false, false);
    }

    @Override
    public AMQP.Queue.DeleteOk queueDelete(String string, boolean bl2, boolean bl3) throws IOException {
        this.deleteRecordedQueue(string);
        return this.delegate.queueDelete(string, bl2, bl3);
    }

    @Override
    public void queueDeleteNoWait(String string, boolean bl2, boolean bl3) throws IOException {
        this.deleteRecordedQueue(string);
        this.delegate.queueDeleteNoWait(string, bl2, bl3);
    }

    @Override
    public AMQP.Queue.BindOk queueBind(String string, String string2, String string3) throws IOException {
        return this.queueBind(string, string2, string3, null);
    }

    @Override
    public AMQP.Queue.BindOk queueBind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        AMQP.Queue.BindOk bindOk = this.delegate.queueBind(string, string2, string3, (Map)map);
        this.recordQueueBinding(string, string2, string3, map);
        return bindOk;
    }

    @Override
    public void queueBindNoWait(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.delegate.queueBindNoWait(string, string2, string3, map);
        this.recordQueueBinding(string, string2, string3, map);
    }

    @Override
    public AMQP.Queue.UnbindOk queueUnbind(String string, String string2, String string3) throws IOException {
        return this.queueUnbind(string, string2, string3, null);
    }

    @Override
    public AMQP.Queue.UnbindOk queueUnbind(String string, String string2, String string3, Map<String, Object> map) throws IOException {
        this.deleteRecordedQueueBinding(string, string2, string3, map);
        this.maybeDeleteRecordedAutoDeleteExchange(string2);
        return this.delegate.queueUnbind(string, string2, string3, (Map)map);
    }

    @Override
    public AMQP.Queue.PurgeOk queuePurge(String string) throws IOException {
        return this.delegate.queuePurge(string);
    }

    @Override
    public GetResponse basicGet(String string, boolean bl2) throws IOException {
        return this.delegate.basicGet(string, bl2);
    }

    @Override
    public void basicAck(long l2, boolean bl2) throws IOException {
        this.delegate.basicAck(l2, bl2);
    }

    @Override
    public void basicNack(long l2, boolean bl2, boolean bl3) throws IOException {
        this.delegate.basicNack(l2, bl2, bl3);
    }

    @Override
    public void basicReject(long l2, boolean bl2) throws IOException {
        this.delegate.basicReject(l2, bl2);
    }

    @Override
    public String basicConsume(String string, Consumer consumer) throws IOException {
        return this.basicConsume(string, false, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, "", consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, String string2, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, string2, false, false, null, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, Map<String, Object> map, Consumer consumer) throws IOException {
        return this.basicConsume(string, bl2, "", false, false, map, consumer);
    }

    @Override
    public String basicConsume(String string, boolean bl2, String string2, boolean bl3, boolean bl4, Map<String, Object> map, Consumer consumer) throws IOException {
        String string3 = this.delegate.basicConsume(string, bl2, string2, bl3, bl4, map, consumer);
        this.recordConsumer(string3, string, bl2, bl4, map, consumer);
        return string3;
    }

    @Override
    public void basicCancel(String string) throws IOException {
        RecordedConsumer recordedConsumer = this.deleteRecordedConsumer(string);
        if (recordedConsumer != null) {
            this.maybeDeleteRecordedAutoDeleteQueue(recordedConsumer.getQueue());
        }
        this.delegate.basicCancel(string);
    }

    @Override
    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.delegate.basicRecover();
    }

    @Override
    public AMQP.Basic.RecoverOk basicRecover(boolean bl2) throws IOException {
        return this.delegate.basicRecover(bl2);
    }

    @Override
    public AMQP.Tx.SelectOk txSelect() throws IOException {
        this.usesTransactions = true;
        return this.delegate.txSelect();
    }

    @Override
    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.delegate.txCommit();
    }

    @Override
    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.delegate.txRollback();
    }

    @Override
    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        this.usesPublisherConfirms = true;
        return this.delegate.confirmSelect();
    }

    @Override
    public long getNextPublishSeqNo() {
        return this.delegate.getNextPublishSeqNo();
    }

    @Override
    public boolean waitForConfirms() throws InterruptedException {
        return this.delegate.waitForConfirms();
    }

    @Override
    public boolean waitForConfirms(long l2) throws InterruptedException, TimeoutException {
        return this.delegate.waitForConfirms(l2);
    }

    @Override
    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.delegate.waitForConfirmsOrDie();
    }

    @Override
    public void waitForConfirmsOrDie(long l2) throws IOException, InterruptedException, TimeoutException {
        this.delegate.waitForConfirmsOrDie(l2);
    }

    @Override
    public void asyncRpc(Method method) throws IOException {
        this.delegate.asyncRpc(method);
    }

    @Override
    public Command rpc(Method method) throws IOException {
        this.recordOnRpcRequest(method);
        AMQCommand aMQCommand = this.delegate.rpc(method);
        this.recordOnRpcResponse(aMQCommand.getMethod(), method);
        return aMQCommand;
    }

    @Override
    public void addShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownHooks.add(shutdownListener);
        this.delegate.addShutdownListener(shutdownListener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownHooks.remove(shutdownListener);
        this.delegate.removeShutdownListener(shutdownListener);
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void addRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListeners.add(recoveryListener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListeners.remove(recoveryListener);
    }

    public void automaticallyRecover(AutorecoveringConnection autorecoveringConnection, Connection connection) throws IOException {
        RecoveryAwareChannelN recoveryAwareChannelN = this.delegate;
        this.connection = autorecoveringConnection;
        RecoveryAwareChannelN recoveryAwareChannelN2 = (RecoveryAwareChannelN)connection.createChannel(this.getChannelNumber());
        if (recoveryAwareChannelN2 == null) {
            throw new IOException("Failed to create new channel for channel number=" + this.getChannelNumber() + " during recovery");
        }
        recoveryAwareChannelN2.inheritOffsetFrom(recoveryAwareChannelN);
        this.delegate = recoveryAwareChannelN2;
        this.notifyRecoveryListenersStarted();
        this.recoverShutdownListeners();
        this.recoverReturnListeners();
        this.recoverConfirmListeners();
        this.recoverFlowListeners();
        this.recoverState();
        this.notifyRecoveryListenersComplete();
    }

    private void recoverShutdownListeners() {
        for (ShutdownListener shutdownListener : this.shutdownHooks) {
            this.delegate.addShutdownListener(shutdownListener);
        }
    }

    private void recoverReturnListeners() {
        for (ReturnListener returnListener : this.returnListeners) {
            this.delegate.addReturnListener(returnListener);
        }
    }

    private void recoverConfirmListeners() {
        for (ConfirmListener confirmListener : this.confirmListeners) {
            this.delegate.addConfirmListener(confirmListener);
        }
    }

    @Deprecated
    private void recoverFlowListeners() {
        for (FlowListener flowListener : this.flowListeners) {
            this.delegate.addFlowListener(flowListener);
        }
    }

    private void recoverState() throws IOException {
        if (this.prefetchCountConsumer != 0) {
            this.basicQos(this.prefetchCountConsumer, false);
        }
        if (this.prefetchCountGlobal != 0) {
            this.basicQos(this.prefetchCountGlobal, true);
        }
        if (this.usesPublisherConfirms) {
            this.confirmSelect();
        }
        if (this.usesTransactions) {
            this.txSelect();
        }
    }

    private void notifyRecoveryListenersComplete() {
        for (RecoveryListener recoveryListener : this.recoveryListeners) {
            recoveryListener.handleRecovery(this);
        }
    }

    private void notifyRecoveryListenersStarted() {
        for (RecoveryListener recoveryListener : this.recoveryListeners) {
            recoveryListener.handleRecoveryStarted(this);
        }
    }

    private void recordQueueBinding(String string, String string2, String string3, Map<String, Object> map) {
        this.connection.recordQueueBinding(this, string, string2, string3, map);
    }

    private boolean deleteRecordedQueueBinding(String string, String string2, String string3, Map<String, Object> map) {
        return this.connection.deleteRecordedQueueBinding(this, string, string2, string3, map);
    }

    private void recordExchangeBinding(String string, String string2, String string3, Map<String, Object> map) {
        this.connection.recordExchangeBinding(this, string, string2, string3, map);
    }

    private boolean deleteRecordedExchangeBinding(String string, String string2, String string3, Map<String, Object> map) {
        return this.connection.deleteRecordedExchangeBinding(this, string, string2, string3, map);
    }

    private void recordQueue(AMQP.Queue.DeclareOk declareOk, String string, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) {
        RecordedQueue recordedQueue = new RecordedQueue(this, declareOk.getQueue()).durable(bl2).exclusive(bl3).autoDelete(bl4).arguments(map);
        if (string.equals("")) {
            recordedQueue.serverNamed(true);
        }
        this.recordQueue(declareOk, recordedQueue);
    }

    private void recordQueue(AMQP.Queue.DeclareOk declareOk, RecordedQueue recordedQueue) {
        this.connection.recordQueue(declareOk, recordedQueue);
    }

    private void recordQueue(String string, RecordedQueue recordedQueue) {
        this.connection.recordQueue(string, recordedQueue);
    }

    private void deleteRecordedQueue(String string) {
        this.connection.deleteRecordedQueue(string);
    }

    private void recordExchange(AMQP.Exchange.DeclareOk declareOk, String string, String string2, boolean bl2, boolean bl3, Map<String, Object> map) {
        RecordedExchange recordedExchange = new RecordedExchange(this, string).type(string2).durable(bl2).autoDelete(bl3).arguments(map);
        this.recordExchange(string, recordedExchange);
    }

    private void recordExchange(String string, RecordedExchange recordedExchange) {
        this.connection.recordExchange(string, recordedExchange);
    }

    private void deleteRecordedExchange(String string) {
        this.connection.deleteRecordedExchange(string);
    }

    private void recordConsumer(String string, String string2, boolean bl2, boolean bl3, Map<String, Object> map, Consumer consumer) {
        RecordedConsumer recordedConsumer = new RecordedConsumer(this, string2).autoAck(bl2).consumerTag(string).exclusive(bl3).arguments(map).consumer(consumer);
        this.consumerTags.add(string);
        this.connection.recordConsumer(string, recordedConsumer);
    }

    private RecordedConsumer deleteRecordedConsumer(String string) {
        this.consumerTags.remove(string);
        return this.connection.deleteRecordedConsumer(string);
    }

    private void maybeDeleteRecordedAutoDeleteQueue(String string) {
        this.connection.maybeDeleteRecordedAutoDeleteQueue(string);
    }

    private void maybeDeleteRecordedAutoDeleteExchange(String string) {
        this.connection.maybeDeleteRecordedAutoDeleteExchange(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConsumerTag(String string, String string2) {
        Set<String> set = this.consumerTags;
        synchronized (set) {
            this.consumerTags.remove(string);
            this.consumerTags.add(string2);
        }
    }

    private void recordOnRpcRequest(Method method) {
        if (method instanceof AMQP.Queue.Delete) {
            this.deleteRecordedQueue(((AMQP.Queue.Delete)method).getQueue());
        } else if (method instanceof AMQP.Exchange.Delete) {
            this.deleteRecordedExchange(((AMQP.Exchange.Delete)method).getExchange());
        } else if (method instanceof AMQP.Queue.Unbind) {
            AMQP.Queue.Unbind unbind = (AMQP.Queue.Unbind)method;
            this.deleteRecordedQueueBinding(unbind.getQueue(), unbind.getExchange(), unbind.getRoutingKey(), unbind.getArguments());
            this.maybeDeleteRecordedAutoDeleteExchange(unbind.getExchange());
        } else if (method instanceof AMQP.Exchange.Unbind) {
            AMQP.Exchange.Unbind unbind = (AMQP.Exchange.Unbind)method;
            this.deleteRecordedExchangeBinding(unbind.getDestination(), unbind.getSource(), unbind.getRoutingKey(), unbind.getArguments());
            this.maybeDeleteRecordedAutoDeleteExchange(unbind.getSource());
        }
    }

    private void recordOnRpcResponse(Method method, Method method2) {
        if (method instanceof AMQP.Queue.DeclareOk) {
            if (method2 instanceof AMQP.Queue.Declare) {
                AMQP.Queue.DeclareOk declareOk = (AMQP.Queue.DeclareOk)method;
                AMQP.Queue.Declare declare = (AMQP.Queue.Declare)method2;
                this.recordQueue(declareOk, declare.getQueue(), declare.getDurable(), declare.getExclusive(), declare.getAutoDelete(), declare.getArguments());
            } else {
                LOGGER.warn("RPC response {} and RPC request {} not compatible, topology not recorded.", (Object)method.getClass(), (Object)method2.getClass());
            }
        } else if (method instanceof AMQP.Exchange.DeclareOk) {
            if (method2 instanceof AMQP.Exchange.Declare) {
                AMQP.Exchange.DeclareOk declareOk = (AMQP.Exchange.DeclareOk)method;
                AMQP.Exchange.Declare declare = (AMQP.Exchange.Declare)method2;
                this.recordExchange(declareOk, declare.getExchange(), declare.getType(), declare.getDurable(), declare.getAutoDelete(), declare.getArguments());
            } else {
                LOGGER.warn("RPC response {} and RPC request {} not compatible, topology not recorded.", (Object)method.getClass(), (Object)method2.getClass());
            }
        } else if (method instanceof AMQP.Queue.BindOk) {
            if (method2 instanceof AMQP.Queue.Bind) {
                AMQP.Queue.Bind bind = (AMQP.Queue.Bind)method2;
                this.recordQueueBinding(bind.getQueue(), bind.getExchange(), bind.getRoutingKey(), bind.getArguments());
            } else {
                LOGGER.warn("RPC response {} and RPC request {} not compatible, topology not recorded.", (Object)method.getClass(), (Object)method2.getClass());
            }
        } else if (method instanceof AMQP.Exchange.BindOk) {
            if (method2 instanceof AMQP.Exchange.Bind) {
                AMQP.Exchange.Bind bind = (AMQP.Exchange.Bind)method2;
                this.recordExchangeBinding(bind.getDestination(), bind.getSource(), bind.getRoutingKey(), bind.getArguments());
            } else {
                LOGGER.warn("RPC response {} and RPC request {} not compatible, topology not recorded.", (Object)method.getClass(), (Object)method2.getClass());
            }
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

