/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.utility;

import java.util.concurrent.TimeoutException;

public class BlockingCell<T> {
    private boolean _filled = false;
    private T _value;
    private static final long NANOS_IN_MILLI = 1000000L;
    private static final long INFINITY = -1L;

    public synchronized T get() throws InterruptedException {
        while (!this._filled) {
            this.wait();
        }
        return this._value;
    }

    public synchronized T get(long l2) throws InterruptedException, TimeoutException {
        if (l2 == -1L) {
            return this.get();
        }
        if (l2 < 0L) {
            throw new AssertionError((Object)"Timeout cannot be less than zero");
        }
        long l3 = System.nanoTime() / 1000000L;
        long l4 = l3 + l2;
        while (!this._filled && (l3 = System.nanoTime() / 1000000L) < l4) {
            this.wait(l4 - l3);
        }
        if (!this._filled) {
            throw new TimeoutException();
        }
        return this._value;
    }

    public synchronized T uninterruptibleGet() {
        boolean bl2 = false;
        while (true) {
            try {
                T t2 = this.get();
                return t2;
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                continue;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T uninterruptibleGet(int n2) throws TimeoutException {
        block7: {
            long l2 = System.nanoTime() / 1000000L;
            long l3 = l2 + (long)n2;
            boolean bl2 = false;
            while (true) {
                try {
                    T t2 = this.get(l3 - l2);
                    return t2;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    if ((long)n2 == -1L || (l2 = System.nanoTime() / 1000000L) < l3) continue;
                    break block7;
                }
                break;
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new TimeoutException();
    }

    public synchronized void set(T t2) {
        if (this._filled) {
            throw new AssertionError((Object)"BlockingCell can only be set once");
        }
        this._value = t2;
        this._filled = true;
        this.notifyAll();
    }

    public synchronized boolean setIfUnset(T t2) {
        if (this._filled) {
            return false;
        }
        this.set(t2);
        return true;
    }
}

