/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.FailurePolicyConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.PolicyBuilder;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedBiPredicate;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedPredicate;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class FailurePolicyBuilder<S, C extends FailurePolicyConfig<R>, R>
extends PolicyBuilder<S, C, R> {
    protected FailurePolicyBuilder(C c2) {
        super(c2);
    }

    public S handle(Class<? extends Throwable> clazz) {
        Assert.notNull(clazz, "exception");
        return this.handle(Arrays.asList(clazz));
    }

    @SafeVarargs
    public final S handle(Class<? extends Throwable> ... classArray) {
        Assert.notNull(classArray, "exceptions");
        Assert.isTrue(classArray.length > 0, "exceptions cannot be empty", new Object[0]);
        return this.handle(Arrays.asList(classArray));
    }

    public S handle(List<Class<? extends Throwable>> list) {
        Assert.notNull(list, "exceptions");
        Assert.isTrue(!list.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(list));
        return (S)this;
    }

    public S handleIf(CheckedPredicate<? extends Throwable> checkedPredicate) {
        Assert.notNull(checkedPredicate, "failurePredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(checkedPredicate));
        return (S)this;
    }

    public S handleIf(CheckedBiPredicate<R, ? extends Throwable> checkedBiPredicate) {
        Assert.notNull(checkedBiPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(checkedBiPredicate);
        return (S)this;
    }

    public S handleResult(R r2) {
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(r2));
        return (S)this;
    }

    public S handleResultIf(CheckedPredicate<R> checkedPredicate) {
        Assert.notNull(checkedPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(checkedPredicate));
        return (S)this;
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(R r2) {
        return (object2, throwable) -> r2 == null ? object2 == null && throwable == null : Objects.equals(r2, object2);
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(CheckedPredicate<? extends Throwable> checkedPredicate) {
        return (object, throwable) -> throwable != null && checkedPredicate.test((Throwable)throwable);
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(CheckedPredicate<R> checkedPredicate) {
        return (object, throwable) -> {
            if (throwable == null) {
                return checkedPredicate.test(object);
            }
            return false;
        };
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> list) {
        return (object, throwable) -> {
            if (throwable == null) {
                return false;
            }
            for (Class clazz : list) {
                if (!clazz.isAssignableFrom(throwable.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

