/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.FailsafeException;
import com.contrastsecurity.thirdparty.dev.failsafe.SyncExecutionImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.function.AsyncRunnable;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedConsumer;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedFunction;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedRunnable;
import com.contrastsecurity.thirdparty.dev.failsafe.function.CheckedSupplier;
import com.contrastsecurity.thirdparty.dev.failsafe.function.ContextualRunnable;
import com.contrastsecurity.thirdparty.dev.failsafe.function.ContextualSupplier;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.AsyncExecutionInternal;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailsafeFuture;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class Functions {
    Functions() {
    }

    static <R> Function<SyncExecutionImpl<R>, ExecutionResult<R>> get(ContextualSupplier<R, R> contextualSupplier, Executor executor) {
        return syncExecutionImpl -> {
            Object object;
            ExecutionResult<Object> executionResult;
            Throwable throwable = null;
            try {
                syncExecutionImpl.preExecute();
                executionResult = ExecutionResult.success(Functions.withExecutor(contextualSupplier, executor).get((ExecutionContext)syncExecutionImpl));
            }
            catch (Throwable throwable2) {
                Throwables.throwIfCritical(throwable2);
                object = throwable2;
                throwable = object;
                executionResult = ExecutionResult.exception((Throwable)object);
            }
            syncExecutionImpl.record(executionResult);
            object = syncExecutionImpl.getLock();
            synchronized (object) {
                syncExecutionImpl.setInterruptable(false);
                if (syncExecutionImpl.isInterrupted()) {
                    Thread.interrupted();
                    return syncExecutionImpl.getResult();
                }
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return executionResult;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromise(ContextualSupplier<R, R> contextualSupplier, Executor executor) {
        Assert.notNull(contextualSupplier, "supplier");
        return asyncExecutionInternal -> {
            ExecutionResult<Object> executionResult;
            try {
                asyncExecutionInternal.preExecute();
                executionResult = ExecutionResult.success(Functions.withExecutor(contextualSupplier, executor).get((ExecutionContext)asyncExecutionInternal));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                executionResult = ExecutionResult.exception(throwable2);
            }
            asyncExecutionInternal.record(executionResult);
            return CompletableFuture.completedFuture(executionResult);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseExecution(final AsyncRunnable<R> asyncRunnable, final Executor executor) {
        Assert.notNull(asyncRunnable, "runnable");
        return new Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>>(){

            @Override
            public synchronized CompletableFuture<ExecutionResult<R>> apply(AsyncExecutionInternal<R> asyncExecutionInternal) {
                try {
                    asyncExecutionInternal.preExecute();
                    Functions.withExecutor(asyncRunnable, executor).run(asyncExecutionInternal);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    asyncExecutionInternal.record(null, throwable2);
                }
                return ExecutionResult.nullFuture();
            }
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> contextualSupplier, FailsafeFuture<R> failsafeFuture, Executor executor) {
        Assert.notNull(contextualSupplier, "supplier");
        return asyncExecutionInternal -> {
            CompletableFuture completableFuture = new CompletableFuture();
            try {
                asyncExecutionInternal.preExecute();
                CompletionStage completionStage = (CompletionStage)Functions.withExecutor(contextualSupplier, executor).get((ExecutionContext)asyncExecutionInternal);
                if (completionStage == null) {
                    ExecutionResult<Object> executionResult = ExecutionResult.success(null);
                    asyncExecutionInternal.record(executionResult);
                    completableFuture.complete(executionResult);
                } else {
                    if (completionStage instanceof Future) {
                        failsafeFuture.propagateCancellation((Future)((Object)completionStage));
                    }
                    completionStage.whenComplete((object, throwable) -> {
                        if (throwable instanceof CompletionException) {
                            throwable = throwable.getCause();
                        }
                        ExecutionResult<Object> executionResult = throwable == null ? ExecutionResult.success(object) : ExecutionResult.exception(throwable);
                        asyncExecutionInternal.record(executionResult);
                        completableFuture.complete(executionResult);
                    });
                }
            }
            catch (Throwable throwable2) {
                Throwables.throwIfCritical(throwable2);
                Throwable throwable3 = throwable2;
                ExecutionResult executionResult = ExecutionResult.exception(throwable3);
                asyncExecutionInternal.record(executionResult);
                completableFuture.complete(executionResult);
            }
            return completableFuture;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toExecutionAware(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function) {
        return asyncExecutionInternal -> {
            ExecutionResult executionResult = asyncExecutionInternal.getResult();
            if (executionResult == null) {
                return (CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal);
            }
            return CompletableFuture.completedFuture(executionResult);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        return asyncExecutionInternal -> {
            if (atomicBoolean.get()) {
                return (CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal);
            }
            CompletableFuture completableFuture = new CompletableFuture();
            Callable<Object> callable = () -> ((CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal)).whenComplete((executionResult, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture.complete(executionResult);
                }
            });
            try {
                atomicBoolean.set(true);
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                failsafeFuture.setCancelFn(-1, (bl2, executionResult) -> {
                    scheduledFuture.cancel((boolean)bl2);
                    if (!asyncExecutionInternal.isPreExecuted()) {
                        completableFuture.complete(executionResult);
                    }
                });
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                completableFuture.completeExceptionally(throwable2);
            }
            return completableFuture;
        };
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(CheckedRunnable checkedRunnable) {
        Assert.notNull(checkedRunnable, "runnable");
        return executionContext -> {
            checkedRunnable.run();
            return null;
        };
    }

    static ContextualSupplier<Void, Void> toCtxSupplier(ContextualRunnable<Void> contextualRunnable) {
        Assert.notNull(contextualRunnable, "runnable");
        return executionContext -> {
            contextualRunnable.run(executionContext);
            return null;
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> checkedSupplier) {
        Assert.notNull(checkedSupplier, "supplier");
        return executionContext -> checkedSupplier.get();
    }

    static <R, T> ContextualSupplier<R, T> withExecutor(ContextualSupplier<R, T> contextualSupplier, Executor executor) {
        return executor == null ? contextualSupplier : executionContext -> {
            executor.execute(() -> {
                try {
                    contextualSupplier.get(executionContext);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    Functions.handleExecutorThrowable(throwable2);
                }
            });
            return null;
        };
    }

    static <R> AsyncRunnable<R> withExecutor(AsyncRunnable<R> asyncRunnable, Executor executor) {
        return executor == null ? asyncRunnable : asyncExecution -> executor.execute(() -> {
            try {
                asyncRunnable.run(asyncExecution);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                Functions.handleExecutorThrowable(throwable2);
            }
        });
    }

    private static void handleExecutorThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new FailsafeException(throwable);
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedConsumer<T> checkedConsumer) {
        return object -> {
            checkedConsumer.accept(object);
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedRunnable checkedRunnable) {
        return object -> {
            checkedRunnable.run();
            return null;
        };
    }

    static <T, R> CheckedFunction<T, R> toFn(CheckedSupplier<? extends R> checkedSupplier) {
        return object -> checkedSupplier.get();
    }

    static <T, R> CheckedFunction<T, R> toFn(R r2) {
        return object2 -> r2;
    }
}

