/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.Policy;
import com.contrastsecurity.thirdparty.dev.failsafe.TimeoutBuilder;
import com.contrastsecurity.thirdparty.dev.failsafe.TimeoutConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.TimeoutImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public interface Timeout<R>
extends Policy<R> {
    public static <R> TimeoutBuilder<R> builder(Duration duration) {
        Assert.notNull(duration, "timeout");
        Assert.isTrue(duration.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new TimeoutBuilder(duration);
    }

    public static <R> TimeoutBuilder<R> builder(TimeoutConfig<R> timeoutConfig) {
        return new TimeoutBuilder<R>(timeoutConfig);
    }

    public static <R> Timeout<R> of(Duration duration) {
        return new TimeoutImpl(new TimeoutConfig(duration, false));
    }

    @Override
    public TimeoutConfig<R> getConfig();
}

