/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.EventListener;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerExecutor;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitState;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.ClosedState;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.HalfOpenState;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.OpenState;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.DelayablePolicy;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.FailurePolicy;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;

public class CircuitBreakerImpl<R>
implements CircuitBreaker<R>,
DelayablePolicy<R>,
FailurePolicy<R> {
    private final CircuitBreakerConfig<R> config;
    protected final AtomicReference<CircuitState<R>> state = new AtomicReference();

    public CircuitBreakerImpl(CircuitBreakerConfig<R> circuitBreakerConfig) {
        this.config = circuitBreakerConfig;
        this.state.set(new ClosedState(this));
    }

    @Override
    public CircuitBreakerConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public boolean tryAcquirePermit() {
        return this.state.get().tryAcquirePermit();
    }

    @Override
    public void close() {
        this.transitionTo(CircuitBreaker.State.CLOSED, this.config.getCloseListener(), null);
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.state.get().getState();
    }

    @Override
    public int getExecutionCount() {
        return this.state.get().getStats().getExecutionCount();
    }

    @Override
    public Duration getRemainingDelay() {
        return this.state.get().getRemainingDelay();
    }

    @Override
    public long getFailureCount() {
        return this.state.get().getStats().getFailureCount();
    }

    @Override
    public int getFailureRate() {
        return this.state.get().getStats().getFailureRate();
    }

    @Override
    public int getSuccessCount() {
        return this.state.get().getStats().getSuccessCount();
    }

    @Override
    public int getSuccessRate() {
        return this.state.get().getStats().getSuccessRate();
    }

    @Override
    public void halfOpen() {
        this.transitionTo(CircuitBreaker.State.HALF_OPEN, this.config.getHalfOpenListener(), null);
    }

    @Override
    public boolean isClosed() {
        return CircuitBreaker.State.CLOSED.equals((Object)this.getState());
    }

    @Override
    public boolean isHalfOpen() {
        return CircuitBreaker.State.HALF_OPEN.equals((Object)this.getState());
    }

    @Override
    public boolean isOpen() {
        return CircuitBreaker.State.OPEN.equals((Object)this.getState());
    }

    @Override
    public void open() {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), null);
    }

    @Override
    public void recordFailure() {
        this.recordExecutionFailure(null);
    }

    @Override
    public void recordException(Throwable throwable) {
        this.recordResult(null, throwable);
    }

    @Override
    @Deprecated
    public void recordFailure(Throwable throwable) {
        this.recordException(throwable);
    }

    @Override
    public void recordResult(R r2) {
        this.recordResult(r2, null);
    }

    @Override
    public void recordSuccess() {
        this.state.get().recordSuccess();
    }

    public String toString() {
        return this.getState().toString();
    }

    protected void recordResult(R r2, Throwable throwable) {
        if (this.isFailure(r2, throwable)) {
            this.state.get().recordFailure(null);
        } else {
            this.state.get().recordSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionTo(CircuitBreaker.State state, EventListener<CircuitBreakerStateChangedEvent> eventListener, ExecutionContext<R> executionContext) {
        CircuitBreaker.State state2;
        boolean bl2 = false;
        Object object = this;
        synchronized (object) {
            state2 = this.getState();
            if (!this.getState().equals((Object)state)) {
                switch (state) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this));
                        break;
                    }
                    case OPEN: {
                        Duration duration = this.computeDelay(executionContext);
                        this.state.set(new OpenState<R>(this, this.state.get(), duration != null ? duration : this.config.getDelay()));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this));
                    }
                }
                bl2 = true;
            }
        }
        if (bl2 && eventListener != null) {
            try {
                eventListener.accept(new CircuitBreakerStateChangedEvent(state2));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                object = throwable;
            }
        }
    }

    protected void recordExecutionFailure(ExecutionContext<R> executionContext) {
        this.state.get().recordFailure(executionContext);
    }

    protected void open(ExecutionContext<R> executionContext) {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), executionContext);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int n2) {
        return new CircuitBreakerExecutor(this, n2);
    }
}

