/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitBreakerImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CircuitStats;
import java.time.Duration;

abstract class CircuitState<R> {
    final CircuitBreakerImpl<R> breaker;
    final CircuitBreakerConfig<R> config;
    volatile CircuitStats stats;

    CircuitState(CircuitBreakerImpl<R> circuitBreakerImpl, CircuitStats circuitStats) {
        this.breaker = circuitBreakerImpl;
        this.config = circuitBreakerImpl.getConfig();
        this.stats = circuitStats;
    }

    public Duration getRemainingDelay() {
        return Duration.ZERO;
    }

    public CircuitStats getStats() {
        return this.stats;
    }

    public abstract CircuitBreaker.State getState();

    public synchronized void recordFailure(ExecutionContext<R> executionContext) {
        this.stats.recordFailure();
        this.checkThreshold(executionContext);
        this.releasePermit();
    }

    public synchronized void recordSuccess() {
        this.stats.recordSuccess();
        this.checkThreshold(null);
        this.releasePermit();
    }

    public void handleConfigChange() {
    }

    void checkThreshold(ExecutionContext<R> executionContext) {
    }

    abstract boolean tryAcquirePermit();

    void releasePermit() {
    }
}

