/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreaker;
import com.contrastsecurity.thirdparty.dev.failsafe.CircuitBreakerConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.CountingCircuitStats;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.DefaultCircuitStats;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.TimedCircuitStats;

interface CircuitStats {
    public static CircuitStats create(CircuitBreaker<?> circuitBreaker, int n2, boolean bl2, CircuitStats circuitStats) {
        if (bl2 && ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureThresholdingPeriod() != null) {
            return new TimedCircuitStats(10, ((CircuitBreakerConfig)circuitBreaker.getConfig()).getFailureThresholdingPeriod(), new TimedCircuitStats.Clock(), circuitStats);
        }
        if (n2 > 1) {
            return new CountingCircuitStats(n2, circuitStats);
        }
        return new DefaultCircuitStats();
    }

    default public void copyExecutions(CircuitStats circuitStats) {
        int n2;
        for (n2 = 0; n2 < circuitStats.getSuccessCount(); ++n2) {
            this.recordSuccess();
        }
        for (n2 = 0; n2 < circuitStats.getFailureCount(); ++n2) {
            this.recordFailure();
        }
    }

    public int getFailureCount();

    public int getExecutionCount();

    public int getSuccessCount();

    public int getFailureRate();

    public int getSuccessRate();

    public void recordFailure();

    public void recordSuccess();

    public void reset();
}

