/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe.internal;

import com.contrastsecurity.thirdparty.dev.failsafe.ExecutionContext;
import com.contrastsecurity.thirdparty.dev.failsafe.event.EventListener;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionAttemptedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionCompletedEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.event.ExecutionScheduledEvent;
import com.contrastsecurity.thirdparty.dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionCompletedEvent(executionResult.getResult(), executionResult.getException(), executionContext));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionAttemptedEvent(executionResult.getResult(), executionResult.getException(), executionContext));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> eventListener) {
        return eventListener == null ? null : (executionResult, executionContext) -> eventListener.acceptUnchecked(new ExecutionScheduledEvent(executionResult.getResult(), executionResult.getException(), Duration.ofNanos(executionResult.getDelay()), executionContext));
    }
}

