/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicAutomata;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.MinimizationOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.ShuffleOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.SpecialOperations;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.StatePair;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Automaton
implements Serializable,
Cloneable {
    static final long serialVersionUID = 10001L;
    public static final int MINIMIZE_HUFFMAN = 0;
    public static final int MINIMIZE_BRZOZOWSKI = 1;
    public static final int MINIMIZE_HOPCROFT = 2;
    public static final int MINIMIZE_VALMARI = 3;
    static int minimization = 2;
    State initial = new State();
    boolean deterministic = true;
    transient Object info;
    int hash_code;
    String singleton = null;
    static boolean minimize_always = false;
    static boolean allow_mutation = false;
    static Boolean is_debug = null;

    boolean isDebug() {
        if (is_debug == null) {
            is_debug = System.getProperty("com.contrastsecurity.thirdparty.dk.brics.automaton.debug") != null;
        }
        return is_debug;
    }

    public static void setMinimization(int n2) {
        minimization = n2;
    }

    public static void setMinimizeAlways(boolean bl2) {
        minimize_always = bl2;
    }

    public static boolean setAllowMutate(boolean bl2) {
        boolean bl3 = allow_mutation;
        allow_mutation = bl2;
        return bl3;
    }

    static boolean getAllowMutate() {
        return allow_mutation;
    }

    void checkMinimizeAlways() {
        if (minimize_always) {
            this.minimize();
        }
    }

    boolean isSingleton() {
        return this.singleton != null;
    }

    public String getSingleton() {
        return this.singleton;
    }

    public void setInitialState(State state) {
        this.initial = state;
        this.singleton = null;
    }

    public State getInitialState() {
        this.expandSingleton();
        return this.initial;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean bl2) {
        this.deterministic = bl2;
    }

    public void setInfo(Object object) {
        this.info = object;
    }

    public Object getInfo() {
        return this.info;
    }

    public Set<State> getStates() {
        this.expandSingleton();
        HashSet hashSet = this.isDebug() ? new LinkedHashSet() : new HashSet();
        LinkedList<State> linkedList = new LinkedList<State>();
        linkedList.add(this.initial);
        hashSet.add(this.initial);
        while (linkedList.size() > 0) {
            State state = (State)linkedList.removeFirst();
            Collection<Transition> collection = this.isDebug() ? state.getSortedTransitions(false) : state.transitions;
            for (Transition transition : collection) {
                if (hashSet.contains(transition.to)) continue;
                hashSet.add(transition.to);
                linkedList.add(transition.to);
            }
        }
        return hashSet;
    }

    public Set<State> getAcceptStates() {
        this.expandSingleton();
        HashSet<State> hashSet = new HashSet<State>();
        HashSet<State> hashSet2 = new HashSet<State>();
        LinkedList<State> linkedList = new LinkedList<State>();
        linkedList.add(this.initial);
        hashSet2.add(this.initial);
        while (linkedList.size() > 0) {
            State state = (State)linkedList.removeFirst();
            if (state.accept) {
                hashSet.add(state);
            }
            for (Transition transition : state.transitions) {
                if (hashSet2.contains(transition.to)) continue;
                hashSet2.add(transition.to);
                linkedList.add(transition.to);
            }
        }
        return hashSet;
    }

    static void setStateNumbers(Set<State> set) {
        if (set.size() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("number of states exceeded Integer.MAX_VALUE");
        }
        int n2 = 0;
        for (State state : set) {
            state.number = n2++;
        }
    }

    void totalize() {
        State state = new State();
        state.transitions.add(new Transition('\u0000', '\uffff', state));
        for (State state2 : this.getStates()) {
            int n2 = 0;
            for (Transition transition : state2.getSortedTransitions(false)) {
                if (transition.min > n2) {
                    state2.transitions.add(new Transition((char)n2, (char)(transition.min - '\u0001'), state));
                }
                if (transition.max + '\u0001' <= n2) continue;
                n2 = transition.max + '\u0001';
            }
            if (n2 > 65535) continue;
            state2.transitions.add(new Transition((char)n2, '\uffff', state));
        }
    }

    public void restoreInvariant() {
        this.removeDeadTransitions();
    }

    public void reduce() {
        if (this.isSingleton()) {
            return;
        }
        Set<State> set = this.getStates();
        Automaton.setStateNumbers(set);
        for (State state : set) {
            List<Transition> list = state.getSortedTransitions(true);
            state.resetTransitions();
            State state2 = null;
            int n2 = -1;
            char c2 = '\uffffffff';
            for (Transition transition : list) {
                if (state2 == transition.to) {
                    if (transition.min <= c2 + 1) {
                        if (transition.max <= c2) continue;
                        c2 = transition.max;
                        continue;
                    }
                    if (state2 != null) {
                        state.transitions.add(new Transition((char)n2, c2, state2));
                    }
                    n2 = transition.min;
                    c2 = transition.max;
                    continue;
                }
                if (state2 != null) {
                    state.transitions.add(new Transition((char)n2, c2, state2));
                }
                state2 = transition.to;
                n2 = transition.min;
                c2 = transition.max;
            }
            if (state2 == null) continue;
            state.transitions.add(new Transition((char)n2, c2, state2));
        }
        this.clearHashCode();
    }

    char[] getStartPoints() {
        HashSet<Character> hashSet = new HashSet<Character>();
        hashSet.add(Character.valueOf('\u0000'));
        for (State state : this.getStates()) {
            for (Transition serializable : state.transitions) {
                hashSet.add(Character.valueOf(serializable.min));
                if (serializable.max >= '\uffff') continue;
                hashSet.add(Character.valueOf((char)(serializable.max + '\u0001')));
            }
        }
        Object object = new char[hashSet.size()];
        int n2 = 0;
        for (Character c2 : hashSet) {
            object[n2++] = c2.charValue();
        }
        Arrays.sort((char[])object);
        return object;
    }

    public Set<State> getLiveStates() {
        this.expandSingleton();
        return this.getLiveStates(this.getStates());
    }

    private Set<State> getLiveStates(Set<State> set) {
        HashMap hashMap = new HashMap();
        for (State serializable2 : set) {
            hashMap.put(serializable2, new HashSet());
        }
        for (State state : set) {
            for (Transition transition : state.transitions) {
                ((Set)hashMap.get(transition.to)).add(state);
            }
        }
        HashSet<State> hashSet = new HashSet<State>(this.getAcceptStates());
        LinkedList<State> linkedList = new LinkedList<State>(hashSet);
        while (linkedList.size() > 0) {
            State state = (State)linkedList.removeFirst();
            for (State state2 : (Set)hashMap.get(state)) {
                if (hashSet.contains(state2)) continue;
                hashSet.add(state2);
                linkedList.add(state2);
            }
        }
        return hashSet;
    }

    public void removeDeadTransitions() {
        this.clearHashCode();
        if (this.isSingleton()) {
            return;
        }
        Set<State> set = this.getStates();
        Set<State> set2 = this.getLiveStates(set);
        for (State state : set) {
            Set<Transition> set3 = state.transitions;
            state.resetTransitions();
            for (Transition transition : set3) {
                if (!set2.contains(transition.to)) continue;
                state.transitions.add(transition);
            }
        }
        this.reduce();
    }

    static Transition[][] getSortedTransitions(Set<State> set) {
        Automaton.setStateNumbers(set);
        Transition[][] transitionArray = new Transition[set.size()][];
        for (State state : set) {
            transitionArray[state.number] = state.getSortedTransitionArray(false);
        }
        return transitionArray;
    }

    public void expandSingleton() {
        if (this.isSingleton()) {
            State state;
            this.initial = state = new State();
            for (int i2 = 0; i2 < this.singleton.length(); ++i2) {
                State state2 = new State();
                state2.number = i2;
                state.transitions.add(new Transition(this.singleton.charAt(i2), state2));
                state = state2;
            }
            state.accept = true;
            this.deterministic = true;
            this.singleton = null;
        }
    }

    public int getNumberOfStates() {
        if (this.isSingleton()) {
            return this.singleton.length() + 1;
        }
        return this.getStates().size();
    }

    public int getNumberOfTransitions() {
        if (this.isSingleton()) {
            return this.singleton.length();
        }
        int n2 = 0;
        for (State state : this.getStates()) {
            n2 += state.transitions.size();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Automaton)) {
            return false;
        }
        Automaton automaton = (Automaton)object;
        if (this.isSingleton() && automaton.isSingleton()) {
            return this.singleton.equals(automaton.singleton);
        }
        return this.hashCode() == automaton.hashCode() && this.subsetOf(automaton) && automaton.subsetOf(this);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.minimize();
        }
        return this.hash_code;
    }

    void recomputeHashCode() {
        this.hash_code = this.getNumberOfStates() * 3 + this.getNumberOfTransitions() * 2;
        if (this.hash_code == 0) {
            this.hash_code = 1;
        }
    }

    void clearHashCode() {
        this.hash_code = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSingleton()) {
            stringBuilder.append("singleton: ");
            for (char c2 : this.singleton.toCharArray()) {
                Transition.appendCharString(c2, stringBuilder);
            }
            stringBuilder.append("\n");
        } else {
            Set<State> set = this.getStates();
            Automaton.setStateNumbers(set);
            stringBuilder.append("initial state: ").append(this.initial.number).append("\n");
            for (State state : set) {
                stringBuilder.append(state.toString());
            }
        }
        return stringBuilder.toString();
    }

    public String toDot() {
        StringBuilder stringBuilder = new StringBuilder("digraph Automaton {\n");
        stringBuilder.append("  rankdir = LR;\n");
        Set<State> set = this.getStates();
        Automaton.setStateNumbers(set);
        for (State state : set) {
            stringBuilder.append("  ").append(state.number);
            if (state.accept) {
                stringBuilder.append(" [shape=doublecircle,label=\"\"];\n");
            } else {
                stringBuilder.append(" [shape=circle,label=\"\"];\n");
            }
            if (state == this.initial) {
                stringBuilder.append("  initial [shape=plaintext,label=\"\"];\n");
                stringBuilder.append("  initial -> ").append(state.number).append("\n");
            }
            for (Transition transition : state.transitions) {
                stringBuilder.append("  ").append(state.number);
                transition.appendDot(stringBuilder);
            }
        }
        return stringBuilder.append("}\n").toString();
    }

    Automaton cloneExpanded() {
        Automaton automaton = this.clone();
        automaton.expandSingleton();
        return automaton;
    }

    Automaton cloneExpandedIfRequired() {
        if (allow_mutation) {
            this.expandSingleton();
            return this;
        }
        return this.cloneExpanded();
    }

    public Automaton clone() {
        try {
            Automaton automaton = (Automaton)super.clone();
            if (!this.isSingleton()) {
                HashMap<State, State> hashMap = new HashMap<State, State>();
                Set<State> set = this.getStates();
                for (State state : set) {
                    hashMap.put(state, new State());
                }
                for (State state : set) {
                    State state2 = (State)hashMap.get(state);
                    state2.accept = state.accept;
                    if (state == this.initial) {
                        automaton.initial = state2;
                    }
                    for (Transition transition : state.transitions) {
                        state2.transitions.add(new Transition(transition.min, transition.max, (State)hashMap.get(transition.to)));
                    }
                }
            }
            return automaton;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    Automaton cloneIfRequired() {
        if (allow_mutation) {
            return this;
        }
        return this.clone();
    }

    public static Automaton load(URL uRL) throws IOException, ClassCastException, ClassNotFoundException {
        return Automaton.load(uRL.openStream());
    }

    public static Automaton load(InputStream inputStream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (Automaton)objectInputStream.readObject();
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static Automaton makeEmpty() {
        return BasicAutomata.makeEmpty();
    }

    public static Automaton makeEmptyString() {
        return BasicAutomata.makeEmptyString();
    }

    public static Automaton makeAnyString() {
        return BasicAutomata.makeAnyString();
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeAnyChar();
    }

    public static Automaton makeChar(char c2) {
        return BasicAutomata.makeChar(c2);
    }

    public static Automaton makeCharRange(char c2, char c3) {
        return BasicAutomata.makeCharRange(c2, c3);
    }

    public static Automaton makeCharSet(String string) {
        return BasicAutomata.makeCharSet(string);
    }

    public static Automaton makeInterval(int n2, int n3, int n4) throws IllegalArgumentException {
        return BasicAutomata.makeInterval(n2, n3, n4);
    }

    public static Automaton makeString(String string) {
        return BasicAutomata.makeString(string);
    }

    public static Automaton makeStringUnion(CharSequence ... charSequenceArray) {
        return BasicAutomata.makeStringUnion(charSequenceArray);
    }

    public static Automaton makeMaxInteger(String string) {
        return BasicAutomata.makeMaxInteger(string);
    }

    public static Automaton makeMinInteger(String string) {
        return BasicAutomata.makeMinInteger(string);
    }

    public static Automaton makeTotalDigits(int n2) {
        return BasicAutomata.makeTotalDigits(n2);
    }

    public static Automaton makeFractionDigits(int n2) {
        return BasicAutomata.makeFractionDigits(n2);
    }

    public static Automaton makeIntegerValue(String string) {
        return BasicAutomata.makeIntegerValue(string);
    }

    public static Automaton makeDecimalValue(String string) {
        return BasicAutomata.makeDecimalValue(string);
    }

    public static Automaton makeStringMatcher(String string) {
        return BasicAutomata.makeStringMatcher(string);
    }

    public Automaton concatenate(Automaton automaton) {
        return BasicOperations.concatenate(this, automaton);
    }

    public static Automaton concatenate(List<Automaton> list) {
        return BasicOperations.concatenate(list);
    }

    public Automaton optional() {
        return BasicOperations.optional(this);
    }

    public Automaton repeat() {
        return BasicOperations.repeat(this);
    }

    public Automaton repeat(int n2) {
        return BasicOperations.repeat(this, n2);
    }

    public Automaton repeat(int n2, int n3) {
        return BasicOperations.repeat(this, n2, n3);
    }

    public Automaton complement() {
        return BasicOperations.complement(this);
    }

    public Automaton minus(Automaton automaton) {
        return BasicOperations.minus(this, automaton);
    }

    public Automaton intersection(Automaton automaton) {
        return BasicOperations.intersection(this, automaton);
    }

    public boolean subsetOf(Automaton automaton) {
        return BasicOperations.subsetOf(this, automaton);
    }

    public Automaton union(Automaton automaton) {
        return BasicOperations.union(this, automaton);
    }

    public static Automaton union(Collection<Automaton> collection) {
        return BasicOperations.union(collection);
    }

    public void determinize() {
        BasicOperations.determinize(this);
    }

    public void addEpsilons(Collection<StatePair> collection) {
        BasicOperations.addEpsilons(this, collection);
    }

    public boolean isEmptyString() {
        return BasicOperations.isEmptyString(this);
    }

    public boolean isEmpty() {
        return BasicOperations.isEmpty(this);
    }

    public boolean isTotal() {
        return BasicOperations.isTotal(this);
    }

    public String getShortestExample(boolean bl2) {
        return BasicOperations.getShortestExample(this, bl2);
    }

    public boolean run(String string) {
        return BasicOperations.run(this, string);
    }

    public void minimize() {
        MinimizationOperations.minimize(this);
    }

    public static Automaton minimize(Automaton automaton) {
        automaton.minimize();
        return automaton;
    }

    public Automaton overlap(Automaton automaton) {
        return SpecialOperations.overlap(this, automaton);
    }

    public Automaton singleChars() {
        return SpecialOperations.singleChars(this);
    }

    public Automaton trim(String string, char c2) {
        return SpecialOperations.trim(this, string, c2);
    }

    public Automaton compress(String string, char c2) {
        return SpecialOperations.compress(this, string, c2);
    }

    public Automaton subst(Map<Character, Set<Character>> map) {
        return SpecialOperations.subst(this, map);
    }

    public Automaton subst(char c2, String string) {
        return SpecialOperations.subst(this, c2, string);
    }

    public Automaton homomorph(char[] cArray, char[] cArray2) {
        return SpecialOperations.homomorph(this, cArray, cArray2);
    }

    public Automaton projectChars(Set<Character> set) {
        return SpecialOperations.projectChars(this, set);
    }

    public boolean isFinite() {
        return SpecialOperations.isFinite(this);
    }

    public Set<String> getStrings(int n2) {
        return SpecialOperations.getStrings(this, n2);
    }

    public Set<String> getFiniteStrings() {
        return SpecialOperations.getFiniteStrings(this);
    }

    public Set<String> getFiniteStrings(int n2) {
        return SpecialOperations.getFiniteStrings(this, n2);
    }

    public String getCommonPrefix() {
        return SpecialOperations.getCommonPrefix(this);
    }

    public void prefixClose() {
        SpecialOperations.prefixClose(this);
    }

    public static Automaton hexCases(Automaton automaton) {
        return SpecialOperations.hexCases(automaton);
    }

    public static Automaton replaceWhitespace(Automaton automaton) {
        return SpecialOperations.replaceWhitespace(automaton);
    }

    public static String shuffleSubsetOf(Collection<Automaton> collection, Automaton automaton, Character c2, Character c3) {
        return ShuffleOperations.shuffleSubsetOf(collection, automaton, c2, c3);
    }

    public Automaton shuffle(Automaton automaton) {
        return ShuffleOperations.shuffle(this, automaton);
    }
}

