/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicAutomata;
import com.contrastsecurity.thirdparty.dk.brics.automaton.State;
import com.contrastsecurity.thirdparty.dk.brics.automaton.StatePair;
import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(Automaton automaton, Automaton automaton2) {
        boolean bl2;
        if (automaton.isSingleton() && automaton2.isSingleton()) {
            return BasicAutomata.makeString(automaton.singleton + automaton2.singleton);
        }
        if (BasicOperations.isEmpty(automaton) || BasicOperations.isEmpty(automaton2)) {
            return BasicAutomata.makeEmpty();
        }
        boolean bl3 = bl2 = automaton.isSingleton() && automaton2.isDeterministic();
        if (automaton == automaton2) {
            automaton = automaton.cloneExpanded();
            automaton2 = automaton2.cloneExpanded();
        } else {
            automaton = automaton.cloneExpandedIfRequired();
            automaton2 = automaton2.cloneExpandedIfRequired();
        }
        for (State state : automaton.getAcceptStates()) {
            state.accept = false;
            state.addEpsilon(automaton2.initial);
        }
        automaton.deterministic = bl2;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton concatenate(List<Automaton> list) {
        Automaton automaton4;
        HashSet<Integer> hashSet;
        if (list.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean bl2 = true;
        for (Automaton object : list) {
            if (object.isSingleton()) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            hashSet = new StringBuilder();
            for (Automaton automaton2 : list) {
                ((StringBuilder)((Object)hashSet)).append(automaton2.singleton);
            }
            return BasicAutomata.makeString(((StringBuilder)((Object)hashSet)).toString());
        }
        for (Automaton automaton3 : list) {
            if (!automaton3.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        hashSet = new HashSet<Integer>();
        for (Automaton automaton4 : list) {
            hashSet.add(System.identityHashCode(automaton4));
        }
        boolean bl3 = hashSet.size() != list.size();
        automaton4 = list.get(0);
        automaton4 = bl3 ? automaton4.cloneExpanded() : automaton4.cloneExpandedIfRequired();
        Set<State> set = automaton4.getAcceptStates();
        boolean bl4 = true;
        for (Automaton automaton5 : list) {
            if (bl4) {
                bl4 = false;
                continue;
            }
            if (automaton5.isEmptyString()) continue;
            Automaton automaton6 = automaton5;
            automaton6 = bl3 ? automaton6.cloneExpanded() : automaton6.cloneExpandedIfRequired();
            Set<State> set2 = automaton6.getAcceptStates();
            for (State state : set) {
                state.accept = false;
                state.addEpsilon(automaton6.initial);
                if (!state.accept) continue;
                set2.add(state);
            }
            set = set2;
        }
        automaton4.deterministic = false;
        automaton4.clearHashCode();
        automaton4.checkMinimizeAlways();
        return automaton4;
    }

    public static Automaton optional(Automaton automaton) {
        automaton = automaton.cloneExpandedIfRequired();
        State state = new State();
        state.addEpsilon(automaton.initial);
        state.accept = true;
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton repeat(Automaton automaton) {
        automaton = automaton.cloneExpanded();
        State state = new State();
        state.accept = true;
        state.addEpsilon(automaton.initial);
        for (State state2 : automaton.getAcceptStates()) {
            state2.addEpsilon(state);
        }
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton repeat(Automaton automaton, int n2) {
        if (n2 == 0) {
            return BasicOperations.repeat(automaton);
        }
        ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
        while (n2-- > 0) {
            arrayList.add(automaton);
        }
        arrayList.add(BasicOperations.repeat(automaton));
        return BasicOperations.concatenate(arrayList);
    }

    public static Automaton repeat(Automaton automaton, int n2, int n3) {
        Object object;
        Automaton automaton2;
        if (n2 > n3) {
            return BasicAutomata.makeEmpty();
        }
        n3 -= n2;
        automaton.expandSingleton();
        if (n2 == 0) {
            automaton2 = BasicAutomata.makeEmptyString();
        } else if (n2 == 1) {
            automaton2 = automaton.clone();
        } else {
            object = new ArrayList();
            while (n2-- > 0) {
                object.add((Automaton)automaton);
            }
            automaton2 = BasicOperations.concatenate(object);
        }
        if (n3 > 0) {
            object = automaton.clone();
            while (--n3 > 0) {
                Automaton automaton3 = automaton.clone();
                for (State state : automaton3.getAcceptStates()) {
                    state.addEpsilon(((Automaton)object).initial);
                }
                object = automaton3;
            }
            for (State state : automaton2.getAcceptStates()) {
                state.addEpsilon(((Automaton)object).initial);
            }
            automaton2.deterministic = false;
            automaton2.clearHashCode();
            automaton2.checkMinimizeAlways();
        }
        return automaton2;
    }

    public static Automaton complement(Automaton automaton) {
        automaton = automaton.cloneExpandedIfRequired();
        automaton.determinize();
        automaton.totalize();
        for (State state : automaton.getStates()) {
            state.accept = !state.accept;
        }
        automaton.removeDeadTransitions();
        return automaton;
    }

    public static Automaton minus(Automaton automaton, Automaton automaton2) {
        if (automaton.isEmpty() || automaton == automaton2) {
            return BasicAutomata.makeEmpty();
        }
        if (automaton2.isEmpty()) {
            return automaton.cloneIfRequired();
        }
        if (automaton.isSingleton()) {
            if (automaton2.run(automaton.singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return automaton.cloneIfRequired();
        }
        return BasicOperations.intersection(automaton, automaton2.complement());
    }

    public static Automaton intersection(Automaton automaton, Automaton automaton2) {
        if (automaton.isSingleton()) {
            if (automaton2.run(automaton.singleton)) {
                return automaton.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (automaton2.isSingleton()) {
            if (automaton.run(automaton2.singleton)) {
                return automaton2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (automaton == automaton2) {
            return automaton.cloneIfRequired();
        }
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        Automaton automaton3 = new Automaton();
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> hashMap = new HashMap<StatePair, StatePair>();
        StatePair statePair = new StatePair(automaton3.initial, automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashMap.put(statePair, statePair);
        while (linkedList.size() > 0) {
            statePair = (StatePair)linkedList.removeFirst();
            statePair.s.accept = statePair.s1.accept && statePair.s2.accept;
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            int n2 = 0;
            for (int i2 = 0; i2 < transitionArray3.length; ++i2) {
                while (n2 < transitionArray4.length && transitionArray4[n2].max < transitionArray3[i2].min) {
                    ++n2;
                }
                for (int i3 = n2; i3 < transitionArray4.length && transitionArray3[i2].max >= transitionArray4[i3].min; ++i3) {
                    if (transitionArray4[i3].max < transitionArray3[i2].min) continue;
                    StatePair statePair2 = new StatePair(transitionArray3[i2].to, transitionArray4[i3].to);
                    StatePair statePair3 = (StatePair)hashMap.get(statePair2);
                    if (statePair3 == null) {
                        statePair2.s = new State();
                        linkedList.add(statePair2);
                        hashMap.put(statePair2, statePair2);
                        statePair3 = statePair2;
                    }
                    char c2 = transitionArray3[i2].min > transitionArray4[i3].min ? transitionArray3[i2].min : transitionArray4[i3].min;
                    char c3 = transitionArray3[i2].max < transitionArray4[i3].max ? transitionArray3[i2].max : transitionArray4[i3].max;
                    statePair.s.transitions.add(new Transition(c2, c3, statePair3.s));
                }
            }
        }
        automaton3.deterministic = automaton.deterministic && automaton2.deterministic;
        automaton3.removeDeadTransitions();
        automaton3.checkMinimizeAlways();
        return automaton3;
    }

    public static boolean subsetOf(Automaton automaton, Automaton automaton2) {
        if (automaton == automaton2) {
            return true;
        }
        if (automaton.isSingleton()) {
            if (automaton2.isSingleton()) {
                return automaton.singleton.equals(automaton2.singleton);
            }
            return automaton2.run(automaton.singleton);
        }
        automaton2.determinize();
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        StatePair statePair = new StatePair(automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashSet.add(statePair);
        while (linkedList.size() > 0) {
            statePair = (StatePair)linkedList.removeFirst();
            if (statePair.s1.accept && !statePair.s2.accept) {
                return false;
            }
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            int n2 = 0;
            for (int i2 = 0; i2 < transitionArray3.length; ++i2) {
                while (n2 < transitionArray4.length && transitionArray4[n2].max < transitionArray3[i2].min) {
                    ++n2;
                }
                char c2 = transitionArray3[i2].min;
                char c3 = transitionArray3[i2].max;
                for (int i3 = n2; i3 < transitionArray4.length && transitionArray3[i2].max >= transitionArray4[i3].min; ++i3) {
                    if (transitionArray4[i3].min > c2) {
                        return false;
                    }
                    if (transitionArray4[i3].max < '\uffff') {
                        c2 = transitionArray4[i3].max + '\u0001';
                    } else {
                        c2 = '\uffff';
                        c3 = '\u0000';
                    }
                    StatePair statePair2 = new StatePair(transitionArray3[i2].to, transitionArray4[i3].to);
                    if (hashSet.contains(statePair2)) continue;
                    linkedList.add(statePair2);
                    hashSet.add(statePair2);
                }
                if (c2 > c3) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton automaton, Automaton automaton2) {
        if (automaton.isSingleton() && automaton2.isSingleton() && automaton.singleton.equals(automaton2.singleton) || automaton == automaton2) {
            return automaton.cloneIfRequired();
        }
        automaton = automaton.cloneExpandedIfRequired();
        automaton2 = automaton2.cloneExpandedIfRequired();
        State state = new State();
        state.addEpsilon(automaton.initial);
        state.addEpsilon(automaton2.initial);
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton union(Collection<Automaton> collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Automaton serializable2 : collection) {
            hashSet.add(System.identityHashCode(serializable2));
        }
        boolean bl2 = hashSet.size() != collection.size();
        State state = new State();
        for (Automaton automaton : collection) {
            if (automaton.isEmpty()) continue;
            Automaton automaton2 = automaton;
            automaton2 = bl2 ? automaton2.cloneExpanded() : automaton2.cloneExpandedIfRequired();
            state.addEpsilon(automaton2.initial);
        }
        Automaton automaton = new Automaton();
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static void determinize(Automaton automaton) {
        if (automaton.deterministic || automaton.isSingleton()) {
            return;
        }
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.add(automaton.initial);
        BasicOperations.determinize(automaton, hashSet);
    }

    static void determinize(Automaton automaton, Set<State> set) {
        char[] cArray = automaton.getStartPoints();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        linkedList.add(set);
        automaton.initial = new State();
        hashMap.put(set, automaton.initial);
        while (linkedList.size() > 0) {
            Set set2 = (Set)linkedList.removeFirst();
            State state = (State)hashMap.get(set2);
            for (Serializable serializable : set2) {
                if (!((State)serializable).accept) continue;
                state.accept = true;
                break;
            }
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                Serializable serializable;
                serializable = new HashSet();
                for (State state2 : set2) {
                    for (Transition transition : state2.transitions) {
                        if (transition.min > cArray[i2] || cArray[i2] > transition.max) continue;
                        serializable.add(transition.to);
                    }
                }
                if (serializable.isEmpty()) continue;
                Object object = (State)hashMap.get(serializable);
                if (object == null) {
                    linkedList.add(serializable);
                    object = new State();
                    hashMap.put(serializable, object);
                }
                char c2 = cArray[i2];
                char c3 = i2 + 1 < cArray.length ? (char)((char)(cArray[i2 + 1] - '\u0001')) : (char)'\uffff';
                state.transitions.add(new Transition(c2, c3, (State)object));
            }
        }
        automaton.deterministic = true;
        automaton.removeDeadTransitions();
    }

    /*
     * WARNING - void declaration
     */
    public static void addEpsilons(Automaton automaton, Collection<StatePair> collection) {
        HashSet<State> hashSet;
        automaton.expandSingleton();
        HashMap<State, Object> hashMap = new HashMap<State, Object>();
        HashMap hashMap2 = new HashMap();
        for (StatePair object2 : collection) {
            void var7_8;
            hashSet = (HashSet<State>)hashMap.get(object2.s1);
            if (hashSet == null) {
                hashSet = new HashSet<State>();
                hashMap.put(object2.s1, hashSet);
            }
            hashSet.add(object2.s2);
            HashSet hashSet2 = (HashSet)hashMap2.get(object2.s2);
            if (hashSet2 == null) {
                HashSet hashSet3 = new HashSet();
                hashMap2.put(object2.s2, hashSet3);
            }
            var7_8.add(object2.s1);
        }
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>(collection);
        HashSet<StatePair> hashSet4 = new HashSet<StatePair>(collection);
        while (!linkedList.isEmpty()) {
            hashSet = (StatePair)linkedList.removeFirst();
            hashSet4.remove(hashSet);
            HashSet hashSet5 = (HashSet)hashMap.get(((StatePair)((Object)hashSet)).s2);
            HashSet hashSet6 = (HashSet)hashMap2.get(((StatePair)((Object)hashSet)).s1);
            if (hashSet5 == null) continue;
            for (State state : hashSet5) {
                StatePair statePair = new StatePair(((StatePair)((Object)hashSet)).s1, state);
                if (collection.contains(statePair)) continue;
                collection.add(statePair);
                ((HashSet)hashMap.get(((StatePair)((Object)hashSet)).s1)).add(state);
                ((HashSet)hashMap2.get(state)).add(((StatePair)((Object)hashSet)).s1);
                linkedList.add(statePair);
                hashSet4.add(statePair);
                if (hashSet6 == null) continue;
                for (State state2 : hashSet6) {
                    StatePair statePair2 = new StatePair(state2, ((StatePair)((Object)hashSet)).s1);
                    if (hashSet4.contains(statePair2)) continue;
                    linkedList.add(statePair2);
                    hashSet4.add(statePair2);
                }
            }
        }
        for (StatePair statePair : collection) {
            statePair.s1.addEpsilon(statePair.s2);
        }
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton automaton) {
        if (automaton.isSingleton()) {
            return automaton.singleton.length() == 0;
        }
        return automaton.initial.accept && automaton.initial.transitions.isEmpty();
    }

    public static boolean isEmpty(Automaton automaton) {
        if (automaton.isSingleton()) {
            return false;
        }
        return !automaton.initial.accept && automaton.initial.transitions.isEmpty();
    }

    public static boolean isTotal(Automaton automaton) {
        if (automaton.isSingleton()) {
            return false;
        }
        if (automaton.initial.accept && automaton.initial.transitions.size() == 1) {
            Transition transition = automaton.initial.transitions.iterator().next();
            return transition.to == automaton.initial && transition.min == '\u0000' && transition.max == '\uffff';
        }
        return false;
    }

    public static String getShortestExample(Automaton automaton, boolean bl2) {
        if (automaton.isSingleton()) {
            if (bl2) {
                return automaton.singleton;
            }
            if (automaton.singleton.length() > 0) {
                return "";
            }
            return "\u0000";
        }
        return BasicOperations.getShortestExample(automaton.getInitialState(), bl2);
    }

    static String getShortestExample(State state, boolean bl2) {
        HashMap<State, String> hashMap = new HashMap<State, String>();
        LinkedList<State> linkedList = new LinkedList<State>();
        hashMap.put(state, "");
        linkedList.add(state);
        String string = null;
        while (!linkedList.isEmpty()) {
            State state2 = (State)linkedList.removeFirst();
            String string2 = (String)hashMap.get(state2);
            if (state2.accept == bl2) {
                if (string != null && string2.length() >= string.length() && (string2.length() != string.length() || string2.compareTo(string) >= 0)) continue;
                string = string2;
                continue;
            }
            for (Transition transition : state2.getTransitions()) {
                String string3 = (String)hashMap.get(transition.to);
                String string4 = string2 + transition.min;
                if (string3 != null && (string3.length() != string4.length() || string4.compareTo(string3) >= 0)) continue;
                if (string3 == null) {
                    linkedList.addLast(transition.to);
                }
                hashMap.put(transition.to, string4);
            }
        }
        return string;
    }

    public static boolean run(Automaton automaton, String string) {
        if (automaton.isSingleton()) {
            return string.equals(automaton.singleton);
        }
        if (automaton.deterministic) {
            State state = automaton.initial;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                State state2 = state.step(string.charAt(i2));
                if (state2 == null) {
                    return false;
                }
                state = state2;
            }
            return state.accept;
        }
        Set<State> set = automaton.getStates();
        Automaton.setStateNumbers(set);
        LinkedList<State> linkedList = new LinkedList<State>();
        Object object = new LinkedList();
        BitSet bitSet = new BitSet(set.size());
        Serializable serializable = new BitSet(set.size());
        linkedList.add(automaton.initial);
        ArrayList<State> arrayList = new ArrayList<State>();
        boolean bl2 = automaton.initial.accept;
        for (int i3 = 0; i3 < string.length(); ++i3) {
            Serializable serializable22;
            char c2 = string.charAt(i3);
            bl2 = false;
            ((LinkedList)object).clear();
            ((BitSet)serializable).clear();
            for (Serializable serializable22 : linkedList) {
                arrayList.clear();
                serializable22.step(c2, arrayList);
                for (State state : arrayList) {
                    if (state.accept) {
                        bl2 = true;
                    }
                    if (((BitSet)serializable).get(state.number)) continue;
                    ((BitSet)serializable).set(state.number);
                    ((LinkedList)object).add(state);
                }
            }
            LinkedList<State> linkedList2 = linkedList;
            linkedList = object;
            object = linkedList2;
            serializable22 = bitSet;
            bitSet = serializable;
            serializable = serializable22;
        }
        return bl2;
    }
}

