/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class StringUnionOperations {
    public static final Comparator<CharSequence> LEXICOGRAPHIC_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            int n2 = charSequence.length();
            int n3 = charSequence2.length();
            int n4 = Math.min(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                char c2;
                char c3 = charSequence.charAt(i2);
                if (c3 == (c2 = charSequence2.charAt(i2))) continue;
                return c3 - c2;
            }
            return n2 - n3;
        }
    };
    private HashMap<State, State> register = new HashMap();
    private State root = new State();
    private StringBuilder previous;

    public void add(CharSequence charSequence) {
        State state;
        int n2;
        assert (this.register != null) : "Automaton already built.";
        assert (charSequence.length() > 0) : "Input sequences must not be empty.";
        assert (this.previous == null || LEXICOGRAPHIC_ORDER.compare(this.previous, charSequence) <= 0) : "Input must be sorted: " + this.previous + " >= " + charSequence;
        assert (this.setPrevious(charSequence));
        int n3 = charSequence.length();
        State state2 = this.root;
        for (n2 = 0; n2 < n3 && (state = state2.lastChild(charSequence.charAt(n2))) != null; ++n2) {
            state2 = state;
        }
        if (state2.hasChildren()) {
            this.replaceOrRegister(state2);
        }
        this.addSuffix(state2, charSequence, n2);
    }

    public State complete() {
        if (this.register == null) {
            throw new IllegalStateException();
        }
        if (this.root.hasChildren()) {
            this.replaceOrRegister(this.root);
        }
        this.register = null;
        return this.root;
    }

    private static com.contrastsecurity.thirdparty.dk.brics.automaton.State convert(State state, IdentityHashMap<State, com.contrastsecurity.thirdparty.dk.brics.automaton.State> identityHashMap) {
        com.contrastsecurity.thirdparty.dk.brics.automaton.State state2 = identityHashMap.get(state);
        if (state2 != null) {
            return state2;
        }
        state2 = new com.contrastsecurity.thirdparty.dk.brics.automaton.State();
        state2.setAccept(state.is_final);
        identityHashMap.put(state, state2);
        int n2 = 0;
        char[] cArray = state.labels;
        for (State state3 : state.states) {
            state2.addTransition(new Transition(cArray[n2++], StringUnionOperations.convert(state3, identityHashMap)));
        }
        return state2;
    }

    public static com.contrastsecurity.thirdparty.dk.brics.automaton.State build(CharSequence[] charSequenceArray) {
        StringUnionOperations stringUnionOperations = new StringUnionOperations();
        for (CharSequence charSequence : charSequenceArray) {
            stringUnionOperations.add(charSequence);
        }
        return StringUnionOperations.convert(stringUnionOperations.complete(), new IdentityHashMap<State, com.contrastsecurity.thirdparty.dk.brics.automaton.State>());
    }

    private boolean setPrevious(CharSequence charSequence) {
        if (this.previous == null) {
            this.previous = new StringBuilder();
        }
        this.previous.setLength(0);
        this.previous.append(charSequence);
        return true;
    }

    private void replaceOrRegister(State state) {
        State state2;
        State state3 = state.lastChild();
        if (state3.hasChildren()) {
            this.replaceOrRegister(state3);
        }
        if ((state2 = this.register.get(state3)) != null) {
            state.replaceLastChild(state2);
        } else {
            this.register.put(state3, state3);
        }
    }

    private void addSuffix(State state, CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        for (int i2 = n2; i2 < n3; ++i2) {
            state = state.newState(charSequence.charAt(i2));
        }
        state.is_final = true;
    }

    static final class State {
        private static final char[] NO_LABELS = new char[0];
        private static final State[] NO_STATES = new State[0];
        char[] labels = NO_LABELS;
        State[] states = NO_STATES;
        boolean is_final;

        State() {
        }

        public State getState(char c2) {
            int n2 = Arrays.binarySearch(this.labels, c2);
            return n2 >= 0 ? this.states[n2] : null;
        }

        public char[] getTransitionLabels() {
            return this.labels;
        }

        public State[] getStates() {
            return this.states;
        }

        public boolean equals(Object object) {
            State state = (State)object;
            return this.is_final == state.is_final && Arrays.equals(this.labels, state.labels) && State.referenceEquals(this.states, state.states);
        }

        public boolean hasChildren() {
            return this.labels.length > 0;
        }

        public boolean isFinal() {
            return this.is_final;
        }

        public int hashCode() {
            int n2 = this.is_final ? 1 : 0;
            n2 ^= n2 * 31 + this.labels.length;
            for (char c3 : this.labels) {
                n2 ^= n2 * 31 + c3;
            }
            for (State state : this.states) {
                n2 ^= System.identityHashCode(state);
            }
            return n2;
        }

        State newState(char c2) {
            assert (Arrays.binarySearch(this.labels, c2) < 0) : "State already has transition labeled: " + c2;
            this.labels = State.copyOf(this.labels, this.labels.length + 1);
            this.states = State.copyOf(this.states, this.states.length + 1);
            this.labels[this.labels.length - 1] = c2;
            State state = new State();
            this.states[this.states.length - 1] = state;
            return state;
        }

        State lastChild() {
            assert (this.hasChildren()) : "No outgoing transitions.";
            return this.states[this.states.length - 1];
        }

        State lastChild(char c2) {
            int n2 = this.labels.length - 1;
            State state = null;
            if (n2 >= 0 && this.labels[n2] == c2) {
                state = this.states[n2];
            }
            assert (state == this.getState(c2));
            return state;
        }

        void replaceLastChild(State state) {
            assert (this.hasChildren()) : "No outgoing transitions.";
            this.states[this.states.length - 1] = state;
        }

        private static char[] copyOf(char[] cArray, int n2) {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n2));
            return cArray2;
        }

        public static State[] copyOf(State[] stateArray, int n2) {
            State[] stateArray2 = new State[n2];
            System.arraycopy(stateArray, 0, stateArray2, 0, Math.min(stateArray.length, n2));
            return stateArray2;
        }

        private static boolean referenceEquals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == objectArray2[i2]) continue;
                return false;
            }
            return true;
        }
    }
}

