/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton.extension;

import java.util.EnumSet;
import java.util.Set;

interface Command {
    public static final Command NO_OP = (preProcessingState, stringBuilder) -> {};

    public void execute(PreProcessingState var1, StringBuilder var2);

    public static Command addChar(char c2) {
        return (preProcessingState, stringBuilder) -> stringBuilder.append(c2);
    }

    public static Command addReplacement(String string) {
        return (preProcessingState, stringBuilder) -> {
            if (preProcessingState.isFlagSet(StateFlags.IN_CHAR_CLASS) || preProcessingState.isFlagSet(StateFlags.IN_CHAR_CLASS_NEGATED)) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append('[').append(string).append(']');
            }
        };
    }

    public static Command addString(String string) {
        return (preProcessingState, stringBuilder) -> stringBuilder.append(string);
    }

    public static Command setState(StateFlags stateFlags) {
        return (preProcessingState, stringBuilder) -> preProcessingState.setFlag(stateFlags);
    }

    public static Command clearState(StateFlags stateFlags) {
        return (preProcessingState, stringBuilder) -> preProcessingState.clearFlag(stateFlags);
    }

    public static Command composite(Command ... commandArray) {
        return (preProcessingState, stringBuilder) -> {
            for (Command command : commandArray) {
                command.execute(preProcessingState, stringBuilder);
            }
        };
    }

    public static Command advanceChars(int n2) {
        return (preProcessingState, stringBuilder) -> preProcessingState.advanceChars(n2);
    }

    public static Command noop() {
        return NO_OP;
    }

    public static enum StateFlags {
        IN_CHAR_CLASS,
        IN_CHAR_CLASS_NEGATED,
        IN_ESCAPE,
        IN_START_GROUP_WITH_FLAGS,
        IN_START_NO_NON_GROUP,
        CHAR_CLASS_HAS_LITERAL_DASH;

    }

    public static final class PreProcessingState {
        private final Set<StateFlags> flags = EnumSet.noneOf(StateFlags.class);
        private final int maxLen;
        private int currentPos;

        PreProcessingState(int n2) {
            this.maxLen = n2;
        }

        void advanceChars(int n2) {
            this.currentPos += n2;
            if (this.currentPos > this.maxLen) {
                throw new IllegalStateException("Current pos " + this.currentPos + " is greater than max len " + this.maxLen);
            }
        }

        Set<StateFlags> flags() {
            return this.flags;
        }

        boolean isFlagSet(StateFlags stateFlags) {
            return this.flags.contains((Object)stateFlags);
        }

        void setFlag(StateFlags stateFlags) {
            this.flags.add(stateFlags);
        }

        void clearFlag(StateFlags stateFlags) {
            this.flags.remove((Object)stateFlags);
        }

        int getPos() {
            return this.currentPos;
        }
    }
}

