/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton.extension;

import com.contrastsecurity.thirdparty.dk.brics.automaton.extension.Command;
import com.contrastsecurity.thirdparty.dk.brics.automaton.extension.PatternWithFlags;
import java.util.HashSet;
import java.util.Iterator;

final class PatternPreProcessor {
    private Command.PreProcessingState state;
    private int internalFlags;
    private String pattern;
    private int len;
    private boolean caseInsensitive;
    private boolean extendedChar;
    static final String REPLACEMENT_WHITESPACE = " \f\n\r\t";
    static final String REPLACEMENT_WHITESPACE_EXTENDED = " \f\n\r\t\u000b\u001c\u001d\u001e\u001f";
    static final String REPLACEMENT_NOT_WHITESPACE = "^ \f\n\r\t";
    static final String REPLACEMENT_NOT_WHITESPACE_EXTENDED = "^ \f\n\r\t\u000b\u001c\u001d\u001e\u001f";
    static final String REPLACEMENT_WORD = "a-zA-Z_0-9";
    static final String REPLACEMENT_NOT_WORD = "^a-zA-Z_0-9";
    static final String REPLACEMENT_DIGIT = "0-9";
    static final String REPLACEMENT_NOT_DIGIT = "^0-9";

    PatternPreProcessor() {
    }

    PatternWithFlags process(String string, boolean bl2, boolean bl3) {
        this.len = string.length();
        this.state = new Command.PreProcessingState(this.len);
        this.pattern = string;
        this.caseInsensitive = bl2;
        this.extendedChar = bl3;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        this.state.setFlag(Command.StateFlags.IN_START_NO_NON_GROUP);
        while (this.state.getPos() < this.len) {
            int n2 = this.state.getPos();
            char c2 = string.charAt(n2);
            char c3 = n2 == this.len - 1 ? (char)'\u0000' : string.charAt(n2 + 1);
            Command command = this.command(c2, c3);
            command.execute(this.state, stringBuilder);
            this.state.advanceChars(1);
        }
        this.state.clearFlag(Command.StateFlags.IN_START_NO_NON_GROUP);
        if (!this.state.flags().isEmpty()) {
            throw new IllegalArgumentException("State not empty at end of pre-formatting string, state is: " + this.state.flags());
        }
        return new PatternWithFlags(stringBuilder.toString(), this.internalFlags);
    }

    private Command command(char c2, char c3) {
        if (this.state.isFlagSet(Command.StateFlags.IN_ESCAPE)) {
            return Command.composite(this.handleInEscape(c2), Command.clearState(Command.StateFlags.IN_START_NO_NON_GROUP));
        }
        if (this.state.isFlagSet(Command.StateFlags.IN_START_GROUP_WITH_FLAGS)) {
            return this.handleInGroup(c2);
        }
        if (this.inCharClass()) {
            return this.handleInCharClass(c2, c3);
        }
        return this.handleGeneral(c2, c3);
    }

    private Command handleGeneral(char c2, char c3) {
        if (c2 == '\\') {
            return Command.setState(Command.StateFlags.IN_ESCAPE);
        }
        if (c2 == '[') {
            Command.StateFlags stateFlags = c3 == '^' ? Command.StateFlags.IN_CHAR_CLASS_NEGATED : Command.StateFlags.IN_CHAR_CLASS;
            return Command.composite(Command.setState(stateFlags), Command.addChar(c2), Command.clearState(Command.StateFlags.IN_START_NO_NON_GROUP));
        }
        if (c2 == '(' && c3 == '?') {
            return Command.setState(Command.StateFlags.IN_START_GROUP_WITH_FLAGS);
        }
        if (c2 == '(' || c2 == ')') {
            return Command.addChar(c2);
        }
        return Command.composite(Command.clearState(Command.StateFlags.IN_START_NO_NON_GROUP), this.handleGeneralCaseInsensitive(c2));
    }

    private Command handleGeneralCaseInsensitive(char c2) {
        String string;
        if (!this.caseInsensitive) {
            return Command.addChar(c2);
        }
        boolean bl2 = this.inCharClass();
        String string2 = bl2 ? "" : "[";
        String string3 = string = bl2 ? "" : "]";
        if (Character.isUpperCase(c2)) {
            return Command.addString(string2 + c2 + Character.toLowerCase(c2) + string);
        }
        if (Character.isLowerCase(c2)) {
            return Command.addString(string2 + c2 + Character.toUpperCase(c2) + string);
        }
        return Command.addChar(c2);
    }

    private Command handleInGroup(char c2) {
        if (c2 == ')') {
            return Command.composite(Command.clearState(Command.StateFlags.IN_START_GROUP_WITH_FLAGS), Command.addString("()"));
        }
        if (c2 == ':' || c2 == '>') {
            return Command.composite(Command.clearState(Command.StateFlags.IN_START_GROUP_WITH_FLAGS), Command.addChar('('));
        }
        return Command.noop();
    }

    private Command handleInCharClass(char c2, char c3) {
        if (c2 == ']') {
            Command command = this.state.isFlagSet(Command.StateFlags.CHAR_CLASS_HAS_LITERAL_DASH) ? Command.addChar('-') : Command.noop();
            return Command.composite(Command.clearState(Command.StateFlags.IN_CHAR_CLASS), command, Command.clearState(Command.StateFlags.IN_CHAR_CLASS_NEGATED), Command.clearState(Command.StateFlags.CHAR_CLASS_HAS_LITERAL_DASH), Command.addChar(c2));
        }
        if (c2 != '\\' && c3 == '-') {
            char c4 = this.peekAhead(2);
            if (c4 == ']') {
                return this.handleGeneral(c2, c3);
            }
            String string = this.adjustCharClassRangeForCase(c2, c4);
            return Command.composite(Command.advanceChars(2), Command.addString(string));
        }
        if (c2 == '-') {
            return Command.setState(Command.StateFlags.CHAR_CLASS_HAS_LITERAL_DASH);
        }
        return this.handleGeneral(c2, c3);
    }

    private Command handleInEscape(char c2) {
        if (c2 == '\\') {
            return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addString("\\\\"));
        }
        Command command = this.handleReplacements(c2);
        if (command != null) {
            return command;
        }
        boolean bl2 = this.isBricsTokenRequiringEscape(c2);
        if (bl2) {
            return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addString("\\" + c2));
        }
        return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addString("\\\\" + c2));
    }

    private Command handleReplacements(char c2) {
        switch (c2) {
            case 's': {
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), this.extendedChar ? Command.addReplacement(REPLACEMENT_WHITESPACE_EXTENDED) : Command.addReplacement(REPLACEMENT_WHITESPACE));
            }
            case 'S': {
                if (this.inCharClass()) {
                    throw new IllegalArgumentException("Unable to support \\S in char class, instead use alternations");
                }
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), this.extendedChar ? Command.addReplacement(REPLACEMENT_NOT_WHITESPACE_EXTENDED) : Command.addReplacement(REPLACEMENT_NOT_WHITESPACE));
            }
            case 'w': {
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addReplacement(REPLACEMENT_WORD));
            }
            case 'W': {
                if (this.inCharClass()) {
                    throw new IllegalArgumentException("Unable to support \\W in char class, instead use alternations");
                }
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addReplacement(REPLACEMENT_NOT_WORD));
            }
            case 'd': {
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addReplacement(REPLACEMENT_DIGIT));
            }
            case 'D': {
                if (this.inCharClass()) {
                    throw new IllegalArgumentException("Unable to support \\D in char class, instead use alternations");
                }
                return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addReplacement(REPLACEMENT_NOT_DIGIT));
            }
            case 'b': {
                return this.handleWordBoundary();
            }
        }
        return null;
    }

    private Command handleWordBoundary() {
        if (this.inCharClass()) {
            throw new IllegalArgumentException("\\b in char class");
        }
        if (this.state.isFlagSet(Command.StateFlags.IN_START_NO_NON_GROUP)) {
            this.internalFlags |= 1;
        }
        if (this.peekToEndGroupOnly()) {
            this.internalFlags |= 2;
        }
        return Command.composite(Command.clearState(Command.StateFlags.IN_ESCAPE), Command.addReplacement(REPLACEMENT_NOT_WORD));
    }

    private boolean inCharClass() {
        return this.state.isFlagSet(Command.StateFlags.IN_CHAR_CLASS) || this.inNegatedCharClass();
    }

    private boolean inNegatedCharClass() {
        return this.state.isFlagSet(Command.StateFlags.IN_CHAR_CLASS_NEGATED);
    }

    private boolean isBricsTokenRequiringEscape(char c2) {
        return this.inCharClass() ? this.isBricsTokenInCharClass(c2) : PatternPreProcessor.isBricsToken(c2);
    }

    private static boolean isBricsToken(char c2) {
        switch (c2) {
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private boolean isBricsTokenInCharClass(char c2) {
        return c2 == '[' || c2 == ']' || c2 == '-';
    }

    private boolean peekToEndGroupOnly() {
        for (int i2 = this.state.getPos() + 1; i2 < this.len; ++i2) {
            char c2 = this.pattern.charAt(i2);
            if (')' == c2) continue;
            return false;
        }
        return true;
    }

    private char peekAhead(int n2) {
        int n3 = this.state.getPos();
        return n3 + n2 >= this.len ? (char)'0' : this.pattern.charAt(n3 + n2);
    }

    private String adjustCharClassRangeForCase(char c2, char c3) {
        if (!this.caseInsensitive) {
            return c2 + "-" + c3;
        }
        HashSet<Character> hashSet = new HashSet<Character>();
        for (char c4 = c2; c4 <= c3; c4 = (char)(c4 + '\u0001')) {
            if (Character.isUpperCase(c4)) {
                hashSet.add(Character.valueOf(Character.toLowerCase(c4)));
                continue;
            }
            if (!Character.isLowerCase(c4)) continue;
            hashSet.add(Character.valueOf(Character.toUpperCase(c4)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            char c5 = ((Character)iterator.next()).charValue();
            stringBuilder.append(c5);
        }
        return c2 + "-" + c3 + stringBuilder;
    }
}

