/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.common;

import com.contrastsecurity.thirdparty.io.micrometer.common.ImmutableKeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.ValidatedKeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.docs.KeyName;
import java.util.function.Function;
import java.util.function.Predicate;

public interface KeyValue
extends Comparable<KeyValue> {
    public static final String NONE_VALUE = "none";

    public String getKey();

    public String getValue();

    public static KeyValue of(String string, String string2) {
        return new ImmutableKeyValue(string, string2);
    }

    public static KeyValue of(KeyName keyName, String string) {
        return KeyValue.of(keyName.asString(), string);
    }

    public static <E> KeyValue of(E e2, Function<E, String> function, Function<E, String> function2) {
        return KeyValue.of(function.apply(e2), function2.apply(e2));
    }

    public static <T> KeyValue of(String string, T t2, Predicate<? super T> predicate) {
        return new ValidatedKeyValue<T>(string, t2, predicate);
    }

    public static <T> KeyValue of(KeyName keyName, T t2, Predicate<? super T> predicate) {
        return KeyValue.of(keyName.asString(), t2, predicate);
    }

    @Override
    default public int compareTo(KeyValue keyValue) {
        return this.getKey().compareTo(keyValue.getKey());
    }
}

